/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.internal.builds.ui.BuildImages;
import org.eclipse.mylyn.internal.builds.ui.util.TestResultManager;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class ShowTestResultsAction
extends BaseSelectionListenerAction {
    public ShowTestResultsAction() {
        super("Show Test Results");
        this.setToolTipText("Show Test Results in JUnit View");
        this.setImageDescriptor(BuildImages.JUNIT);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!TestResultManager.isJUnitAvailable()) {
            return false;
        }
        if (selection.getFirstElement() instanceof IBuildPlan) {
            return this.isEnabled(((IBuildPlan)selection.getFirstElement()).getLastBuild());
        }
        if (selection.getFirstElement() instanceof IBuild) {
            return this.isEnabled((IBuild)selection.getFirstElement());
        }
        return false;
    }

    private boolean isEnabled(IBuild build) {
        return build != null && build.getTestResult() != null;
    }

    public void run() {
        Object selection = this.getStructuredSelection().getFirstElement();
        if (selection instanceof IBuildPlan) {
            IBuildPlan plan = (IBuildPlan)selection;
            TestResultManager.showInJUnitView(plan.getLastBuild());
        } else if (selection instanceof IBuild) {
            IBuild build = (IBuild)selection;
            TestResultManager.showInJUnitView(build);
        }
    }
}

