/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.tests.common;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;

public class HttxWagon
extends HttpWagon {
    static String PROTOCOL = "httx";
    private static List<String> requests = new ArrayList<String>();
    private static String requestFilterPattern;
    private static String requestFailPattern;

    public static List<String> getRequests() {
        return requests;
    }

    public static void setRequestFilterPattern(String regex, boolean clear) {
        requestFilterPattern = regex;
        if (clear) {
            requests.clear();
        }
    }

    public static void setRequestFailPattern(String regex) {
        requestFailPattern = regex;
    }

    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        if (PROTOCOL.equals(repository.getProtocol())) {
            repository.setUrl("https" + repository.getUrl().substring(PROTOCOL.length()));
        }
        super.connect(repository, authenticationInfo, proxyInfoProvider);
    }

    protected InputStream getInputStream(Resource resource) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        HttxWagon.recordOperation("GET", resource);
        return super.getInputStream(resource);
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        HttxWagon.recordOperation("PUT", outputData.getResource());
        super.fillOutputData(outputData);
    }

    private static void recordOperation(String op, Resource resource) throws TransferFailedException {
        String name = resource.getName();
        if (requestFilterPattern == null || name.matches(requestFilterPattern)) {
            requests.add(String.valueOf(op) + " " + name);
        }
        if (requestFailPattern != null && name.matches(requestFailPattern)) {
            throw new TransferFailedException("Test failure");
        }
    }

    public static void reset() {
        requestFailPattern = null;
        requestFilterPattern = null;
        requests.clear();
    }
}

