/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.Util;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandMessages;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerContentProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.ide.handlers.ShowInSystemExplorerHandler;

public class ShowInSystemExplorerCommandHandler
extends AbstractHandler {
    private static final String VARIABLE_RESOURCE = "${selected_resource_loc}";
    private static final String VARIABLE_RESOURCE_URI = "${selected_resource_uri}";
    private static final String VARIABLE_FOLDER = "${selected_resource_parent_loc}";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        List<DockerExplorerContentProvider.DockerContainerVolume> volumes = CommandUtils.getSelectedVolumes(activePart);
        if (volumes == null || volumes.isEmpty()) {
            return null;
        }
        DockerExplorerContentProvider.DockerContainerVolume selectedVolume = volumes.get(0);
        final File hostFile = new File(selectedVolume.getHostPath());
        final String launchCmd = this.getShowInSystemExplorerCommand(hostFile);
        if (launchCmd == null) {
            return null;
        }
        Job job = new Job(CommandMessages.getString("command.showIn.systemExplorer")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        Process p = ShowInSystemExplorerCommandHandler.this.getLaunchProcess(launchCmd, hostFile);
                        int retCode = p.waitFor();
                        if (retCode != 0 && !Util.isWindows()) {
                            Activator.log(new DockerException(CommandMessages.getFormattedString("command.showIn.systemExplorer.failure.command.execute", launchCmd, Integer.toString(retCode))));
                        }
                    }
                    catch (IOException | InterruptedException e) {
                        Activator.logErrorMessage(CommandMessages.getFormattedString("command.showIn.systemExplorer.failure", launchCmd), e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    private Process getLaunchProcess(String launchCmd, File dir) throws IOException {
        File workingDir;
        File file = workingDir = dir.isDirectory() ? dir : dir.getParentFile();
        if (Util.isLinux() || Util.isMac()) {
            return Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", launchCmd}, null, workingDir);
        }
        return Runtime.getRuntime().exec(launchCmd, null, workingDir);
    }

    private String getShowInSystemExplorerCommand(File path) {
        String command = ShowInSystemExplorerHandler.getDefaultCommand();
        if ("".equals(command)) {
            Activator.log(new DockerException(CommandMessages.getString("command.showIn.systemExplorer.failure.command_unavailable")));
            return null;
        }
        try {
            command = Util.replaceAll((String)command, (String)VARIABLE_RESOURCE, (String)this.quotePath(path.getCanonicalPath()));
            command = Util.replaceAll((String)command, (String)VARIABLE_RESOURCE_URI, (String)path.getCanonicalFile().toURI().toString());
            File parent = path.getParentFile();
            if (parent != null) {
                command = Util.replaceAll((String)command, (String)VARIABLE_FOLDER, (String)this.quotePath(parent.getCanonicalPath()));
            }
            return command;
        }
        catch (IOException e) {
            Activator.logErrorMessage(CommandMessages.getString("command.showIn.systemExplorer.failure"), e);
            return null;
        }
    }

    private String quotePath(String path) {
        if (Util.isLinux() || Util.isMac()) {
            path = path.replaceAll("[\"$`]", "\\\\$0");
        }
        return path;
    }
}

