/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.cdt.libhover.ClassInfo;
import org.eclipse.linuxtools.cdt.libhover.FunctionInfo;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.eclipse.linuxtools.cdt.libhover.MemberInfo;
import org.eclipse.linuxtools.cdt.libhover.TypedefInfo;
import org.eclipse.linuxtools.internal.cdt.libhover.utils.LibhoverInfoGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CDoxygenLibhoverGen
extends LibhoverInfoGenerator {
    private static final String PROT3 = "prot";
    private static final String RETURN = "return";
    private static final String PARAMETERDESCRIPTION = "parameterdescription";
    private static final String PARAMETERNAME = "parametername";
    private static final String PARAMETERNAMELIST = "parameternamelist";
    private static final String PARAMETERITEM = "parameteritem";
    private static final String EXCEPTION = "exception";
    private static final String DEFINITION = "definition";
    private static final String TYPEDEF2 = "typedef";
    private static final String REFID2 = "refid";
    private static final String REF = "ref";
    private static final String PUBLIC_FUNC = "public-func";
    private static final String BASECOMPOUNDREF = "basecompoundref";
    private static final String INCLUDES = "includes";
    private static final String DECLNAME = "declname";
    private static final String TEMPLATEPARAMLIST = "templateparamlist";
    private static final String CLASS = "class";
    private static final String PUBLIC = "public";
    private static final String LOCATION = "location";
    private static final String SIMPLESECT = "simplesect";
    private static final String PARAMETERLIST = "parameterlist";
    private static final String DETAILEDDESCRIPTION = "detaileddescription";
    private static final String PARA = "para";
    private static final String BRIEFDESCRIPTION = "briefdescription";
    private static final String TYPE2 = "type";
    private static final String PARAM = "param";
    private static final String ARGSSTRING = "argsstring";
    private static final String NAME3 = "name";
    private static final String FUNCTION = "function";
    private static final String MEMBERDEF = "memberdef";
    private static final String FUNC = "func";
    private static final String SECTIONDEF = "sectiondef";
    private static final String COMPOUNDNAME = "compoundname";
    private static final String FILE = "file";
    private static final String COMPOUNDDEF = "compounddef";
    private static final String TYPEDEF = "typedef ";
    private Document document;
    private Map<String, ClassInfo> classesById = new HashMap<String, ClassInfo>();

    public CDoxygenLibhoverGen(Document document) {
        this.document = document;
    }

    private String[] getTypedefTypes(String def) {
        String[] result = null;
        if (def.startsWith(TYPEDEF)) {
            int startIndex = 8;
            int count = 0;
            int i = def.length() - 1;
            while (i >= 0) {
                char ch = def.charAt(i);
                if (ch == '<') {
                    --count;
                } else if (ch == '>') {
                    ++count;
                }
                if (count == 0 && ch == ' ') {
                    startIndex = i + 1;
                    break;
                }
                --i;
            }
            result = new String[2];
            result[1] = def.substring(startIndex);
            int namespace = result[1].indexOf("::");
            result[0] = namespace < 0 ? def.substring(8, startIndex).trim() : result[1].substring(0, namespace) + "::" + def.substring(8, startIndex).trim();
        }
        return result;
    }

    private String getElementText(Node node) {
        StringBuilder d = new StringBuilder();
        NodeList nl = node.getChildNodes();
        int x = 0;
        while (x < nl.getLength()) {
            Node text = nl.item(x);
            if (text.getNodeType() == 3) {
                d.append(text.getNodeValue());
            } else {
                d.append(this.getElementText(text));
            }
            ++x;
        }
        return d.toString();
    }

    private ClassInfo getClassInfo(LibHoverInfo libHoverInfo, String className) {
        int index;
        String typedefName = className.replaceAll("<.*>", "<>");
        TypedefInfo typedef = libHoverInfo.typedefs.get(typedefName);
        if (typedef != null) {
            className = typedef.getTransformedType(className);
        }
        if ((index = className.indexOf(60)) != -1) {
            ClassInfo info = libHoverInfo.classes.get(className.substring(0, index));
            if (info == null) {
                return null;
            }
            ArrayList<ClassInfo> children = info.getChildren();
            if (children != null && children.size() > 0) {
                int x = 0;
                while (x < children.size()) {
                    ClassInfo child = children.get(x);
                    if (className.matches(child.getClassName())) {
                        info = child;
                        break;
                    }
                    ++x;
                }
            }
            return info;
        }
        return libHoverInfo.classes.get(className);
    }

    @Override
    public LibHoverInfo doGenerate() {
        String className;
        Node kind;
        NamedNodeMap attrs;
        Node n;
        LibHoverInfo libHoverInfo = new LibHoverInfo();
        NodeList nl = this.document.getElementsByTagName(COMPOUNDDEF);
        int i = 0;
        while (i < nl.getLength()) {
            block107: {
                Object desc;
                String args;
                Object type;
                String name;
                Node m3Kind;
                NamedNodeMap m3;
                Node n3;
                int pubfuncLength;
                NodeList pubfuncs;
                Node kind2;
                NamedNodeMap m;
                String name2;
                Node n2;
                int j;
                NodeList nl2;
                n = nl.item(i);
                attrs = n.getAttributes();
                kind = attrs.getNamedItem("kind");
                Node id = attrs.getNamedItem("id");
                Node prot = attrs.getNamedItem(PROT3);
                if (id != null && kind != null && FILE.equals(kind.getNodeValue())) {
                    nl2 = n.getChildNodes();
                    FunctionInfo fi = null;
                    String include = null;
                    j = 0;
                    while (j < nl2.getLength()) {
                        n2 = nl2.item(j);
                        name2 = n2.getNodeName();
                        if (COMPOUNDNAME.equals(name2)) {
                            String filename = this.getElementText(n2);
                            if (filename.endsWith(".h")) {
                                include = filename;
                            }
                        } else if (SECTIONDEF.equals(name2) && (m = n2.getAttributes()) != null && (kind2 = m.getNamedItem("kind")) != null && FUNC.equals(kind2.getNodeValue())) {
                            pubfuncs = n2.getChildNodes();
                            pubfuncLength = pubfuncs.getLength();
                            int j1 = 0;
                            while (j1 < pubfuncLength) {
                                n3 = pubfuncs.item(j1);
                                if (MEMBERDEF.equals(n3.getNodeName()) && (m3 = n3.getAttributes()) != null && (m3Kind = m3.getNamedItem("kind")) != null && FUNCTION.equals(m3Kind.getNodeValue())) {
                                    name = null;
                                    type = null;
                                    args = null;
                                    desc = null;
                                    boolean briefDescriptionProcessed = false;
                                    boolean detailedDescriptionProcessed = false;
                                    boolean parameterListProcessed = false;
                                    boolean retValProcessed = false;
                                    boolean locationProcessed = false;
                                    ArrayList<String> parms = new ArrayList<String>();
                                    NodeList nl4 = n3.getChildNodes();
                                    int memberLength = nl4.getLength();
                                    int k = 0;
                                    while (k < memberLength) {
                                        Node n4 = nl4.item(k);
                                        String n4Name = n4.getNodeName();
                                        if (TYPE2.equals(n4Name)) {
                                            nl5 = n4.getChildNodes();
                                            type = "";
                                            x = 0;
                                            while (x < nl5.getLength()) {
                                                n5 = nl5.item(x);
                                                if (n5.getNodeType() == 3) {
                                                    type = (String)type + n5.getNodeValue();
                                                }
                                                ++x;
                                            }
                                        } else if (NAME3.equals(n4Name)) {
                                            name = n4.getTextContent();
                                        } else if (ARGSSTRING.equals(n4Name)) {
                                            args = this.getElementText(n4);
                                        } else if (PARAM.equals(n4Name)) {
                                            nl5 = n4.getChildNodes();
                                            x = 0;
                                            while (x < nl5.getLength()) {
                                                n5 = nl5.item(x);
                                                if (TYPE2.equals(n5.getNodeName())) {
                                                    parms.add(this.getElementText(n5));
                                                }
                                                ++x;
                                            }
                                        } else if (BRIEFDESCRIPTION.equals(n4Name) && !briefDescriptionProcessed) {
                                            nl5 = n4.getChildNodes();
                                            x = 0;
                                            while (x < nl5.getLength()) {
                                                n5 = nl5.item(x);
                                                if (PARA.equals(n5.getNodeName())) {
                                                    if (desc == null) {
                                                        desc = "";
                                                    }
                                                    desc = (String)desc + "<p>" + this.getElementText(n5) + "</p>";
                                                    briefDescriptionProcessed = true;
                                                }
                                                ++x;
                                            }
                                        } else if (DETAILEDDESCRIPTION.equals(n4Name)) {
                                            nl5 = n4.getChildNodes();
                                            x = 0;
                                            while (x < nl5.getLength()) {
                                                n5 = nl5.item(x);
                                                if (n5.getNodeName().equals(PARA)) {
                                                    NodeList nl6;
                                                    Node n6;
                                                    if (desc == null) {
                                                        desc = new String("");
                                                    }
                                                    if ((n6 = (nl6 = n5.getChildNodes()).item(0)).getNodeType() == 3 && !detailedDescriptionProcessed) {
                                                        desc = (String)desc + "<p>" + this.getElementText(n5) + "</p>";
                                                        detailedDescriptionProcessed = true;
                                                    } else {
                                                        int x2 = 0;
                                                        while (x2 < nl6.getLength()) {
                                                            n6 = nl6.item(x2);
                                                            if (PARAMETERLIST.equals(n6.getNodeName()) && !parameterListProcessed) {
                                                                desc = (String)desc + this.getParameters(n6, false);
                                                                parameterListProcessed = true;
                                                            } else if (SIMPLESECT.equals(n6.getNodeName()) & !retValProcessed) {
                                                                desc = (String)desc + this.getReturn(n6);
                                                                retValProcessed = true;
                                                            }
                                                            ++x2;
                                                        }
                                                    }
                                                }
                                                ++x;
                                            }
                                        } else if (LOCATION.equals(n4Name) && !locationProcessed) {
                                            if (name == null) break;
                                            fi = libHoverInfo.functions.get(name);
                                            if (fi == null) {
                                                fi = new FunctionInfo(name);
                                            }
                                            if (type != null) {
                                                fi.setReturnType((String)type);
                                            }
                                            if (args != null) {
                                                if (args.charAt(0) == '(' && args.charAt(args.length() - 1) == ')') {
                                                    fi.setPrototype(args.substring(1, args.length() - 1));
                                                } else {
                                                    fi.setPrototype(args);
                                                }
                                            }
                                            if (desc != null) {
                                                fi.setDescription((String)desc);
                                            }
                                            if (include != null) {
                                                fi.addHeader(include);
                                            }
                                            libHoverInfo.functions.put(name, fi);
                                            locationProcessed = true;
                                            break;
                                        }
                                        ++k;
                                    }
                                }
                                ++j1;
                            }
                        }
                        ++j;
                    }
                }
                if (id == null || prot == null || !PUBLIC.equals(prot.getNodeValue()) || kind == null || !CLASS.equals(kind.getNodeValue())) break block107;
                nl2 = n.getChildNodes();
                ClassInfo d = null;
                String hashName = null;
                j = 0;
                while (j < nl2.getLength()) {
                    block109: {
                        block112: {
                            block111: {
                                block110: {
                                    block108: {
                                        n2 = nl2.item(j);
                                        name2 = n2.getNodeName();
                                        if (!name2.equals(COMPOUNDNAME)) break block108;
                                        String text = n2.getTextContent();
                                        if (text != null && !text.equals("")) {
                                            className = text;
                                            text = text.replaceAll("<\\s*", "<");
                                            text = text.replaceAll("\\s*>", ">");
                                            int index = text.indexOf(60);
                                            hashName = text;
                                            if (index > 0) {
                                                hashName = text.substring(0, index);
                                            }
                                            d = new ClassInfo(className, n);
                                            this.classesById.put(id.getNodeValue(), d);
                                            ClassInfo e = libHoverInfo.classes.get(hashName);
                                            if (e != null) {
                                                if (!d.areTemplateParmsFilled()) {
                                                    d.setTemplateParms(this.getTemplateParms(n));
                                                }
                                                String[] templateParms = d.getTemplateParms();
                                                int k = 0;
                                                while (k < templateParms.length) {
                                                    text = text.replaceAll(templateParms[k], "[a-zA-Z0-9_: *]+");
                                                    ++k;
                                                }
                                                d.setClassName(text);
                                                e.addTemplate(d);
                                            } else {
                                                libHoverInfo.classes.put(hashName, d);
                                            }
                                        }
                                        break block109;
                                    }
                                    if (!TEMPLATEPARAMLIST.equals(name2)) break block110;
                                    ArrayList<String> templates = new ArrayList<String>();
                                    NodeList params = n2.getChildNodes();
                                    int paramsLength = params.getLength();
                                    int j2 = 0;
                                    while (j2 < paramsLength) {
                                        Node n32 = params.item(j2);
                                        if (n32.getNodeName().equals(PARAM)) {
                                            NodeList types = n32.getChildNodes();
                                            int typesLength = types.getLength();
                                            int j3 = 0;
                                            while (j3 < typesLength) {
                                                Node n4 = types.item(j3);
                                                if (DECLNAME.equals(n4.getNodeName())) {
                                                    templates.add(this.getElementText(n4));
                                                }
                                                ++j3;
                                            }
                                        }
                                        ++j2;
                                    }
                                    String[] templateNames = new String[templates.size()];
                                    d.setTemplateParms(templates.toArray(templateNames));
                                    break block109;
                                }
                                if (!INCLUDES.equals(name2)) break block111;
                                String include = this.getElementText(n2);
                                if (d != null) {
                                    d.setInclude(include);
                                }
                                break block109;
                            }
                            if (!BASECOMPOUNDREF.equals(name2)) break block112;
                            m = n2.getAttributes();
                            if (m == null) break block109;
                            Node refid = m.getNamedItem(REFID2);
                            Node prot2 = m.getNamedItem(PROT3);
                            if (prot2 == null || !PUBLIC.equals(prot2.getNodeValue())) break block109;
                            ClassInfo baseClass = null;
                            if (refid != null) {
                                baseClass = this.classesById.get(refid.getNodeValue());
                            } else {
                                String baseClassName = n2.getTextContent();
                                baseClass = this.getClassInfo(libHoverInfo, baseClassName);
                            }
                            if (d == null || baseClass == null) break block109;
                            d.addBaseClass(baseClass);
                            break block109;
                        }
                        if (SECTIONDEF.equals(name2) && (m = n2.getAttributes()) != null && (kind2 = m.getNamedItem("kind")) != null && PUBLIC_FUNC.equals(kind2.getNodeValue())) {
                            pubfuncs = n2.getChildNodes();
                            pubfuncLength = pubfuncs.getLength();
                            int j1 = 0;
                            while (j1 < pubfuncLength) {
                                n3 = pubfuncs.item(j1);
                                if (MEMBERDEF.equals(n3.getNodeName()) && (m3 = n3.getAttributes()) != null && (m3Kind = m3.getNamedItem("kind")) != null && FUNCTION.equals(m3Kind.getNodeValue())) {
                                    name = null;
                                    type = null;
                                    args = null;
                                    desc = null;
                                    ArrayList<String> parms = new ArrayList<String>();
                                    NodeList nl4 = n3.getChildNodes();
                                    int memberLength = nl4.getLength();
                                    int k = 0;
                                    while (k < memberLength) {
                                        Node n4 = nl4.item(k);
                                        String n4Name = n4.getNodeName();
                                        if (TYPE2.equals(n4Name)) {
                                            nl5 = n4.getChildNodes();
                                            type = "";
                                            x = 0;
                                            while (x < nl5.getLength()) {
                                                String refid;
                                                ClassInfo refClass;
                                                NamedNodeMap n5m;
                                                Node n5id;
                                                n5 = nl5.item(x);
                                                if (n5.getNodeType() == 3) {
                                                    type = (String)type + n5.getNodeValue();
                                                } else if (REF.equals(n5.getNodeName()) && (n5id = (n5m = n5.getAttributes()).getNamedItem(REFID2)) != null && (refClass = this.classesById.get(refid = n5id.getNodeValue())) != null) {
                                                    type = (String)type + refClass.getClassName();
                                                }
                                                ++x;
                                            }
                                        } else if (NAME3.equals(n4Name)) {
                                            name = n4.getTextContent();
                                        } else if (ARGSSTRING.equals(n4Name)) {
                                            args = this.getElementText(n4);
                                        } else if (PARAM.equals(n4Name)) {
                                            nl5 = n4.getChildNodes();
                                            x = 0;
                                            while (x < nl5.getLength()) {
                                                n5 = nl5.item(x);
                                                if (TYPE2.equals(n5.getNodeName())) {
                                                    parms.add(this.getElementText(n5));
                                                }
                                                ++x;
                                            }
                                        } else if (BRIEFDESCRIPTION.equals(n4Name)) {
                                            nl5 = n4.getChildNodes();
                                            x = 0;
                                            while (x < nl5.getLength()) {
                                                n5 = nl5.item(x);
                                                if (PARA.equals(n5.getNodeName())) {
                                                    if (desc == null) {
                                                        desc = "";
                                                    }
                                                    desc = (String)desc + "<p>" + this.getElementText(n5) + "</p>";
                                                }
                                                ++x;
                                            }
                                        } else if (DETAILEDDESCRIPTION.equals(n4Name)) {
                                            nl5 = n4.getChildNodes();
                                            x = 0;
                                            while (x < nl5.getLength()) {
                                                n5 = nl5.item(x);
                                                if (PARA.equals(n5.getNodeName())) {
                                                    NodeList nl6;
                                                    Node n6;
                                                    if (desc == null) {
                                                        desc = new String("");
                                                    }
                                                    if ((n6 = (nl6 = n5.getChildNodes()).item(0)).getNodeType() == 3) {
                                                        desc = (String)desc + "<p>" + this.getElementText(n5) + "</p>";
                                                    } else {
                                                        int x2 = 0;
                                                        while (x2 < nl6.getLength()) {
                                                            n6 = nl6.item(x2);
                                                            if (PARAMETERLIST.equals(n6.getNodeName())) {
                                                                desc = (String)desc + this.getParameters(n6, true);
                                                            } else if (SIMPLESECT.equals(n6.getNodeName())) {
                                                                desc = (String)desc + this.getReturn(n6);
                                                            }
                                                            ++x2;
                                                        }
                                                    }
                                                }
                                                ++x;
                                            }
                                        } else if (LOCATION.equals(n4Name)) {
                                            if (name == null) break;
                                            MemberInfo member = new MemberInfo(name);
                                            member.setReturnType((String)type);
                                            member.setPrototype(args);
                                            member.setDescription((String)desc);
                                            String[] argNames = new String[parms.size()];
                                            member.setParamTypes(parms.toArray(argNames));
                                            d.addMember(member);
                                            break;
                                        }
                                        ++k;
                                    }
                                }
                                ++j1;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        nl = this.document.getElementsByTagName(MEMBERDEF);
        i = 0;
        while (i < nl.getLength()) {
            n = nl.item(i);
            attrs = n.getAttributes();
            if (attrs != null) {
                kind = attrs.getNamedItem("kind");
                Node prot = attrs.getNamedItem(PROT3);
                if (kind != null && TYPEDEF2.equals(kind.getNodeValue()) && prot != null && PUBLIC.equals(prot.getNodeValue())) {
                    NodeList list = n.getChildNodes();
                    int x = 0;
                    while (x < list.getLength()) {
                        String def;
                        Node n2 = list.item(x);
                        if (DEFINITION.equals(n2.getNodeName()) && (def = n2.getTextContent()) != null && !def.equals("")) {
                            def = def.replaceAll("<\\s*", "<");
                            String[] types = this.getTypedefTypes(def = def.replaceAll("\\s*>", ">"));
                            if (types != null) {
                                TypedefInfo d = new TypedefInfo(types[1], types[0]);
                                String hashName = d.getTypedefName();
                                int index = hashName.indexOf(60);
                                if (index > 0) {
                                    className = hashName.substring(0, index);
                                    hashName = hashName.replaceAll("<.*>", "<>");
                                    ClassInfo e = libHoverInfo.classes.get(className);
                                    if (e == null) break;
                                    ArrayList<ClassInfo> children = e.getChildren();
                                    if (children != null && children.size() > 0) {
                                        int y = 0;
                                        while (y < children.size()) {
                                            ClassInfo child = children.get(y);
                                            String childName = child.getClassName().replaceAll("\\*", "\\\\*");
                                            if (types[1].matches((childName = childName.replace("[]", "\\[\\]")).concat("::.*"))) {
                                                e = child;
                                                break;
                                            }
                                            ++y;
                                        }
                                    }
                                    String[] templates = e.getTemplateParms();
                                    d.copyTemplates(templates);
                                    TypedefInfo f = libHoverInfo.typedefs.get(hashName);
                                    if (f != null) {
                                        String typedefName = d.getTypedefName();
                                        int z = 0;
                                        while (z < templates.length) {
                                            typedefName = typedefName.replaceAll(templates[z], "[a-zA-Z0-9_: ]+");
                                            ++z;
                                        }
                                        d.setTypedefName(typedefName);
                                        f.addTypedef(d);
                                        break;
                                    }
                                    libHoverInfo.typedefs.put(hashName, d);
                                    break;
                                }
                                libHoverInfo.typedefs.put(hashName, d);
                                break;
                            }
                        }
                        ++x;
                    }
                }
            }
            ++i;
        }
        return libHoverInfo;
    }

    private String getParameters(Node n6, boolean addHyphen) {
        Object desc = "<br><br><h3>Parameters:</h3>";
        NamedNodeMap m = n6.getAttributes();
        Node kind = m.getNamedItem("kind");
        if (kind != null && EXCEPTION.equals(kind.getNodeValue())) {
            desc = "<br><br><h3>Exceptions:</h3>";
        }
        NodeList nl = n6.getChildNodes();
        int x = 0;
        while (x < nl.getLength()) {
            Node n = nl.item(x);
            if (PARAMETERITEM.equals(n.getNodeName())) {
                NodeList nl2 = n.getChildNodes();
                int y = 0;
                while (y < nl2.getLength()) {
                    Node n2 = nl2.item(y);
                    if (PARAMETERNAMELIST.equals(n2.getNodeName())) {
                        NodeList nl3 = n2.getChildNodes();
                        int z = 0;
                        while (z < nl3.getLength()) {
                            Node n3 = nl3.item(z);
                            if (PARAMETERNAME.equals(n3.getNodeName())) {
                                desc = (String)desc + this.getElementText(n3);
                                if (addHyphen) {
                                    desc = (String)desc + " - ";
                                }
                            }
                            ++z;
                        }
                    } else if (PARAMETERDESCRIPTION.equals(n2.getNodeName())) {
                        desc = (String)desc + this.getElementText(n2) + "<br>";
                    }
                    ++y;
                }
            }
            ++x;
        }
        return desc;
    }

    private String getReturn(Node n6) {
        Object desc = "";
        NamedNodeMap m = n6.getAttributes();
        Node kind = m.getNamedItem("kind");
        if (kind != null && RETURN.equals(kind.getNodeValue())) {
            desc = (String)desc + "<br><h3>Returns:</h3>" + this.getElementText(n6) + "<br>";
        }
        return desc;
    }

    private String[] getTemplateParms(Node classNode) {
        Node n = null;
        ArrayList<String> templateArray = new ArrayList<String>();
        NodeList list = classNode.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            n = list.item(i);
            if (TEMPLATEPARAMLIST.equals(n.getNodeName())) break;
            ++i;
        }
        if (n != null) {
            NodeList templateList = n.getChildNodes();
            int j = 0;
            while (j < templateList.getLength()) {
                Node p = templateList.item(j);
                if (PARAM.equals(p.getNodeName())) {
                    NodeList paramList = p.getChildNodes();
                    int k = 0;
                    while (k < paramList.getLength()) {
                        Node q = paramList.item(k);
                        if (DECLNAME.equals(q.getNodeName())) {
                            String templateName = q.getTextContent();
                            templateArray.add(templateName);
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
        String[] templates = new String[templateArray.size()];
        return templateArray.toArray(templates);
    }
}

