/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.binutils.link2source;

import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.binutils.link2source.STCSourceNotFoundEditorInput;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.internal.Activator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public final class STLink2SourceSupport {
    private STLink2SourceSupport() {
    }

    private static boolean openSourceFileAtLocation(IPath binaryLoc, IPath sourceLoc, int lineNumber) {
        IFile binary = STSymbolManager.sharedInstance.findFileFromPath(binaryLoc);
        IProject project = null;
        if (binary != null) {
            project = binary.getProject();
        }
        return STLink2SourceSupport.openFileImpl(project, sourceLoc, lineNumber);
    }

    public static boolean openSourceFileAtLocation(IProject project, IPath sourceLoc, int lineNumber) {
        return STLink2SourceSupport.openFileImpl(project, sourceLoc, lineNumber);
    }

    public static boolean openSourceFileAtLocation(IBinaryParser.IBinaryObject binary, String sourceLoc, int lineNumber) {
        if (sourceLoc == null) {
            return false;
        }
        Path p = new Path(sourceLoc);
        return STLink2SourceSupport.openSourceFileAtLocation(binary.getPath(), (IPath)p, lineNumber);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean openFileImpl(IProject project, IPath sourceLoc, int lineNumber) {
        if (sourceLoc == null) return false;
        if ("??".equals(sourceLoc.toString())) {
            return false;
        }
        try {
            void textEditor;
            IEditorInput editorInput = STLink2SourceSupport.getEditorInput(sourceLoc, project);
            IWorkbenchPage p = CUIPlugin.getActivePage();
            if (p == null) return false;
            if (editorInput == null) {
                p.openEditor((IEditorInput)new STCSourceNotFoundEditorInput(project, sourceLoc, lineNumber), "org.eclipse.linuxtools.binutils.link2source.STCSourceNotFoundEditor", true);
                return false;
            }
            IEditorPart editor = p.openEditor(editorInput, "org.eclipse.cdt.ui.editor.CEditor", true);
            if (lineNumber <= 0) return false;
            IEditorPart iEditorPart = editor;
            if (!(iEditorPart instanceof ITextEditor)) return false;
            ITextEditor iTextEditor = (ITextEditor)iEditorPart;
            ITextEditor cfr_ignored_0 = (ITextEditor)iEditorPart;
            IDocumentProvider provider = textEditor.getDocumentProvider();
            IDocument document = provider.getDocument((Object)editor.getEditorInput());
            try {
                int start = document.getLineOffset(lineNumber - 1);
                textEditor.selectAndReveal(start, 0);
                IWorkbenchPage page = editor.getSite().getPage();
                page.activate((IWorkbenchPart)editor);
                return true;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        return false;
    }

    public static IEditorInput getEditorInput(IPath p, IProject project) {
        File file;
        IFile f = STLink2SourceSupport.getFileForPath(p, project);
        if (f != null && f.exists()) {
            return new FileEditorInput(f);
        }
        if (p.isAbsolute() && (file = p.toFile()).exists()) {
            try {
                IFileStore ifs = EFS.getStore((URI)file.toURI());
                return new FileStoreEditorInput(ifs);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
        }
        return STLink2SourceSupport.findFileInCommonSourceLookup(p);
    }

    /*
     * WARNING - void declaration
     */
    private static IEditorInput findFileInCommonSourceLookup(IPath path) {
        try {
            ISourceContainer[] c;
            CSourceLookupDirector director = CDebugCorePlugin.getDefault().getCommonSourceLookupDirector();
            ISourceContainer[] iSourceContainerArray = c = director.getSourceContainers();
            int n = c.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] o;
                ISourceContainer sourceContainer = iSourceContainerArray[n2];
                Object[] objectArray = o = sourceContainer.findSourceElements(path.toOSString());
                int n3 = o.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object object = objectArray[n4];
                    Object object2 = object;
                    if (object2 instanceof IFile) {
                        void file;
                        IFile iFile = (IFile)object2;
                        IFile cfr_ignored_0 = (IFile)object2;
                        return new FileEditorInput((IFile)file);
                    }
                    Object object3 = object;
                    if (object3 instanceof LocalFileStorage) {
                        void storage;
                        LocalFileStorage localFileStorage = (LocalFileStorage)object3;
                        LocalFileStorage cfr_ignored_1 = (LocalFileStorage)object3;
                        IFileStore ifs = EFS.getStore((URI)storage.getFile().toURI());
                        return new FileStoreEditorInput(ifs);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static IFile getFileForPath(IPath path, IProject project) {
        IFile f = STLink2SourceSupport.getFileForPathImpl(path, project);
        if (f == null) {
            HashSet<IProject> allProjects = new HashSet<IProject>();
            try {
                STLink2SourceSupport.getAllReferencedProjects(allProjects, project);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            if (allProjects != null) {
                for (IProject project2 : allProjects) {
                    f = STLink2SourceSupport.getFileForPathImpl(path, project2);
                    if (f != null) break;
                }
            }
        }
        return f;
    }

    /*
     * WARNING - void declaration
     */
    private static IFile getFileForPathImpl(IPath path, IProject project) {
        ICProject cproject;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (path.isAbsolute()) {
            return STSymbolManager.sharedInstance.findFileFromPath(path);
        }
        if (project != null && project.exists() && (cproject = CoreModel.getDefault().create(project)) != null) {
            try {
                IOutputEntry[] entries;
                ISourceRoot[] roots;
                ISourceRoot[] iSourceRootArray = roots = cproject.getAllSourceRoots();
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource iResource;
                    ISourceRoot sourceRoot = iSourceRootArray[n2];
                    IContainer r = sourceRoot.getResource();
                    IResource res = r.findMember(path);
                    if (res != null && res.exists() && (iResource = res) instanceof IFile) {
                        void file;
                        IFile iFile = (IFile)iResource;
                        IFile cfr_ignored_0 = (IFile)iResource;
                        return file;
                    }
                    ++n2;
                }
                IOutputEntry[] iOutputEntryArray = entries = cproject.getOutputEntries();
                int n3 = entries.length;
                n = 0;
                while (n < n3) {
                    IOutputEntry pathEntry = iOutputEntryArray[n];
                    IPath p = pathEntry.getPath();
                    IResource r = root.findMember(p);
                    IResource iResource = r;
                    if (iResource instanceof IContainer) {
                        IResource iResource2;
                        void parent;
                        IContainer cfr_ignored_1 = (IContainer)iResource;
                        IContainer cfr_ignored_2 = (IContainer)iResource;
                        IResource res = parent.findMember(path);
                        if (res != null && res.exists() && (iResource2 = res) instanceof IFile) {
                            void file;
                            IFile iFile = (IFile)iResource2;
                            IFile cfr_ignored_3 = (IFile)iResource2;
                            return file;
                        }
                    }
                    ++n;
                }
            }
            catch (CModelException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
        }
        IPath realPath = project.getLocation().append(path).makeAbsolute();
        URI realURI = URIUtil.toURI((String)realPath.toString());
        try {
            FindLinkedResourceVisitor visitor = new FindLinkedResourceVisitor(realURI);
            project.accept((IResourceProxyVisitor)visitor, 2);
            if (visitor.foundElement()) {
                return (IFile)visitor.getResource();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    private static void getAllReferencedProjects(Set<IProject> all, IProject project) throws CoreException {
        if (project != null) {
            IProject[] refs;
            IProject[] iProjectArray = refs = project.getReferencedProjects();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IProject ref = iProjectArray[n2];
                if (!all.contains(ref) && ref.exists() && ref.isOpen()) {
                    all.add(ref);
                    STLink2SourceSupport.getAllReferencedProjects(all, ref);
                }
                ++n2;
            }
        }
    }

    private static class FindLinkedResourceVisitor
    implements IResourceProxyVisitor {
        private final URI element;
        private boolean keepSearching = true;
        private boolean found;
        private IResource resource;
        private String lastLinkPath;

        public FindLinkedResourceVisitor(URI element) {
            this.element = element;
        }

        public boolean foundElement() {
            return this.found;
        }

        public IResource getResource() {
            return this.resource;
        }

        public boolean visit(IResourceProxy proxy) {
            if (proxy.isLinked()) {
                this.lastLinkPath = proxy.requestFullPath().toString();
            }
            if (this.lastLinkPath != null && proxy.requestFullPath().toString().startsWith(this.lastLinkPath) && proxy.requestResource().getLocationURI().equals(this.element)) {
                this.found = true;
                this.resource = proxy.requestResource();
                this.keepSearching = false;
            }
            return this.keepSearching;
        }
    }
}

