/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.closure;

import org.eclipse.jpt.common.utility.closure.InterruptibleClosure;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;

public class ConditionalInterruptibleClosure<A>
implements InterruptibleClosure<A> {
    private final Predicate<? super A> predicate;
    private final InterruptibleClosure<? super A> trueClosure;
    private final InterruptibleClosure<? super A> falseClosure;

    public ConditionalInterruptibleClosure(Predicate<? super A> predicate, InterruptibleClosure<? super A> trueClosure, InterruptibleClosure<? super A> falseClosure) {
        if (predicate == null || trueClosure == null || falseClosure == null) {
            throw new NullPointerException();
        }
        this.predicate = predicate;
        this.trueClosure = trueClosure;
        this.falseClosure = falseClosure;
    }

    @Override
    public void execute(A argument) throws InterruptedException {
        if (this.predicate.evaluate(argument)) {
            this.trueClosure.execute(argument);
        } else {
            this.falseClosure.execute(argument);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.predicate);
    }
}

