/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.ssl.X509;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureRequestCustomizer
implements HttpConfiguration.Customizer {
    public static final String CIPHER_SUITE_ATTRIBUTE = "org.eclipse.jetty.server.cipher";
    public static final String KEY_SIZE_ATTRIBUTE = "org.eclipse.jetty.server.keySize";
    public static final String SSL_SESSION_ID_ATTRIBUTE = "org.eclipse.jetty.server.sslSessionId";
    public static final String PEER_CERTIFICATES_ATTRIBUTE = "org.eclipse.jetty.server.peerCertificates";
    public static final String X509_ATTRIBUTE = "org.eclipse.jetty.server.x509";
    public static final String DEFAULT_SSL_SESSION_ATTRIBUTE = "org.eclipse.jetty.server.sslSession";
    public static final String DEFAULT_SSL_SESSION_DATA_ATTRIBUTE = SecureRequestCustomizer.newSslSessionDataAttribute("org.eclipse.jetty.server.sslSession");
    private static final Logger LOG = LoggerFactory.getLogger(SecureRequestCustomizer.class);
    private String _sslSessionAttribute = "org.eclipse.jetty.server.sslSession";
    private String _sslSessionDataAttribute = DEFAULT_SSL_SESSION_DATA_ATTRIBUTE;
    private boolean _sniRequired;
    private boolean _sniHostCheck;
    private long _stsMaxAge;
    private boolean _stsIncludeSubDomains;
    private HttpField _stsField;

    public SecureRequestCustomizer() {
        this(true);
    }

    public SecureRequestCustomizer(@Name(value="sniHostCheck") boolean sniHostCheck) {
        this(sniHostCheck, -1L, false);
    }

    public SecureRequestCustomizer(@Name(value="sniHostCheck") boolean sniHostCheck, @Name(value="stsMaxAgeSeconds") long stsMaxAgeSeconds, @Name(value="stsIncludeSubdomains") boolean stsIncludeSubdomains) {
        this(false, sniHostCheck, stsMaxAgeSeconds, stsIncludeSubdomains);
    }

    public SecureRequestCustomizer(@Name(value="sniRequired") boolean sniRequired, @Name(value="sniHostCheck") boolean sniHostCheck, @Name(value="stsMaxAgeSeconds") long stsMaxAgeSeconds, @Name(value="stsIncludeSubdomains") boolean stsIncludeSubdomains) {
        this._sniRequired = sniRequired;
        this._sniHostCheck = sniHostCheck;
        this._stsMaxAge = stsMaxAgeSeconds;
        this._stsIncludeSubDomains = stsIncludeSubdomains;
        this.formatSTS();
    }

    public boolean isSniHostCheck() {
        return this._sniHostCheck;
    }

    public void setSniHostCheck(boolean sniHostCheck) {
        this._sniHostCheck = sniHostCheck;
    }

    public boolean isSniRequired() {
        return this._sniRequired;
    }

    public void setSniRequired(boolean sniRequired) {
        this._sniRequired = sniRequired;
    }

    public long getStsMaxAge() {
        return this._stsMaxAge;
    }

    public void setStsMaxAge(long stsMaxAgeSeconds) {
        this.setStsMaxAge(stsMaxAgeSeconds, TimeUnit.SECONDS);
    }

    public void setStsMaxAge(long period, TimeUnit units) {
        this._stsMaxAge = units.toSeconds(period);
        this.formatSTS();
    }

    public boolean isStsIncludeSubDomains() {
        return this._stsIncludeSubDomains;
    }

    public void setStsIncludeSubDomains(boolean stsIncludeSubDomains) {
        this._stsIncludeSubDomains = stsIncludeSubDomains;
        this.formatSTS();
    }

    private void formatSTS() {
        long stsMaxAge = this.getStsMaxAge();
        this._stsField = stsMaxAge < 0L ? null : new PreEncodedHttpField(HttpHeader.STRICT_TRANSPORT_SECURITY, String.format("max-age=%d%s", stsMaxAge, this.isStsIncludeSubDomains() ? "; includeSubDomains" : ""));
    }

    @Override
    public Request customize(Request request, HttpFields.Mutable responseHeaders) {
        ProxyConnectionFactory.ProxyEndPoint proxyEndPoint;
        EndPoint endPoint = request.getConnectionMetaData().getConnection().getEndPoint();
        if (endPoint instanceof SslConnection.SslEndPoint) {
            SslConnection.SslEndPoint sslEndPoint = (SslConnection.SslEndPoint)endPoint;
            SslConnection sslConnection = sslEndPoint.getSslConnection();
            SSLEngine sslEngine = sslConnection.getSSLEngine();
            request = this.newSecureRequest(request, sslEngine);
        } else if (endPoint instanceof ProxyConnectionFactory.ProxyEndPoint && (proxyEndPoint = (ProxyConnectionFactory.ProxyEndPoint)endPoint).getAttribute("TLS_VERSION") != null) {
            request = this.newSecureRequest(request, null);
        }
        if (this._stsField != null) {
            responseHeaders.add(this._stsField);
        }
        return request;
    }

    protected Request newSecureRequest(Request request, SSLEngine sslEngine) {
        if (sslEngine != null) {
            return new SecureRequestWithTLSData(request, sslEngine);
        }
        return new SecureRequest(request);
    }

    private X509Certificate[] getCertChain(Connector connector, SSLSession sslSession) {
        SslContextFactory.Server sslContextFactory;
        SslConnectionFactory sslConnectionFactory = connector.getConnectionFactory(SslConnectionFactory.class);
        if (sslConnectionFactory != null && (sslContextFactory = sslConnectionFactory.getSslContextFactory()) != null) {
            return sslContextFactory.getX509CertChain(sslSession);
        }
        return SslContextFactory.getCertChain((SSLSession)sslSession);
    }

    public void setSslSessionAttribute(String attribute) {
        Objects.requireNonNull(attribute);
        this._sslSessionAttribute = attribute;
        this._sslSessionDataAttribute = SecureRequestCustomizer.newSslSessionDataAttribute(attribute);
    }

    public String getSslSessionAttribute() {
        return this._sslSessionAttribute;
    }

    public String getSslSessionDataAttribute() {
        return this._sslSessionDataAttribute;
    }

    private static String newSslSessionDataAttribute(String sslSessionAttribute) {
        return sslSessionAttribute + "Data";
    }

    protected void checkSni(Request request, SSLSession session) {
        if (this.isSniRequired() || this.isSniHostCheck()) {
            String sniHost = (String)session.getValue("org.eclipse.jetty.util.ssl.sniHost");
            X509 x509 = this.getX509(session);
            if (x509 == null) {
                throw new BadMessageException(400, "Invalid SNI");
            }
            String serverName = Request.getServerName(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Host={}, SNI={}, SNI Certificate={}", new Object[]{serverName, sniHost, x509});
            }
            if (this.isSniRequired() && (sniHost == null || !x509.matches(sniHost))) {
                throw new BadMessageException(400, "Invalid SNI");
            }
            if (this.isSniHostCheck() && !x509.matches(serverName)) {
                throw new BadMessageException(400, "Invalid SNI");
            }
        }
    }

    private X509 getX509(SSLSession session) {
        X509 x509 = (X509)session.getValue(X509_ATTRIBUTE);
        if (x509 == null) {
            Certificate[] certificates = session.getLocalCertificates();
            if (certificates == null || certificates.length == 0 || !(certificates[0] instanceof X509Certificate)) {
                return null;
            }
            x509 = new X509(null, (X509Certificate)certificates[0]);
            session.putValue(X509_ATTRIBUTE, x509);
        }
        return x509;
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    protected class SecureRequestWithTLSData
    extends SecureRequest {
        private final SSLSession _sslSession;
        private final SslSessionData _sslSessionData;

        public SecureRequestWithTLSData(Request request, SSLEngine sslEngine) {
            super(request);
            this._sslSession = sslEngine.getSession();
            SecureRequestCustomizer.this.checkSni(request, this._sslSession);
            String key = SslSessionData.class.getName();
            SslSessionData sslSessionData = (SslSessionData)this._sslSession.getValue(key);
            if (sslSessionData == null) {
                try {
                    String cipherSuite = this._sslSession.getCipherSuite();
                    int keySize = SslContextFactory.deduceKeyLength((String)cipherSuite);
                    X509Certificate[] peerCertificates = SecureRequestCustomizer.this.getCertChain(this.getConnectionMetaData().getConnector(), this._sslSession);
                    byte[] bytes = this._sslSession.getId();
                    String idStr = StringUtil.toHexString((byte[])bytes);
                    sslSessionData = new SslSessionData(idStr, cipherSuite, keySize, peerCertificates);
                    this._sslSession.putValue(key, sslSessionData);
                }
                catch (Exception e) {
                    LOG.warn("Unable to get secure details ", (Throwable)e);
                }
            }
            this._sslSessionData = sslSessionData;
        }

        public Object getAttribute(String name) {
            String sessionAttribute = SecureRequestCustomizer.this.getSslSessionAttribute();
            if (StringUtil.isNotBlank((String)sessionAttribute) && name.startsWith(sessionAttribute)) {
                if (name.equals(sessionAttribute)) {
                    return this._sslSession;
                }
                if (name.equals(SecureRequestCustomizer.this.getSslSessionDataAttribute())) {
                    return this._sslSessionData;
                }
            }
            return switch (name) {
                case SecureRequestCustomizer.CIPHER_SUITE_ATTRIBUTE -> {
                    if (this._sslSessionData != null) {
                        yield this._sslSessionData.cipherSuite();
                    }
                    yield null;
                }
                case SecureRequestCustomizer.KEY_SIZE_ATTRIBUTE -> {
                    if (this._sslSessionData != null) {
                        yield this._sslSessionData.keySize();
                    }
                    yield null;
                }
                case SecureRequestCustomizer.SSL_SESSION_ID_ATTRIBUTE -> {
                    if (this._sslSessionData != null) {
                        yield this._sslSessionData.sessionId();
                    }
                    yield null;
                }
                case SecureRequestCustomizer.PEER_CERTIFICATES_ATTRIBUTE -> {
                    if (this._sslSessionData != null) {
                        yield this._sslSessionData.peerCertificates();
                    }
                    yield null;
                }
                case SecureRequestCustomizer.X509_ATTRIBUTE -> SecureRequestCustomizer.this.getX509(this._sslSession);
                default -> super.getAttribute(name);
            };
        }

        public Set<String> getAttributeNameSet() {
            String sessionAttribute;
            HashSet<String> names = new HashSet<String>(super.getAttributeNameSet());
            if (SecureRequestCustomizer.this.getX509(this._sslSession) != null) {
                names.add(SecureRequestCustomizer.X509_ATTRIBUTE);
            }
            if (!StringUtil.isNotBlank((String)(sessionAttribute = SecureRequestCustomizer.this.getSslSessionAttribute()))) {
                names.add(sessionAttribute);
                if (this._sslSessionData != null) {
                    names.add(SecureRequestCustomizer.this.getSslSessionDataAttribute());
                    names.add(SecureRequestCustomizer.CIPHER_SUITE_ATTRIBUTE);
                    names.add(SecureRequestCustomizer.KEY_SIZE_ATTRIBUTE);
                    names.add(SecureRequestCustomizer.SSL_SESSION_ID_ATTRIBUTE);
                    names.add(SecureRequestCustomizer.PEER_CERTIFICATES_ATTRIBUTE);
                }
            }
            return names;
        }
    }

    protected static class SecureRequest
    extends Request.Wrapper {
        public SecureRequest(Request wrapped) {
            super(wrapped);
        }

        @Override
        public boolean isSecure() {
            return true;
        }
    }

    public record SslSessionData(String sessionId, String cipherSuite, int keySize, X509Certificate[] peerCertificates) {
    }
}

