/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.JUnitCorePlugin;
import org.eclipse.jdt.internal.junit.JUnitMessages;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.jdt.internal.junit.model.ITestRunListener2;
import org.eclipse.jdt.internal.junit.model.ITestSessionListener;
import org.eclipse.jdt.internal.junit.model.JUnitModel;
import org.eclipse.jdt.internal.junit.model.RemoteTestRunnerClient;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRoot;
import org.eclipse.jdt.internal.junit.model.TestRunListenerAdapter;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.junit.model.ITestElement;
import org.eclipse.jdt.junit.model.ITestElementContainer;
import org.eclipse.jdt.junit.model.ITestRunSession;

public class TestRunSession
implements ITestRunSession {
    private final ILaunch fLaunch;
    private final String fTestRunName;
    private final IJavaProject fProject;
    private final ITestKind fTestRunnerKind;
    private RemoteTestRunnerClient fTestRunnerClient;
    private final ListenerList<ITestSessionListener> fSessionListeners;
    private TestRoot fTestRoot;
    private ITestElement.Result fTestResult;
    private HashMap<String, TestElement> fIdToTest;
    private List<IncompleteTestSuite> fIncompleteTestSuites;
    private List<IncompleteTestSuite> fFactoryTestSuites;
    private TestSuiteElement fUnrootedSuite;
    private static final String EMPTY_STRING = "";
    private String fIncludeTags;
    private String fExcludeTags;
    volatile int fStartedCount;
    volatile int fIgnoredCount;
    volatile int fAssumptionFailureCount;
    volatile int fErrorCount;
    volatile int fFailureCount;
    volatile int fTotalCount;
    volatile long fStartTime;
    volatile boolean fIsRunning;
    volatile boolean fIsStopped;

    public TestRunSession(String testRunName, IJavaProject project) {
        this.fLaunch = null;
        this.fProject = project;
        this.fStartTime = -System.currentTimeMillis();
        Assert.isNotNull((Object)testRunName);
        this.fTestRunName = testRunName;
        this.fTestRunnerKind = ITestKind.NULL;
        this.fTestRoot = new TestRoot(this);
        this.fIdToTest = new HashMap();
        this.fTestRunnerClient = null;
        this.fSessionListeners = new ListenerList();
    }

    public TestRunSession(ILaunch launch, IJavaProject project, int port) {
        Assert.isNotNull((Object)launch);
        this.fLaunch = launch;
        this.fProject = project;
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        if (launchConfiguration != null) {
            this.fTestRunName = launchConfiguration.getName();
            this.fTestRunnerKind = JUnitLaunchConfigurationConstants.getTestRunnerKind(launchConfiguration);
        } else {
            this.fTestRunName = project.getElementName();
            this.fTestRunnerKind = ITestKind.NULL;
        }
        this.fTestRoot = new TestRoot(this);
        this.fIdToTest = new HashMap();
        this.fTestRunnerClient = new RemoteTestRunnerClient();
        this.fTestRunnerClient.startListening(new ITestRunListener2[]{new TestSessionNotifier()}, port);
        final ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchesListener)new ILaunchesListener2(){

            public void launchesTerminated(ILaunch[] launches) {
                if (Arrays.asList(launches).contains(TestRunSession.this.fLaunch)) {
                    if (TestRunSession.this.fTestRunnerClient != null) {
                        TestRunSession.this.fTestRunnerClient.stopWaiting();
                    }
                    launchManager.removeLaunchListener((ILaunchesListener)this);
                }
            }

            public void launchesRemoved(ILaunch[] launches) {
                if (Arrays.asList(launches).contains(TestRunSession.this.fLaunch)) {
                    if (TestRunSession.this.fTestRunnerClient != null) {
                        TestRunSession.this.fTestRunnerClient.stopWaiting();
                    }
                    launchManager.removeLaunchListener((ILaunchesListener)this);
                }
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesAdded(ILaunch[] launches) {
            }
        });
        this.fSessionListeners = new ListenerList();
        this.addTestSessionListener(new TestRunListenerAdapter(this));
    }

    void reset() {
        this.fStartedCount = 0;
        this.fFailureCount = 0;
        this.fAssumptionFailureCount = 0;
        this.fErrorCount = 0;
        this.fIgnoredCount = 0;
        this.fTotalCount = 0;
        this.fTestRoot = new TestRoot(this);
        this.fTestResult = null;
        this.fIdToTest = new HashMap();
    }

    @Override
    public ITestElement.ProgressState getProgressState() {
        if (this.isRunning()) {
            return ITestElement.ProgressState.RUNNING;
        }
        if (this.isStopped()) {
            return ITestElement.ProgressState.STOPPED;
        }
        return ITestElement.ProgressState.COMPLETED;
    }

    @Override
    public ITestElement.Result getTestResult(boolean includeChildren) {
        if (this.fTestRoot != null) {
            return this.fTestRoot.getTestResult(true);
        }
        return this.fTestResult;
    }

    @Override
    public ITestElement[] getChildren() {
        return this.getTestRoot().getChildren();
    }

    @Override
    public ITestElement.FailureTrace getFailureTrace() {
        return null;
    }

    @Override
    public ITestElementContainer getParentContainer() {
        return null;
    }

    @Override
    public ITestRunSession getTestRunSession() {
        return this;
    }

    public synchronized TestRoot getTestRoot() {
        this.swapIn();
        return this.fTestRoot;
    }

    @Override
    public IJavaProject getLaunchedProject() {
        return this.fProject;
    }

    public ITestKind getTestRunnerKind() {
        return this.fTestRunnerKind;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    @Override
    public String getTestRunName() {
        return this.fTestRunName;
    }

    public int getErrorCount() {
        return this.fErrorCount;
    }

    public int getFailureCount() {
        return this.fFailureCount;
    }

    public int getAssumptionFailureCount() {
        return this.fAssumptionFailureCount;
    }

    public int getStartedCount() {
        return this.fStartedCount;
    }

    public int getIgnoredCount() {
        return this.fIgnoredCount;
    }

    public int getTotalCount() {
        return this.fTotalCount;
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    public boolean isStopped() {
        return this.fIsStopped;
    }

    public synchronized void addTestSessionListener(ITestSessionListener listener) {
        this.swapIn();
        this.fSessionListeners.add((Object)listener);
    }

    public void removeTestSessionListener(ITestSessionListener listener) {
        this.fSessionListeners.remove((Object)listener);
    }

    public synchronized void swapOut() {
        if (this.fTestRoot == null) {
            return;
        }
        if (this.isRunning() || this.isStarting() || this.isKeptAlive()) {
            return;
        }
        for (ITestSessionListener registered : this.fSessionListeners) {
            if (registered.acceptsSwapToDisk()) continue;
            return;
        }
        try {
            File swapFile = this.getSwapFile();
            JUnitModel.exportTestRunSession(this, swapFile);
            this.fTestResult = this.fTestRoot.getTestResult(true);
            this.fTestRoot = null;
            this.fTestRunnerClient = null;
            this.fIdToTest = new HashMap();
            this.fIncompleteTestSuites = null;
            this.fFactoryTestSuites = null;
            this.fUnrootedSuite = null;
        }
        catch (IllegalStateException | CoreException e) {
            JUnitCorePlugin.log(e);
        }
    }

    public boolean isStarting() {
        return this.getStartTime() == 0L && this.fLaunch != null && !this.fLaunch.isTerminated();
    }

    public void removeSwapFile() {
        File swapFile = this.getSwapFile();
        if (swapFile.exists()) {
            swapFile.delete();
        }
    }

    private File getSwapFile() throws IllegalStateException {
        File historyDir = JUnitCorePlugin.getHistoryDirectory();
        String isoTime = new SimpleDateFormat("yyyyMMdd-HHmmss.SSS").format(new Date(this.getStartTime()));
        String swapFileName = isoTime + ".xml";
        return new File(historyDir, swapFileName);
    }

    public synchronized void swapIn() {
        if (this.fTestRoot != null) {
            return;
        }
        try {
            JUnitModel.importIntoTestRunSession(this.getSwapFile(), this);
        }
        catch (IllegalStateException | CoreException e) {
            JUnitCorePlugin.log(e);
            this.fTestRoot = new TestRoot(this);
            this.fTestResult = null;
        }
    }

    public void stopTestRun() {
        if (this.isRunning() || !this.isKeptAlive()) {
            this.fIsStopped = true;
        }
        if (this.fTestRunnerClient != null) {
            this.fTestRunnerClient.stopTest();
        }
    }

    public boolean isKeptAlive() {
        if (this.fTestRunnerClient != null && this.fLaunch != null && this.fTestRunnerClient.isRunning() && "debug".equals(this.fLaunch.getLaunchMode())) {
            ILaunchConfiguration config = this.fLaunch.getLaunchConfiguration();
            try {
                return config != null && config.getAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return false;
    }

    public boolean isRunning() {
        return this.fIsRunning;
    }

    public boolean rerunTest(String testId, String className, String testName) {
        if (this.isKeptAlive()) {
            TestElement.Status status = ((TestCaseElement)this.getTestElement(testId)).getStatus();
            if (status == TestElement.Status.ERROR) {
                --this.fErrorCount;
            } else if (status == TestElement.Status.FAILURE) {
                --this.fFailureCount;
            }
            this.fTestRunnerClient.rerunTest(testId, className, testName);
            return true;
        }
        return false;
    }

    public TestElement getTestElement(String id) {
        return this.fIdToTest.get(id);
    }

    private TestElement addTreeEntry(String treeEntry) {
        String uniqueId;
        String[] parameterTypes;
        String displayName;
        String parentId;
        boolean isDynamicTest;
        int testCount;
        int index0 = treeEntry.indexOf(44);
        String id = treeEntry.substring(0, index0);
        StringBuffer testNameBuffer = new StringBuffer(100);
        int index1 = this.scanTestName(treeEntry, index0 + 1, testNameBuffer);
        String testName = testNameBuffer.toString().trim();
        int index2 = treeEntry.indexOf(44, index1 + 1);
        boolean isSuite = "true".equals(treeEntry.substring(index1 + 1, index2));
        StringBuffer displayNameBuffer = new StringBuffer(100);
        StringBuffer parameterTypesBuffer = new StringBuffer(200);
        StringBuffer uniqueIdBuffer = new StringBuffer(200);
        int index3 = treeEntry.indexOf(44, index2 + 1);
        if (index3 == -1) {
            testCount = Integer.parseInt(treeEntry.substring(index2 + 1));
            isDynamicTest = false;
            parentId = null;
            displayName = null;
            parameterTypes = null;
            uniqueId = null;
        } else {
            testCount = Integer.parseInt(treeEntry.substring(index2 + 1, index3));
            int index4 = treeEntry.indexOf(44, index3 + 1);
            isDynamicTest = "true".equals(treeEntry.substring(index3 + 1, index4));
            int index5 = treeEntry.indexOf(44, index4 + 1);
            parentId = treeEntry.substring(index4 + 1, index5);
            if ("-1".equals(parentId)) {
                parentId = null;
            }
            int index6 = this.scanTestName(treeEntry, index5 + 1, displayNameBuffer);
            displayName = displayNameBuffer.toString().trim();
            if (displayName.equals(testName)) {
                displayName = null;
            }
            int index7 = this.scanTestName(treeEntry, index6 + 1, parameterTypesBuffer);
            String parameterTypesString = parameterTypesBuffer.toString().trim();
            if (parameterTypesString.isEmpty()) {
                parameterTypes = null;
            } else {
                parameterTypes = parameterTypesString.split(",");
                Arrays.parallelSetAll(parameterTypes, i -> parameterTypes[i].trim());
            }
            this.scanTestName(treeEntry, index7 + 1, uniqueIdBuffer);
            uniqueId = uniqueIdBuffer.toString().trim();
            if (uniqueId.isEmpty()) {
                uniqueId = null;
            }
        }
        if (isDynamicTest) {
            if (parentId != null) {
                for (IncompleteTestSuite suite : this.fFactoryTestSuites) {
                    if (!parentId.equals(suite.fTestSuiteElement.getId())) continue;
                    return this.createTestElement(suite.fTestSuiteElement, id, testName, isSuite, testCount, isDynamicTest, displayName, parameterTypes, uniqueId);
                }
            }
            return this.createTestElement(this.getUnrootedSuite(), id, testName, isSuite, testCount, isDynamicTest, displayName, parameterTypes, uniqueId);
        }
        if (this.fIncompleteTestSuites.isEmpty()) {
            return this.createTestElement(this.fTestRoot, id, testName, isSuite, testCount, isDynamicTest, displayName, parameterTypes, uniqueId);
        }
        int suiteIndex = this.fIncompleteTestSuites.size() - 1;
        IncompleteTestSuite openSuite = this.fIncompleteTestSuites.get(suiteIndex);
        --openSuite.fOutstandingChildren;
        if (openSuite.fOutstandingChildren <= 0) {
            this.fIncompleteTestSuites.remove(suiteIndex);
        }
        return this.createTestElement(openSuite.fTestSuiteElement, id, testName, isSuite, testCount, isDynamicTest, displayName, parameterTypes, uniqueId);
    }

    public TestElement createTestElement(TestSuiteElement parent, String id, String testName, boolean isSuite, int testCount, boolean isDynamicTest, String displayName, String[] parameterTypes, String uniqueId) {
        TestElement testElement;
        if (parameterTypes != null && parameterTypes.length > 1) {
            parameterTypes = (String[])Arrays.stream(parameterTypes).map(String::trim).toArray(String[]::new);
        }
        if (isSuite) {
            TestSuiteElement testSuiteElement = new TestSuiteElement(parent, id, testName, testCount, displayName, parameterTypes, uniqueId);
            testElement = testSuiteElement;
            if (testCount > 0) {
                this.fIncompleteTestSuites.add(new IncompleteTestSuite(testSuiteElement, testCount));
            } else if (this.fFactoryTestSuites != null) {
                this.fFactoryTestSuites.add(new IncompleteTestSuite(testSuiteElement, testCount));
            }
        } else {
            testElement = new TestCaseElement(parent, id, testName, displayName, isDynamicTest, parameterTypes, uniqueId);
        }
        this.fIdToTest.put(id, testElement);
        return testElement;
    }

    private int scanTestName(String s, int start, StringBuffer testName) {
        boolean inQuote = false;
        int i = start;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\\' && !inQuote) {
                inQuote = true;
            } else if (inQuote) {
                inQuote = false;
                testName.append(c);
            } else {
                if (c == ',') break;
                testName.append(c);
            }
            ++i;
        }
        return i;
    }

    private TestSuiteElement getUnrootedSuite() {
        if (this.fUnrootedSuite == null) {
            this.fUnrootedSuite = (TestSuiteElement)this.createTestElement(this.fTestRoot, "-2", JUnitMessages.TestRunSession_unrootedTests, true, 0, false, JUnitMessages.TestRunSession_unrootedTests, null, null);
        }
        return this.fUnrootedSuite;
    }

    public void registerTestFailureStatus(TestElement testElement, TestElement.Status status, String trace, String expected, String actual) {
        testElement.setStatus(status, trace, expected, actual);
        if (!testElement.isAssumptionFailure()) {
            if (status.isError()) {
                ++this.fErrorCount;
            } else if (status.isFailure()) {
                ++this.fFailureCount;
            }
        }
    }

    public void registerTestEnded(TestElement testElement, boolean completed) {
        if (testElement instanceof TestCaseElement) {
            ++this.fTotalCount;
            if (!completed) {
                return;
            }
            ++this.fStartedCount;
            if (((TestCaseElement)testElement).isIgnored()) {
                ++this.fIgnoredCount;
            }
            if (!testElement.getStatus().isErrorOrFailure()) {
                this.setStatus(testElement, TestElement.Status.OK);
            }
        }
        if (testElement.isAssumptionFailure()) {
            ++this.fAssumptionFailureCount;
        }
    }

    private void setStatus(TestElement testElement, TestElement.Status status) {
        testElement.setStatus(status);
    }

    public TestElement[] getAllFailedTestElements() {
        ArrayList<ITestElement> failures = new ArrayList<ITestElement>();
        this.addFailures(failures, this.getTestRoot());
        return failures.toArray(new TestElement[failures.size()]);
    }

    private void addFailures(ArrayList<ITestElement> failures, ITestElement testElement) {
        ITestElement.Result testResult = testElement.getTestResult(true);
        if (testResult == ITestElement.Result.ERROR || testResult == ITestElement.Result.FAILURE) {
            failures.add(testElement);
        }
        if (testElement instanceof TestSuiteElement) {
            ITestElement[] children;
            TestSuiteElement testSuiteElement = (TestSuiteElement)testElement;
            ITestElement[] iTestElementArray = children = testSuiteElement.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ITestElement child = iTestElementArray[n2];
                this.addFailures(failures, child);
                ++n2;
            }
        }
    }

    @Override
    public double getElapsedTimeInSeconds() {
        if (this.fTestRoot == null) {
            return Double.NaN;
        }
        return this.fTestRoot.getElapsedTimeInSeconds();
    }

    public String getIncludeTags() {
        if (this.fLaunch != null) {
            try {
                boolean hasIncludeTags;
                ILaunchConfiguration launchConfig = this.fLaunch.getLaunchConfiguration();
                if (launchConfig != null && (hasIncludeTags = launchConfig.getAttribute("org.eclipse.jdt.junit.HAS_INCLUDE_TAGS", false))) {
                    return launchConfig.getAttribute("org.eclipse.jdt.junit.INCLUDE_TAGS", EMPTY_STRING);
                }
            }
            catch (CoreException coreException) {}
            return EMPTY_STRING;
        }
        return this.fIncludeTags;
    }

    public String getExcludeTags() {
        if (this.fLaunch != null) {
            try {
                boolean hasExcludeTags;
                ILaunchConfiguration launchConfig = this.fLaunch.getLaunchConfiguration();
                if (launchConfig != null && (hasExcludeTags = launchConfig.getAttribute("org.eclipse.jdt.junit.HAS_EXCLUDE_TAGS", false))) {
                    return launchConfig.getAttribute("org.eclipse.jdt.junit.EXCLUDE_TAGS", EMPTY_STRING);
                }
            }
            catch (CoreException coreException) {}
            return EMPTY_STRING;
        }
        return this.fExcludeTags;
    }

    public void setIncludeTags(String includeTags) {
        this.fIncludeTags = includeTags;
    }

    public void setExcludeTags(String excludeTags) {
        this.fExcludeTags = excludeTags;
    }

    public String toString() {
        return this.fTestRunName + " " + DateFormat.getDateTimeInstance().format(new Date(this.fStartTime));
    }

    private static class IncompleteTestSuite {
        public TestSuiteElement fTestSuiteElement;
        public int fOutstandingChildren;

        public IncompleteTestSuite(TestSuiteElement testSuiteElement, int outstandingChildren) {
            this.fTestSuiteElement = testSuiteElement;
            this.fOutstandingChildren = outstandingChildren;
        }
    }

    private class TestSessionNotifier
    implements ITestRunListener2 {
        private TestSessionNotifier() {
        }

        @Override
        public void testRunStarted(int testCount) {
            TestRunSession.this.fIncompleteTestSuites = new ArrayList<IncompleteTestSuite>();
            TestRunSession.this.fFactoryTestSuites = new ArrayList<IncompleteTestSuite>();
            TestRunSession.this.fStartedCount = 0;
            TestRunSession.this.fIgnoredCount = 0;
            TestRunSession.this.fFailureCount = 0;
            TestRunSession.this.fAssumptionFailureCount = 0;
            TestRunSession.this.fErrorCount = 0;
            TestRunSession.this.fTotalCount = testCount;
            TestRunSession.this.fStartTime = System.currentTimeMillis();
            TestRunSession.this.fIsRunning = true;
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.sessionStarted();
            }
        }

        @Override
        public void testRunEnded(long elapsedTime) {
            TestRunSession.this.fIsRunning = false;
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.sessionEnded(elapsedTime);
            }
        }

        @Override
        public void testRunStopped(long elapsedTime) {
            TestRunSession.this.fIsRunning = false;
            TestRunSession.this.fIsStopped = true;
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.sessionStopped(elapsedTime);
            }
        }

        @Override
        public void testRunTerminated() {
            TestRunSession.this.fIsRunning = false;
            TestRunSession.this.fIsStopped = true;
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.sessionTerminated();
            }
        }

        @Override
        public void testTreeEntry(String description) {
            TestElement testElement = TestRunSession.this.addTreeEntry(description);
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.testAdded(testElement);
            }
        }

        private TestElement createUnrootedTestElement(String testId, String testName) {
            TestSuiteElement unrootedSuite = TestRunSession.this.getUnrootedSuite();
            TestElement testElement = TestRunSession.this.createTestElement(unrootedSuite, testId, testName, false, 1, false, testName, null, null);
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.testAdded(testElement);
            }
            return testElement;
        }

        @Override
        public void testStarted(String testId, String testName) {
            TestElement testElement;
            if (TestRunSession.this.fStartedCount == 0) {
                for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                    listener.runningBegins();
                }
            }
            if ((testElement = TestRunSession.this.getTestElement(testId)) == null) {
                testElement = this.createUnrootedTestElement(testId, testName);
            } else if (!(testElement instanceof TestCaseElement)) {
                this.logUnexpectedTest(testId, testElement);
                return;
            }
            TestCaseElement testCaseElement = (TestCaseElement)testElement;
            TestRunSession.this.setStatus(testCaseElement, TestElement.Status.RUNNING);
            if (testCaseElement.isDynamicTest()) {
                ++TestRunSession.this.fTotalCount;
            }
            ++TestRunSession.this.fStartedCount;
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.testStarted(testCaseElement);
            }
        }

        @Override
        public void testEnded(String testId, String testName) {
            boolean isIgnored = testName.startsWith("@Ignore: ");
            TestElement testElement = TestRunSession.this.getTestElement(testId);
            if (testElement == null) {
                testElement = this.createUnrootedTestElement(testId, testName);
            } else if (!(testElement instanceof TestCaseElement)) {
                if (isIgnored) {
                    testElement.setAssumptionFailed(true);
                    ++TestRunSession.this.fAssumptionFailureCount;
                    TestRunSession.this.setStatus(testElement, TestElement.Status.OK);
                } else {
                    this.logUnexpectedTest(testId, testElement);
                }
                return;
            }
            TestCaseElement testCaseElement = (TestCaseElement)testElement;
            if (isIgnored) {
                testCaseElement.setIgnored(true);
                ++TestRunSession.this.fIgnoredCount;
            }
            if (testCaseElement.getStatus() == TestElement.Status.RUNNING) {
                TestRunSession.this.setStatus(testCaseElement, TestElement.Status.OK);
            }
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.testEnded(testCaseElement);
            }
        }

        @Override
        public void testFailed(int statusCode, String testId, String testName, String trace, String expected, String actual) {
            TestElement.Status status;
            TestElement testElement = TestRunSession.this.getTestElement(testId);
            if (testElement == null) {
                testElement = this.createUnrootedTestElement(testId, testName);
            }
            if (testName.startsWith("@AssumptionFailure: ")) {
                testElement.setAssumptionFailed(true);
                ++TestRunSession.this.fAssumptionFailureCount;
                status = TestElement.Status.OK;
            } else {
                status = TestElement.Status.convert(statusCode);
            }
            TestRunSession.this.registerTestFailureStatus(testElement, status, trace, expected, actual);
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.testFailed(testElement, status, trace, expected, actual);
            }
        }

        @Override
        public void testReran(String testId, String className, String testName, int statusCode, String trace, String expectedResult, String actualResult) {
            TestElement testElement = TestRunSession.this.getTestElement(testId);
            if (testElement == null) {
                testElement = this.createUnrootedTestElement(testId, testName);
            } else if (!(testElement instanceof TestCaseElement)) {
                this.logUnexpectedTest(testId, testElement);
                return;
            }
            TestCaseElement testCaseElement = (TestCaseElement)testElement;
            TestElement.Status status = TestElement.Status.convert(statusCode);
            TestRunSession.this.registerTestFailureStatus(testElement, status, trace, expectedResult, actualResult);
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.testReran(testCaseElement, status, trace, expectedResult, actualResult);
            }
        }

        private void logUnexpectedTest(String testId, TestElement testElement) {
            JUnitCorePlugin.log(new Exception("Unexpected TestElement type for testId '" + testId + "': " + String.valueOf(testElement)));
        }
    }
}

