/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.views;

import java.util.Objects;
import org.eclipse.jdt.jeview.views.Error;
import org.eclipse.jdt.jeview.views.JEAttribute;

public class JavaElementProperty
extends JEAttribute {
    private final JEAttribute fParent;
    private final String fName;
    private final String fValue;
    private final Object fValueObject;

    public JavaElementProperty(JEAttribute parent, String name) {
        this.fParent = parent;
        this.fName = name;
        this.fValue = null;
        this.fValueObject = null;
    }

    public JavaElementProperty(JEAttribute parent, String name, Object value) {
        this.fParent = parent;
        this.fName = name;
        this.fValueObject = value;
        this.fValue = value instanceof String ? "\"" + String.valueOf(value) + "\"" : String.valueOf(value);
    }

    @Override
    public JEAttribute getParent() {
        return this.fParent;
    }

    @Override
    public Object getWrappedObject() {
        return this.fValueObject;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        JavaElementProperty other = (JavaElementProperty)obj;
        if (!Objects.equals(this.fParent, other.fParent)) {
            return false;
        }
        return Objects.equals(this.fName, other.fName);
    }

    @Override
    public int hashCode() {
        return (this.fParent != null ? this.fParent.hashCode() : 0) + (this.fName != null ? this.fName.hashCode() : 0);
    }

    @Override
    public JEAttribute[] getChildren() {
        if (this.fValue != null) {
            return EMPTY;
        }
        try {
            this.computeValue();
            return EMPTY;
        }
        catch (Exception e) {
            return new Error[]{new Error(this, "", e)};
        }
    }

    @Override
    public String getLabel() {
        String value = this.fValue;
        if (value == null) {
            try {
                value = String.valueOf(this.computeValue());
            }
            catch (Exception exception) {
                return "ERROR";
            }
        }
        if (this.fName == null) {
            return value;
        }
        return this.fName + ": " + value;
    }

    protected Object computeValue() throws Exception {
        return this.fValue;
    }
}

