/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class RefactoringCorrectionProposalCore
extends LinkedCorrectionProposalCore {
    private final Refactoring fRefactoring;
    private RefactoringStatus fRefactoringStatus;

    public RefactoringCorrectionProposalCore(String name, ICompilationUnit cu, Refactoring refactoring, int relevance) {
        super(name, cu, (ASTRewrite)null, relevance);
        this.fRefactoring = refactoring;
    }

    public Refactoring getRefactoring() {
        return this.fRefactoring;
    }

    protected void init(Refactoring refactoring) throws CoreException {
    }

    @Override
    public TextChange createTextChange() throws CoreException {
        this.init(this.fRefactoring);
        this.fRefactoringStatus = this.fRefactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor());
        if (this.fRefactoringStatus.hasFatalError()) {
            TextFileChange dummyChange = new TextFileChange("fatal error", (IFile)this.getCompilationUnit().getResource());
            dummyChange.setEdit((TextEdit)new InsertEdit(0, ""));
            return dummyChange;
        }
        return (TextChange)this.fRefactoring.createChange((IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        if (this.fRefactoringStatus != null && this.fRefactoringStatus.hasFatalError()) {
            return this.fRefactoringStatus.getEntryWithHighestSeverity().getMessage();
        }
        return super.getAdditionalProposalInfo(monitor);
    }
}

