/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import javafx.scene.Node;
import org.eclipse.gef.mvc.fx.operations.AbstractCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.AddContentChildOperation;
import org.eclipse.gef.mvc.fx.operations.AttachToContentAnchorageOperation;
import org.eclipse.gef.mvc.fx.operations.DetachFromContentAnchorageOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.operations.RemoveContentChildOperation;
import org.eclipse.gef.mvc.fx.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.AbstractPolicy;

public class ContentPolicy
extends AbstractPolicy {
    public void addContentChild(Object contentChild, int index) {
        this.checkInitialized();
        this.getCompositeOperation().add(new AddContentChildOperation((IContentPart<? extends Node>)this.getHost(), contentChild, index));
        this.locallyExecuteOperation();
    }

    public void attachToContentAnchorage(Object contentAnchorage, String role) {
        this.checkInitialized();
        this.getCompositeOperation().add(new AttachToContentAnchorageOperation((IContentPart<? extends Node>)this.getHost(), contentAnchorage, role));
        this.locallyExecuteOperation();
    }

    @Override
    protected ITransactionalOperation createOperation() {
        return new ReverseUndoCompositeOperation("Content Change");
    }

    public void detachFromContentAnchorage(Object contentAnchorage, String role) {
        this.checkInitialized();
        this.getCompositeOperation().add(new DetachFromContentAnchorageOperation((IContentPart<? extends Node>)this.getHost(), contentAnchorage, role));
        this.locallyExecuteOperation();
    }

    protected AbstractCompositeOperation getCompositeOperation() {
        return (AbstractCompositeOperation)this.getOperation();
    }

    public IContentPart<? extends Node> getHost() {
        return (IContentPart)super.getHost();
    }

    public void removeContentChild(Object contentChild) {
        this.checkInitialized();
        this.getCompositeOperation().add(new RemoveContentChildOperation((IContentPart<? extends Node>)this.getHost(), contentChild));
        this.locallyExecuteOperation();
    }

    public void setAdaptable(IVisualPart<? extends Node> adaptable) {
        if (adaptable != null && !(adaptable instanceof IContentPart)) {
            throw new IllegalStateException("A ContentPolicy may only be attached to an IContentPart.");
        }
        super.setAdaptable(adaptable);
    }
}

