/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.ecore;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.EmfParsleyActivator;
import org.eclipse.emf.parsley.ecore.FeatureNamePath;

public class FeatureResolver {
    public List<EStructuralFeature> getFeatures(EClass eClass, List<FeatureNamePath> paths) {
        LinkedList<EStructuralFeature> features = new LinkedList<EStructuralFeature>();
        this.collectFeatures(eClass, paths, features);
        return features;
    }

    protected void collectFeatures(EClass eClass, List<FeatureNamePath> paths, List<EStructuralFeature> features) {
        for (FeatureNamePath path : paths) {
            EStructuralFeature feature = this.getFeature(eClass, path.getFeatureName());
            if (feature == null) continue;
            if (path.getPaths() == null) {
                features.add(feature);
                continue;
            }
            EClassifier type = feature.getEType();
            if (type instanceof EClass) {
                EClass eC = (EClass)type;
                this.collectFeatures(eC, path.getPaths(), features);
                continue;
            }
            EmfParsleyActivator.logError("feature '" + feature.getName() + "' in EClass '" + this.getEClassDescription(eClass) + "'" + " is not an EClass.");
        }
    }

    public EStructuralFeature getFeature(EClass eClass, String featureName) {
        EStructuralFeature feature = eClass.getEStructuralFeature(featureName);
        if (feature != null) {
            return feature;
        }
        for (EStructuralFeature f : eClass.getEAllStructuralFeatures()) {
            if (!f.getName().equalsIgnoreCase(featureName)) continue;
            return f;
        }
        EmfParsleyActivator.logError("cannot find feature '" + featureName + "' in EClass '" + this.getEClassDescription(eClass) + "'");
        return null;
    }

    protected String getEClassDescription(EClass eClass) {
        return String.valueOf(eClass.getName()) + " (" + eClass.getInstanceClassName() + ")";
    }
}

