/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.function.Function;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IRepositoryProtector;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.factory.AnnotationFactory;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.security.ICrypter;
import org.eclipse.net4j.util.security.IUserManagement;
import org.eclipse.net4j.util.security.SecurityUtil;

public class FileUserAuthenticator
extends IRepositoryProtector.UserAuthenticator
implements IUserManagement {
    private Path path;
    private boolean portable;
    private ICrypter passwordCrypter;
    private FileTime fileModifiedTime;
    private final Map<String, FileUserInfo> userInfos = new HashMap<String, FileUserInfo>();

    @Override
    public Class<? extends IRepositoryProtector.UserInfo> getUserInfoClass() {
        return FileUserInfo.class;
    }

    public final Path getPath() {
        return this.path;
    }

    @AnnotationFactory.InjectAttribute(name="path")
    public final void setPath(Path path) {
        this.checkInactive();
        this.path = path;
    }

    public final boolean isPortable() {
        return this.portable;
    }

    @AnnotationFactory.InjectAttribute(name="portable")
    public final void setPortable(boolean portable) {
        this.checkInactive();
        this.portable = portable;
    }

    public final ICrypter getPasswordCrypter() {
        return this.passwordCrypter;
    }

    @AnnotationFactory.InjectElement(name="passwordCrypter", productGroup="org.eclipse.net4j.util.security.crypters", descriptionAttribute="params")
    public final void setPasswordCrypter(ICrypter passwordCrypter) {
        this.checkInactive();
        this.passwordCrypter = passwordCrypter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(String userID, char[] password) {
        this.checkActive();
        Map<String, FileUserInfo> map = this.userInfos;
        synchronized (map) {
            if (this.userInfos.containsKey(userID)) {
                throw new IllegalStateException("User " + userID + " does already exist");
            }
            String convertedPassword = this.convertPassword(password);
            this.userInfos.put(userID, new FileUserInfo(userID, convertedPassword, false));
            try {
                this.saveFile();
            }
            catch (Exception ex) {
                this.userInfos.remove(userID);
                throw WrappedException.wrap((Exception)ex);
            }
            catch (Error ex) {
                this.userInfos.remove(userID);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(String userID) {
        this.checkActive();
        Map<String, FileUserInfo> map = this.userInfos;
        synchronized (map) {
            FileUserInfo userInfo = this.userInfos.remove(userID);
            if (userInfo == null) {
                throw new IllegalStateException("User " + userID + " does not exist");
            }
            try {
                this.saveFile();
            }
            catch (Exception ex) {
                this.userInfos.put(userID, userInfo);
                throw WrappedException.wrap((Exception)ex);
            }
            catch (Error ex) {
                this.userInfos.put(userID, userInfo);
                throw ex;
            }
        }
    }

    public void setPassword(String userID, char[] newPassword) {
        this.checkActive();
        this.modifyUser(userID, oldUserInfo -> new FileUserInfo(userID, this.convertPassword(newPassword), oldUserInfo.administrator()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdministrator(String userID) {
        this.checkActive();
        Map<String, FileUserInfo> map = this.userInfos;
        synchronized (map) {
            try {
                this.reconcileFile();
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
            FileUserInfo userInfo = this.userInfos.get(userID);
            return userInfo != null && userInfo.administrator();
        }
    }

    public void setAdministrator(String userID, boolean administrator) {
        this.checkActive();
        this.modifyUser(userID, oldUserInfo -> new FileUserInfo(userID, ((FileUserInfo)oldUserInfo).convertedPassword, administrator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileUserInfo authenticateUser(String userID, char[] password) {
        String convertedPassword;
        FileUserInfo userInfo;
        this.checkActive();
        Map<String, FileUserInfo> map = this.userInfos;
        synchronized (map) {
            try {
                this.reconcileFile();
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
            userInfo = this.userInfos.get(userID);
            if (userInfo == null) {
                return null;
            }
        }
        String storedPassword = userInfo.convertedPassword;
        if (storedPassword == null) {
            return null;
        }
        ICrypter crypter = this.passwordCrypter;
        if (this.portable && storedPassword.startsWith("$")) {
            String config = storedPassword.substring(1);
            int firstDollar = config.indexOf(36);
            int lastDollar = config.lastIndexOf(36);
            if (firstDollar != -1 && lastDollar != -1) {
                String type = config.substring(0, firstDollar);
                String params = firstDollar == lastDollar ? null : config.substring(firstDollar + 1, lastDollar);
                crypter = (ICrypter)this.getContainer().getElement("org.eclipse.net4j.util.security.crypters", type, params);
            }
        }
        if ((convertedPassword = this.convertPassword(password, crypter)) == null) {
            return null;
        }
        if (!Objects.equals(convertedPassword, storedPassword)) {
            return null;
        }
        return userInfo;
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.path, "path");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        LifecycleUtil.activate((Object)this.passwordCrypter);
        this.reconcileFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeactivate() throws Exception {
        Map<String, FileUserInfo> map = this.userInfos;
        synchronized (map) {
            this.userInfos.clear();
            this.fileModifiedTime = null;
        }
        LifecycleUtil.deactivate((Object)this.passwordCrypter);
        super.doDeactivate();
    }

    protected final void saveFile() throws Exception {
        ArrayList<FileUserInfo> list = new ArrayList<FileUserInfo>(this.userInfos.values());
        list.sort(null);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(this.path, new OpenOption[0]);){
            for (FileUserInfo userInfo : list) {
                String line = this.convertLine(userInfo);
                writer.write(line);
                writer.write(StringUtil.NL);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.fileModifiedTime = Files.getLastModifiedTime(this.path, new LinkOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void reconcileFile() throws Exception {
        if (!Files.exists(this.path, new LinkOption[0])) {
            Files.createFile(this.path, new FileAttribute[0]);
            this.fileModifiedTime = Files.getLastModifiedTime(this.path, new LinkOption[0]);
            this.userInfos.clear();
            return;
        }
        FileTime lastModifiedTime = Files.getLastModifiedTime(this.path, new LinkOption[0]);
        if (this.fileModifiedTime != null) {
            if (this.fileModifiedTime.compareTo(lastModifiedTime) >= 0) return;
        }
        this.fileModifiedTime = lastModifiedTime;
        this.userInfos.clear();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = Files.newBufferedReader(this.path);){
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    return;
                }
                try {
                    FileUserInfo userInfo = this.parseLine(line);
                    if (userInfo == null) continue;
                    this.userInfos.put(userInfo.userID(), userInfo);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private FileUserInfo parseLine(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, ":");
        if (tokenizer.hasMoreTokens()) {
            String userID = StringUtil.unescape((String)tokenizer.nextToken(), (char)':');
            if (tokenizer.hasMoreTokens()) {
                String convertedPassword = StringUtil.unescape((String)tokenizer.nextToken(), (char)':');
                boolean administrator = false;
                if (tokenizer.hasMoreTokens()) {
                    administrator = Boolean.parseBoolean(tokenizer.nextToken());
                }
                return new FileUserInfo(userID, convertedPassword, administrator);
            }
        }
        return null;
    }

    private String convertLine(FileUserInfo userInfo) {
        String line = String.valueOf(StringUtil.escape((String)userInfo.userID(), (char)':')) + ':' + StringUtil.escape((String)userInfo.convertedPassword, (char)':');
        if (userInfo.administrator()) {
            line = String.valueOf(line) + ":true";
        }
        return line;
    }

    private String convertPassword(char[] password) {
        return this.convertPassword(password, this.passwordCrypter);
    }

    private String convertPassword(char[] password, ICrypter crypter) {
        String convertedPassword = SecurityUtil.toString((char[])password);
        if (crypter != null) {
            byte[] data = convertedPassword.getBytes(StandardCharsets.UTF_8);
            byte[] crypted = crypter.apply(data);
            convertedPassword = Base64.getEncoder().encodeToString(crypted);
            if (this.portable) {
                convertedPassword = this.makePortable(convertedPassword, crypter);
            }
        }
        return convertedPassword;
    }

    private String makePortable(String convertedPassword, ICrypter crypter) {
        String prefix = "$" + StringUtil.escape((String)crypter.getType(), (char)'$') + "$";
        String params = crypter.getParams();
        if (params != null) {
            prefix = String.valueOf(prefix) + StringUtil.escape((String)params, (char)'$') + "$";
        }
        return String.valueOf(prefix) + convertedPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyUser(String userID, Function<FileUserInfo, FileUserInfo> modifier) {
        Map<String, FileUserInfo> map = this.userInfos;
        synchronized (map) {
            FileUserInfo oldUserInfo = this.userInfos.remove(userID);
            if (oldUserInfo == null) {
                throw new IllegalStateException("User " + userID + " does not exist");
            }
            FileUserInfo newUserInfo = modifier.apply(oldUserInfo);
            this.userInfos.put(userID, newUserInfo);
            try {
                this.saveFile();
            }
            catch (Exception ex) {
                this.userInfos.put(userID, oldUserInfo);
                throw WrappedException.wrap((Exception)ex);
            }
            catch (Error ex) {
                this.userInfos.put(userID, oldUserInfo);
                throw ex;
            }
        }
    }

    public static class FileUserInfo
    extends IRepositoryProtector.UserInfo {
        private final String convertedPassword;
        private final boolean administrator;

        public FileUserInfo(String userID, String convertedPassword, boolean administrator) {
            super(userID);
            this.convertedPassword = convertedPassword;
            this.administrator = administrator;
        }

        public final boolean administrator() {
            return this.administrator;
        }

        @Override
        protected boolean isStructurallyEqual(IRepositoryProtector.UserInfo userInfo) {
            FileUserInfo other = (FileUserInfo)userInfo;
            return this.administrator == other.administrator;
        }
    }
}

