/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di.osgi;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectorFactory;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.di.shared.CoreLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ProviderHelper {
    protected static Map<String, ExtendedObjectSupplier> extendedSuppliers = new HashMap<String, ExtendedObjectSupplier>();

    static {
        Bundle bundle = FrameworkUtil.getBundle(ProviderHelper.class);
        if (bundle != null) {
            BundleContext bundleContext = bundle.getBundleContext();
            String filter = "(objectClass=" + ExtendedObjectSupplier.SERVICE_NAME + ")";
            try {
                bundleContext.addServiceListener(event -> {
                    Map<String, ExtendedObjectSupplier> map = extendedSuppliers;
                    synchronized (map) {
                        extendedSuppliers.clear();
                    }
                }, filter);
            }
            catch (InvalidSyntaxException e) {
                CoreLogger.logError("Invalid filter format in the provider helper", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtendedObjectSupplier findProvider(String qualifier, PrimaryObjectSupplier objectSupplier) {
        Map<String, ExtendedObjectSupplier> map = extendedSuppliers;
        synchronized (map) {
            Bundle bundle;
            block10: {
                if (extendedSuppliers.containsKey(qualifier)) {
                    return extendedSuppliers.get(qualifier);
                }
                bundle = FrameworkUtil.getBundle(ProviderHelper.class);
                if (bundle != null) break block10;
                return null;
            }
            BundleContext bundleContext = bundle.getBundleContext();
            try {
                String filter = "(dependency.injection.annotation=" + qualifier + ")";
                ServiceReference[] refs = bundleContext.getServiceReferences(ExtendedObjectSupplier.SERVICE_NAME, filter);
                if (refs != null && refs.length > 0) {
                    if (refs.length > 1) {
                        Arrays.sort(refs, Collections.reverseOrder());
                    }
                    ExtendedObjectSupplier supplier = (ExtendedObjectSupplier)bundleContext.getService(refs[0]);
                    if (objectSupplier != null) {
                        IInjector injector = InjectorFactory.getDefault();
                        injector.inject(supplier, objectSupplier);
                    }
                    extendedSuppliers.put(qualifier, supplier);
                    return supplier;
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            extendedSuppliers.put(qualifier, null);
            return null;
        }
    }
}

