/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.rhino.Node;
import java.util.Set;

public final class JqueryCodingConvention
extends CodingConventions.Proxy {
    private static final long serialVersionUID = 1L;
    private static final Set<String> propertyTestFunctions = ImmutableSet.of((Object)"jQuery.isPlainObject", (Object)"jQuery.isFunction", (Object)"jQuery.isNumeric", (Object)"jQuery.isEmptyObject");
    private static final Set<String> prototypeAliases = ImmutableSet.of((Object)"jQuery.fn", (Object)"jQuerySub.fn");

    public JqueryCodingConvention() {
        this(CodingConventions.getDefault());
    }

    public JqueryCodingConvention(CodingConvention wrapped) {
        super(wrapped);
    }

    @Override
    public String getGlobalObject() {
        return "window";
    }

    @Override
    public boolean isPropertyTestFunction(Node call) {
        Preconditions.checkArgument((boolean)call.isCall());
        return propertyTestFunctions.contains(call.getFirstChild().getQualifiedName());
    }

    @Override
    public boolean isPrototypeAlias(Node getProp) {
        Preconditions.checkArgument((boolean)getProp.isGetProp());
        return prototypeAliases.contains(getProp.getQualifiedName());
    }
}

