/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.IpamConfig;

final class ImmutableIpamConfig
implements IpamConfig {
    @Nullable
    private final String subnet;
    @Nullable
    private final String ipRange;
    @Nullable
    private final String gateway;

    private ImmutableIpamConfig(@Nullable String subnet, @Nullable String ipRange, @Nullable String gateway) {
        this.subnet = subnet;
        this.ipRange = ipRange;
        this.gateway = gateway;
    }

    @Override
    @JsonProperty(value="Subnet")
    @Nullable
    public String subnet() {
        return this.subnet;
    }

    @Override
    @JsonProperty(value="IPRange")
    @Nullable
    public String ipRange() {
        return this.ipRange;
    }

    @Override
    @JsonProperty(value="Gateway")
    @Nullable
    public String gateway() {
        return this.gateway;
    }

    public final ImmutableIpamConfig withSubnet(@Nullable String value) {
        if (Objects.equals(this.subnet, value)) {
            return this;
        }
        return new ImmutableIpamConfig(value, this.ipRange, this.gateway);
    }

    public final ImmutableIpamConfig withIpRange(@Nullable String value) {
        if (Objects.equals(this.ipRange, value)) {
            return this;
        }
        return new ImmutableIpamConfig(this.subnet, value, this.gateway);
    }

    public final ImmutableIpamConfig withGateway(@Nullable String value) {
        if (Objects.equals(this.gateway, value)) {
            return this;
        }
        return new ImmutableIpamConfig(this.subnet, this.ipRange, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIpamConfig && this.equalTo((ImmutableIpamConfig)another);
    }

    private boolean equalTo(ImmutableIpamConfig another) {
        return Objects.equals(this.subnet, another.subnet) && Objects.equals(this.ipRange, another.ipRange) && Objects.equals(this.gateway, another.gateway);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.subnet);
        h += (h << 5) + Objects.hashCode(this.ipRange);
        h += (h << 5) + Objects.hashCode(this.gateway);
        return h;
    }

    public String toString() {
        return "IpamConfig{subnet=" + this.subnet + ", ipRange=" + this.ipRange + ", gateway=" + this.gateway + "}";
    }

    public static ImmutableIpamConfig copyOf(IpamConfig instance) {
        if (instance instanceof ImmutableIpamConfig) {
            return (ImmutableIpamConfig)instance;
        }
        return ImmutableIpamConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements IpamConfig.Builder {
        private String subnet;
        private String ipRange;
        private String gateway;

        private Builder() {
        }

        public final Builder from(IpamConfig instance) {
            String gatewayValue;
            String ipRangeValue;
            Objects.requireNonNull(instance, "instance");
            String subnetValue = instance.subnet();
            if (subnetValue != null) {
                this.subnet(subnetValue);
            }
            if ((ipRangeValue = instance.ipRange()) != null) {
                this.ipRange(ipRangeValue);
            }
            if ((gatewayValue = instance.gateway()) != null) {
                this.gateway(gatewayValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Subnet")
        public final Builder subnet(@Nullable String subnet) {
            this.subnet = subnet;
            return this;
        }

        @Override
        @JsonProperty(value="IPRange")
        public final Builder ipRange(@Nullable String ipRange) {
            this.ipRange = ipRange;
            return this;
        }

        @Override
        @JsonProperty(value="Gateway")
        public final Builder gateway(@Nullable String gateway) {
            this.gateway = gateway;
            return this;
        }

        @Override
        public ImmutableIpamConfig build() {
            return new ImmutableIpamConfig(this.subnet, this.ipRange, this.gateway);
        }
    }
}

