/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.client.messages.Descriptor;

final class ImmutableDescriptor
implements Descriptor {
    private final String mediaType;
    private final String digest;
    private final Long size;
    private final List<String> urls;

    private ImmutableDescriptor(String mediaType, String digest, Long size, List<String> urls) {
        this.mediaType = mediaType;
        this.digest = digest;
        this.size = size;
        this.urls = urls;
    }

    @Override
    @JsonProperty(value="MediaType")
    public String mediaType() {
        return this.mediaType;
    }

    @Override
    @JsonProperty(value="Digest")
    public String digest() {
        return this.digest;
    }

    @Override
    @JsonProperty(value="Size")
    public Long size() {
        return this.size;
    }

    @Override
    @JsonProperty(value="URLs")
    public List<String> urls() {
        return this.urls;
    }

    public final ImmutableDescriptor withMediaType(String value) {
        String newValue = Objects.requireNonNull(value, "mediaType");
        if (this.mediaType.equals(newValue)) {
            return this;
        }
        return new ImmutableDescriptor(newValue, this.digest, this.size, this.urls);
    }

    public final ImmutableDescriptor withDigest(String value) {
        String newValue = Objects.requireNonNull(value, "digest");
        if (this.digest.equals(newValue)) {
            return this;
        }
        return new ImmutableDescriptor(this.mediaType, newValue, this.size, this.urls);
    }

    public final ImmutableDescriptor withSize(Long value) {
        Long newValue = Objects.requireNonNull(value, "size");
        if (this.size.equals(newValue)) {
            return this;
        }
        return new ImmutableDescriptor(this.mediaType, this.digest, newValue, this.urls);
    }

    public final ImmutableDescriptor withUrls(String ... elements) {
        List<String> newValue = ImmutableDescriptor.createUnmodifiableList(false, ImmutableDescriptor.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDescriptor(this.mediaType, this.digest, this.size, newValue);
    }

    public final ImmutableDescriptor withUrls(Iterable<String> elements) {
        if (this.urls == elements) {
            return this;
        }
        List<String> newValue = ImmutableDescriptor.createUnmodifiableList(false, ImmutableDescriptor.createSafeList(elements, true, false));
        return new ImmutableDescriptor(this.mediaType, this.digest, this.size, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDescriptor && this.equalTo((ImmutableDescriptor)another);
    }

    private boolean equalTo(ImmutableDescriptor another) {
        return this.mediaType.equals(another.mediaType) && this.digest.equals(another.digest) && this.size.equals(another.size) && this.urls.equals(another.urls);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.mediaType.hashCode();
        h += (h << 5) + this.digest.hashCode();
        h += (h << 5) + this.size.hashCode();
        h += (h << 5) + this.urls.hashCode();
        return h;
    }

    public String toString() {
        return "Descriptor{mediaType=" + this.mediaType + ", digest=" + this.digest + ", size=" + this.size + ", urls=" + this.urls + "}";
    }

    public static ImmutableDescriptor copyOf(Descriptor instance) {
        if (instance instanceof ImmutableDescriptor) {
            return (ImmutableDescriptor)instance;
        }
        return ImmutableDescriptor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private static final long INIT_BIT_MEDIA_TYPE = 1L;
        private static final long INIT_BIT_DIGEST = 2L;
        private static final long INIT_BIT_SIZE = 4L;
        private long initBits = 7L;
        private String mediaType;
        private String digest;
        private Long size;
        private List<String> urls = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(Descriptor instance) {
            Objects.requireNonNull(instance, "instance");
            this.mediaType(instance.mediaType());
            this.digest(instance.digest());
            this.size(instance.size());
            this.addAllUrls(instance.urls());
            return this;
        }

        @JsonProperty(value="MediaType")
        public final Builder mediaType(String mediaType) {
            this.mediaType = Objects.requireNonNull(mediaType, "mediaType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Digest")
        public final Builder digest(String digest) {
            this.digest = Objects.requireNonNull(digest, "digest");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Size")
        public final Builder size(Long size) {
            this.size = Objects.requireNonNull(size, "size");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder url(String element) {
            this.urls.add(Objects.requireNonNull(element, "urls element"));
            return this;
        }

        public final Builder urls(String ... elements) {
            for (String element : elements) {
                this.urls.add(Objects.requireNonNull(element, "urls element"));
            }
            return this;
        }

        @JsonProperty(value="URLs")
        public final Builder urls(Iterable<String> elements) {
            this.urls.clear();
            return this.addAllUrls(elements);
        }

        public final Builder addAllUrls(Iterable<String> elements) {
            for (String element : elements) {
                this.urls.add(Objects.requireNonNull(element, "urls element"));
            }
            return this;
        }

        public ImmutableDescriptor build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDescriptor(this.mediaType, this.digest, this.size, ImmutableDescriptor.createUnmodifiableList(true, this.urls));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mediaType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("digest");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("size");
            }
            return "Cannot build Descriptor, some of required attributes are not set " + attributes;
        }
    }
}

