/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.java.resource;

import com.google.common.io.CharStreams;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IJavaSchemeUriResolver;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.AbstractClassMirror;
import org.eclipse.xtext.common.types.access.impl.AbstractJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.java.resource.JavaDerivedStateComputer;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IFragmentProvider;
import org.eclipse.xtext.resource.ISynchronizable;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class JavaResource
extends ResourceImpl
implements IJavaSchemeUriResolver,
ISynchronizable<JavaResource> {
    public static final String OPTION_ENCODING = String.valueOf(JavaResource.class.getName()) + ".DEFAULT_ENCODING";
    @Inject
    private IEncodingProvider encodingProvider;
    @Inject
    private JavaDerivedStateComputer derivedStateComputer;
    private CompilationUnit compilationUnit;
    private String contentsAsString;
    private boolean initialized = false;
    private boolean initializing = false;
    private IndexedJvmTypeAccess indexedJvmTypeAccess;
    private final IFragmentProvider.Fallback fallback = new IFragmentProvider.Fallback(){

        public EObject getEObject(String fragment) {
            return JavaResource.super.getEObjectByID(fragment);
        }

        public String getFragment(EObject obj) {
            return JavaResource.super.getURIFragment(obj);
        }
    };
    private final AbstractClassMirror m = new AbstractClassMirror(){

        protected String getTypeName() {
            throw new UnsupportedOperationException("TODO: auto-generated method stub");
        }

        protected String getTypeName(JvmType type) {
            return type.getIdentifier();
        }

        public void initialize(TypeResource typeResource) {
            throw new UnsupportedOperationException("TODO: auto-generated method stub");
        }

        public boolean isSealed() {
            throw new UnsupportedOperationException("TODO: auto-generated method stub");
        }
    };

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        String encoding = this.getEncoding(this.getURI(), options);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, encoding);
        this.contentsAsString = CharStreams.toString((Readable)inputStreamReader);
        this.compilationUnit = new CompilationUnit(this.contentsAsString.toCharArray(), this.getURI().lastSegment(), encoding, null);
    }

    protected String getEncoding(URI uri, Map<?, ?> options) {
        Object encodingOption;
        if (options != null && (encodingOption = options.get(OPTION_ENCODING)) instanceof String) {
            return (String)encodingOption;
        }
        return this.encodingProvider.getEncoding(uri);
    }

    protected CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList<EObject> getContents() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isLoaded && !this.isLoading && !this.initializing && !this.initialized) {
                try {
                    this.eSetDeliver(false);
                    this.installFull();
                }
                finally {
                    this.eSetDeliver(true);
                }
            }
            return super.getContents();
        }
    }

    protected List<EObject> getUnloadingContents() {
        return super.getContents();
    }

    public void installStubs() {
        this.initializing(() -> {
            this.derivedStateComputer.installStubs((Resource)this);
            this.initialized = true;
        });
    }

    public void installFull() {
        this.initializing(() -> {
            this.derivedStateComputer.installFull((Resource)this);
            this.compilationUnit = null;
            this.initialized = true;
        });
    }

    private void initializing(Procedures.Procedure0 init) {
        try {
            this.initializing = true;
            init.apply();
        }
        finally {
            this.initializing = false;
        }
    }

    public void discardDerivedState() {
        this.initializing(() -> {
            this.derivedStateComputer.discardDerivedState((Resource)this);
            this.initialized = false;
        });
    }

    public EObject resolveJavaObjectURIProxy(InternalEObject proxy, EObject sender) {
        URI proxyURI = proxy.eProxyURI();
        if (proxyURI != null && "java".equals(proxyURI.scheme()) && "Objects".equals(proxyURI.segment(0))) {
            IndexedJvmTypeAccess access = this.getIndexJvmTypeAccess();
            if (access != null) {
                try {
                    JavaElementFragment frag = new JavaElementFragment(proxy.eProxyURI());
                    EObject result = access.getIndexedJvmType(frag.getTypeURI(), this.getResourceSet());
                    if (result instanceof JvmDeclaredType && frag.isMethodFragment()) {
                        JavaFragmentProvider javaFragmentProvider = new JavaFragmentProvider();
                        Resource res = result.eResource();
                        result = javaFragmentProvider.getEObject(res, proxy.eProxyURI().fragment(), new IFragmentProvider.Fallback(){

                            public EObject getEObject(String fragment) {
                                return null;
                            }

                            public String getFragment(EObject obj) {
                                return null;
                            }
                        });
                    }
                    if (result != null) {
                        return result;
                    }
                }
                catch (Throwable t) {
                    if (t instanceof IndexedJvmTypeAccess.UnknownNestedTypeException) {
                        return proxy;
                    }
                    throw Exceptions.sneakyThrow((Throwable)t);
                }
            }
            return EcoreUtil.resolve((EObject)proxy, (EObject)sender);
        }
        return null;
    }

    public IndexedJvmTypeAccess getIndexJvmTypeAccess() {
        Object provider;
        if (this.indexedJvmTypeAccess == null && (provider = this.resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().get("java")) instanceof AbstractJvmTypeProvider) {
            this.indexedJvmTypeAccess = ((AbstractJvmTypeProvider)provider).getIndexedJvmTypeAccess();
        }
        return this.indexedJvmTypeAccess;
    }

    public Object getLock() {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet instanceof ISynchronizable) {
            return ((ISynchronizable)resourceSet).getLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Result> Result execute(IUnitOfWork<Result, ? super JavaResource> unit) throws Exception {
        Object object = this.getLock();
        synchronized (object) {
            return (Result)unit.exec((Object)this);
        }
    }

    protected EObject getEObjectByID(String id) {
        return this.m.getEObject((Resource)this, id, this.fallback);
    }

    public String getURIFragment(EObject eObject) {
        return this.m.getFragment(eObject, this.fallback);
    }

    public String getOriginalSource() {
        return this.contentsAsString;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isInitializing() {
        return this.initializing;
    }

    public static class Factory
    implements Resource.Factory {
        @Inject
        private Provider<JavaResource> resourceProvider;

        public Resource createResource(URI uri) {
            JavaResource resource = (JavaResource)((Object)this.resourceProvider.get());
            resource.setURI(uri);
            return resource;
        }
    }

    public static class JavaElementFragment {
        private URI uri;
        private int idx;

        public JavaElementFragment(URI uri) {
            this.uri = uri;
            this.idx = this.getMethodPartOffset(uri.fragment());
        }

        public URI getTypeURI() {
            if (this.idx == -1) {
                return this.uri;
            }
            String f = this.uri.fragment();
            return this.uri.appendFragment(f.substring(0, this.idx));
        }

        public boolean isMethodFragment() {
            return this.idx != -1;
        }

        protected int getMethodPartOffset(String string) {
            if (string.endsWith("()")) {
                return string.lastIndexOf(46);
            }
            return -1;
        }
    }

    public static class JavaFragmentProvider
    extends AbstractClassMirror {
        protected String getTypeName() {
            throw new UnsupportedOperationException("not supported");
        }

        protected String getTypeName(JvmType type) {
            return type.getQualifiedName('$');
        }

        public void initialize(TypeResource typeResource) {
            throw new UnsupportedOperationException("not supported");
        }

        public boolean isSealed() {
            return true;
        }
    }
}

