/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.integration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.util.emf.workbench.nls.EMFWorkbenchResourceHandler;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.wst.common.frameworks.internal.ISaveHandler;
import org.eclipse.wst.common.frameworks.internal.SaveFailedException;
import org.eclipse.wst.common.frameworks.internal.SaveHandlerHeadless;
import org.eclipse.wst.common.frameworks.internal.SaveHandlerRegister;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementIdentifierEvent;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementIdentifier;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementIdentifierListener;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.IWFTWrappedException;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityXMIResource;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;
import org.eclipse.wst.common.internal.emf.utilities.PleaseMigrateYourCodeError;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.edit.ClientAccessRegistry;
import org.eclipse.wst.common.internal.emfworkbench.edit.EditModelRegistry;
import org.eclipse.wst.common.internal.emfworkbench.edit.EditModelResource;
import org.eclipse.wst.common.internal.emfworkbench.edit.ReadOnlyClientAccessRegistry;
import org.eclipse.wst.common.internal.emfworkbench.integration.EMFWorkbenchEditPlugin;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;
import org.eclipse.wst.common.internal.emfworkbench.integration.ResourceSetWorkbenchEditSynchronizer;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateInputProvider;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorImpl;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorPresenter;

public class EditModel
implements CommandStackListener,
ResourceStateInputProvider,
ResourceStateValidator,
IEnablementIdentifierListener {
    protected BasicCommandStack commandStack;
    protected final ListenerList listeners = new ListenerList();
    private Map params;
    private final String editModelID;
    private final boolean readOnly;
    protected List knownResourceUris;
    protected List knownResourceExtensions;
    protected List preloadResourceUris;
    protected Map resourceIdentifiers;
    protected EditModelEvent dirtyModelEvent;
    protected boolean isNotifing = false;
    protected boolean disposing = false;
    private boolean disposed = false;
    protected ResourceStateValidator stateValidator;
    protected boolean accessAsReadForUnKnownURIs;
    protected ResourceAdapter resourceAdapter = new ResourceAdapter();
    protected boolean isReverting = false;
    protected List resources;
    private ClientAccessRegistry registry;
    protected EMFWorkbenchContext emfContext = null;
    protected IProject project = null;
    private Reference reference;
    private List resourcesTargetedForTermination;

    public EditModel(String editModelID, EMFWorkbenchContext context, boolean readOnly) {
        if (context == null) {
            throw new IllegalStateException("EMF context can't be null");
        }
        this.editModelID = editModelID;
        this.readOnly = readOnly;
        this.registry = readOnly ? new ReadOnlyClientAccessRegistry() : new ClientAccessRegistry();
        this.emfContext = context;
        this.project = context.getProject();
        this.initializeKnownResourceUris();
        this.processLoadedResources();
        this.processPreloadResources();
    }

    public EditModel(String editModelID, EMFWorkbenchContext context, boolean readOnly, boolean accessUnknownResourcesAsReadOnly) {
        this(editModelID, context, readOnly);
        this.accessAsReadForUnKnownURIs = accessUnknownResourcesAsReadOnly;
    }

    public String getEditModelID() {
        return this.editModelID;
    }

    public boolean isDisposing() {
        return this.disposing;
    }

    public void dispose() {
        try {
            if (this.disposing || this.disposed) {
                return;
            }
            try {
                this.disposing = true;
                if (this.hasListeners()) {
                    this.notifyListeners(new EditModelEvent(5, this));
                }
                this.releaseResources();
                if (this.commandStack != null) {
                    this.commandStack.removeCommandStackListener((CommandStackListener)this);
                }
                if (this.getEmfContext() != null) {
                    this.getEmfContext().removeEditModel(this, this.isReadOnly());
                }
                this.releasePreloadResources();
                this.releaseIdentifiers();
                this.doDispose();
            }
            catch (RuntimeException re) {
                EMFWorkbenchEditPlugin.logError(re);
            }
        }
        finally {
            this.emfContext = null;
            this.resources = null;
            this.project = null;
            this.disposed = true;
            this.disposing = false;
        }
    }

    protected void doDispose() {
    }

    protected void releaseIdentifiers() {
        if (this.resourceIdentifiers == null) {
            return;
        }
        Iterator iter = this.resourceIdentifiers.keySet().iterator();
        IEnablementIdentifier identifier = null;
        while (iter.hasNext()) {
            identifier = (IEnablementIdentifier)iter.next();
            identifier.removeIdentifierListener((IEnablementIdentifierListener)this);
        }
    }

    private ResourceSetWorkbenchSynchronizer getResourceSetSynchronizer() {
        if (this.emfContext == null || !this.emfContext.hasResourceSet()) {
            return null;
        }
        return this.getEmfContext().getResourceSet().getSynchronizer();
    }

    protected void releasePreloadResources() {
        ResourceSetWorkbenchEditSynchronizer sync = (ResourceSetWorkbenchEditSynchronizer)this.getResourceSetSynchronizer();
        if (sync != null) {
            int i = 0;
            while (i < this.preloadResourceUris.size()) {
                URI uri = (URI)this.preloadResourceUris.get(i);
                sync.disableAutoload(uri);
                ++i;
            }
            i = 0;
            while (i < this.knownResourceExtensions.size()) {
                String ext = (String)this.knownResourceExtensions.get(i);
                sync.disableAutoload(ext);
                ++i;
            }
        }
    }

    protected BasicCommandStack createCommandStack() {
        BasicCommandStack stack = new BasicCommandStack();
        return stack;
    }

    public void commandStackChanged(EventObject event) {
        if (this.dirtyModelEvent == null) {
            this.dirtyModelEvent = new EditModelEvent(2, this);
        }
        if (this.hasListeners()) {
            this.notifyListeners(this.dirtyModelEvent);
        }
    }

    protected void flushCommandStack() {
        this.getCommandStack().flush();
        this.getCommandStack().saveIsDone();
    }

    public BasicCommandStack getCommandStack() {
        if (this.commandStack == null) {
            this.commandStack = this.createCommandStack();
            this.commandStack.addCommandStackListener((CommandStackListener)this);
        }
        return this.commandStack;
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public void addListener(EditModelListener aListener) {
        if (aListener != null) {
            this.listeners.add((Object)aListener);
        }
    }

    protected void notifyListeners(EditModelEvent anEvent) {
        NotifyRunner notifier = new NotifyRunner(anEvent);
        Object[] notifyList = this.listeners.getListeners();
        int i = 0;
        while (i < notifyList.length) {
            notifier.setListener((EditModelListener)notifyList[i]);
            SafeRunner.run((ISafeRunnable)notifier);
            ++i;
        }
    }

    public boolean removeListener(EditModelListener aListener) {
        this.listeners.remove((Object)aListener);
        return true;
    }

    protected void makeFileEditable(IFile aFile) {
        if (aFile == null) {
            return;
        }
        aFile.getResourceAttributes().setReadOnly(false);
    }

    public List getReadOnlyAffectedFiles() {
        Iterator affected = this.getAffectedFiles().iterator();
        ArrayList<IFile> result = new ArrayList<IFile>();
        while (affected.hasNext()) {
            IFile aFile = (IFile)affected.next();
            if (!aFile.isReadOnly()) continue;
            result.add(aFile);
        }
        return result;
    }

    protected ISaveHandler getSaveHandler() {
        return SaveHandlerRegister.getSaveHandler();
    }

    protected void handleSaveIfNecessaryDidNotSave(IProgressMonitor monitor) {
    }

    public void save(Object accessorKey) {
        this.save(null, accessorKey);
    }

    public void save(IProgressMonitor monitor) throws PleaseMigrateYourCodeError {
    }

    public final void save(IProgressMonitor monitor, Object accessorKey) {
        this.assertPermissionToSave(accessorKey);
        this.getSaveHandler().access();
        try {
            try {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor aMonitor) {
                        EditModel.this.primSave(aMonitor);
                    }
                };
                this.runSaveOperation(runnable, monitor);
            }
            catch (SaveFailedException ex) {
                this.getSaveHandler().handleSaveFailed(ex, monitor);
                this.getSaveHandler().release();
            }
            catch (Exception ex) {
                EMFWorkbenchEditPlugin.logError(ex);
                this.getSaveHandler().release();
            }
        }
        finally {
            this.getSaveHandler().release();
        }
    }

    public void saveIfNecessary(Object accessorKey) {
        this.saveIfNecessary(null, accessorKey);
    }

    public void saveIfNecessary(IProgressMonitor monitor, Object accessorKey) {
        if (this.shouldSave()) {
            this.save(monitor, accessorKey);
        } else {
            this.handleSaveIfNecessaryDidNotSave(monitor);
        }
    }

    public void saveIfNecessaryWithPrompt(IOperationHandler operationHandler, Object accessorKey) {
        this.saveIfNecessaryWithPrompt(null, operationHandler, accessorKey);
    }

    public void saveIfNecessaryWithPrompt(IOperationHandler operationHandler, boolean wasDirty, Object accessorKey) {
        this.saveIfNecessaryWithPrompt(null, operationHandler, wasDirty, accessorKey);
    }

    public void saveIfNecessaryWithPrompt(IProgressMonitor monitor, IOperationHandler operationHandler, Object accessorKey) {
        this.saveIfNecessaryWithPrompt(monitor, operationHandler, true, accessorKey);
    }

    public void saveIfNecessaryWithPrompt(IProgressMonitor monitor, IOperationHandler operationHandler, boolean wasDirty, Object accessorKey) {
        if (this.shouldSave(operationHandler, wasDirty)) {
            this.save(monitor, accessorKey);
        } else {
            this.handleSaveIfNecessaryDidNotSave(monitor);
        }
    }

    protected void assertPermissionToSave(Object accessorKey) {
        if (this.registry != null) {
            this.registry.assertAccess(accessorKey);
        }
    }

    protected void runSaveOperation(IWorkspaceRunnable runnable, IProgressMonitor monitor) throws SaveFailedException {
        try {
            ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, monitor);
        }
        catch (CoreException e) {
            throw new SaveFailedException((Exception)((Object)e));
        }
    }

    protected boolean shouldSave(IOperationHandler operationHandler, boolean wasDirty) {
        return !wasDirty ? this.shouldSave() : this.shouldSave(operationHandler);
    }

    public boolean isInterrestedInResource(Resource aResource) {
        return this.isInterrestedInResourceUri(aResource.getURI());
    }

    protected boolean isInterrestedInResourceUri(URI resURI) {
        List uriStrings = this.getKnownResourceUris();
        int i = 0;
        while (i < uriStrings.size()) {
            URI uri = (URI)uriStrings.get(i);
            if (ExtendedEcoreUtil.endsWith((URI)resURI, (URI)uri)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void initializeKnownResourceUris() {
        this.knownResourceUris = new ArrayList();
        this.preloadResourceUris = new ArrayList();
        EditModelResource res2 = null;
        Collection editModelResources = EditModelRegistry.getInstance().getEditModelResources(this.getEditModelID());
        for (EditModelResource res2 : editModelResources) {
            this.addEditModelResource(res2);
        }
        Collection resourceExtensions = EditModelRegistry.getInstance().getEditModelExtensions(this.getEditModelID());
        if (this.knownResourceExtensions == null) {
            this.knownResourceExtensions = new ArrayList();
        }
        if (!resourceExtensions.isEmpty()) {
            this.knownResourceExtensions.addAll(resourceExtensions);
            Iterator it = resourceExtensions.iterator();
            ResourceSetWorkbenchEditSynchronizer sync = (ResourceSetWorkbenchEditSynchronizer)this.getEmfContext().getResourceSet().getSynchronizer();
            while (it.hasNext()) {
                sync.enableAutoload(it.next().toString());
            }
        }
    }

    private void addEditModelResource(EditModelResource res) {
        boolean enabled = false;
        try {
            if (res.isCore()) {
                enabled = true;
            } else {
                IEnablementIdentifier identifier = res.getEnablementIdentifier(this.getProject());
                this.registerInterest(identifier, res);
                enabled = identifier.isEnabled();
            }
        }
        catch (RuntimeException re) {
            EMFWorkbenchEditPlugin.logWarning(re);
        }
        if (enabled) {
            URI uri = res.getURI();
            this.knownResourceUris.add(uri);
            if (res.isAutoLoad()) {
                ResourceSetWorkbenchEditSynchronizer sync = (ResourceSetWorkbenchEditSynchronizer)this.getEmfContext().getResourceSet().getSynchronizer();
                sync.enableAutoload(uri);
                this.preloadResourceUris.add(uri);
            }
        }
    }

    private void registerInterest(IEnablementIdentifier identifier, EditModelResource res) {
        this.getEditModelResources(identifier).add(res);
    }

    private List getEditModelResources(IEnablementIdentifier identifier) {
        ArrayList tResources;
        if (this.resourceIdentifiers == null) {
            this.resourceIdentifiers = new HashMap();
        }
        if ((tResources = (ArrayList)this.resourceIdentifiers.get(identifier)) == null) {
            tResources = new ArrayList(3);
            this.resourceIdentifiers.put(identifier, tResources);
            identifier.addIdentifierListener((IEnablementIdentifierListener)this);
        }
        return tResources;
    }

    public List getKnownResourceUris() {
        if (this.knownResourceUris == null) {
            this.initializeKnownResourceUris();
        }
        return this.knownResourceUris;
    }

    public boolean isShared() {
        return this.registry.size() > 1;
    }

    @Override
    public void cacheNonResourceValidateState(List roNonResourceFiles) {
    }

    @Override
    public List getNonResourceFiles() {
        return null;
    }

    @Override
    public List getNonResourceInconsistentFiles() {
        return null;
    }

    public ResourceStateValidator getStateValidator() {
        if (this.stateValidator == null) {
            this.stateValidator = this.createStateValidator();
        }
        return this.stateValidator;
    }

    private ResourceStateValidator createStateValidator() {
        return new ResourceStateValidatorImpl(this);
    }

    @Override
    public void checkActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().checkActivation(presenter);
    }

    @Override
    public void lostActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().lostActivation(presenter);
    }

    @Override
    public IStatus validateState(ResourceStateValidatorPresenter presenter) throws CoreException {
        if (presenter == null) {
            return Status.OK_STATUS;
        }
        return this.getStateValidator().validateState(presenter);
    }

    @Override
    public boolean checkSave(ResourceStateValidatorPresenter presenter) throws CoreException {
        return this.getStateValidator().checkSave(presenter);
    }

    @Override
    public boolean checkReadOnly() {
        return this.getStateValidator().checkReadOnly();
    }

    public ResourceSet getResourceSet() {
        ProjectResourceSet resourceSet = null;
        if (this.getEmfContext() != null) {
            resourceSet = this.getEmfContext().getResourceSet();
        }
        return resourceSet;
    }

    protected void resourceIsLoadedChanged(Resource aResource, boolean oldValue, boolean newValue) {
        if (!this.isReverting && !this.disposing && this.hasListeners()) {
            int eventCode = newValue ? 6 : 7;
            EditModelEvent evt = new EditModelEvent(eventCode, this);
            evt.addResource(aResource);
            this.notifyListeners(evt);
        }
    }

    public Resource getResource(URI aUri) {
        Resource res = this.getAndLoadLocalResource(aUri);
        if (res == null) {
            res = WorkbenchResourceHelper.getOrCreateResource(aUri, this.getResourceSet());
        }
        if (res != null) {
            this.processResource(res);
        }
        return res;
    }

    protected void processResource(Resource aResource) {
        if (aResource != null && !this.getResources().contains(aResource)) {
            if (aResource instanceof ReferencedResource) {
                this.access((ReferencedResource)aResource);
                ((ReferencedResource)aResource).setFormat(1);
            } else if (aResource instanceof CompatibilityXMIResource) {
                ((CompatibilityXMIResource)aResource).setFormat(1);
            }
            this.addResource(aResource);
        }
    }

    protected void addResource(Resource aResource) {
        this.getResources().add(aResource);
        aResource.eAdapters().add((Object)this.resourceAdapter);
    }

    protected Resource getResource(List tResources, URI aUri) {
        int i = 0;
        while (i < tResources.size()) {
            Resource resource = (Resource)tResources.get(i);
            if (ExtendedEcoreUtil.endsWith((URI)resource.getURI(), (URI)aUri)) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    public Resource createResource(URI uri) {
        Resource resource = this.getExistingOrCreateResource(uri);
        this.processResource(resource);
        return resource;
    }

    public Resource getExistingOrCreateResource(URI uri) {
        Resource res = this.getAndLoadLocalResource(uri);
        if (res == null) {
            res = WorkbenchResourceHelperBase.getExistingOrCreateResource((URI)uri, (ResourceSet)this.getResourceSet());
        }
        return res;
    }

    protected Resource getAndLoadLocalResource(URI aUri) {
        Resource resource = this.getLocalResource(aUri);
        if (resource != null && !resource.isLoaded()) {
            try {
                resource.load(Collections.EMPTY_MAP);
            }
            catch (IOException iOException) {}
        }
        return resource;
    }

    protected Resource getLocalResource(URI aUri) {
        return this.getResource(this.getResources(), aUri);
    }

    protected boolean shouldAccessForRead(ReferencedResource aResource) {
        return this.isReadOnly() || this.accessAsReadForUnKnownURIs && !this.isInterrestedInResource((Resource)aResource);
    }

    public void resourceChanged(EditModelEvent anEvent) {
        int code = anEvent.getEventCode();
        switch (code) {
            case 3: {
                if (!this.isReverting && this.hasResourceReference(anEvent.getChangedResources())) {
                    this.removeResources(anEvent.getChangedResources());
                    break;
                }
                return;
            }
            case 4: {
                if (this.processResourcesIfInterrested(anEvent.getChangedResources())) break;
                return;
            }
        }
        if (this.hasListeners()) {
            anEvent.setEditModel(this);
            this.notifyListeners(anEvent);
        }
    }

    protected boolean hasResourceReference(Resource aResource) {
        if (aResource != null) {
            return this.getResources().contains(aResource);
        }
        return false;
    }

    protected boolean hasResourceReference(List tResources) {
        int i = 0;
        while (i < tResources.size()) {
            if (this.hasResourceReference((Resource)tResources.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void removeResources(List aList) {
        int i = 0;
        while (i < aList.size()) {
            Resource res = (Resource)aList.get(i);
            if (this.removeResource(res) && res instanceof ReferencedResource) {
                this.removedResource((ReferencedResource)res);
            }
            ++i;
        }
    }

    private final void removedResource(ReferencedResource referencedResource) {
        if (!this.isReadOnly() && referencedResource.wasReverted()) {
            this.isReverting = true;
            try {
                this.reverted(referencedResource);
            }
            finally {
                this.isReverting = false;
            }
        }
    }

    protected boolean removeResource(URI uri) {
        Resource res = this.getLocalResource(uri);
        return this.removeResource(res);
    }

    protected boolean removeResource(Resource aResource) {
        if (aResource != null) {
            aResource.eAdapters().remove((Object)this.resourceAdapter);
            return this.getResources().remove(aResource);
        }
        return false;
    }

    protected void reverted(ReferencedResource revertedResource) {
        this.revertAllResources();
    }

    protected void revertAllResources() {
        List someResources = this.getSortedResources();
        int i = 0;
        while (i < someResources.size()) {
            ((Resource)someResources.get(i)).unload();
            ++i;
        }
        this.getResources().removeAll(someResources);
        i = 0;
        while (i < someResources.size()) {
            ((Resource)someResources.get(i)).eAdapters().remove((Object)this.resourceAdapter);
            ++i;
        }
    }

    protected List getSortedResources() {
        List theResources = this.getResources();
        int size = theResources.size();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        Resource[] sorted = new Resource[size];
        int xmlInsertPos = size - 1;
        int xmiInsertPos = 0;
        Resource res = null;
        int i = 0;
        while (i < size) {
            res = (Resource)theResources.get(i);
            if (res instanceof TranslatorResource) {
                sorted[xmlInsertPos--] = res;
            } else {
                sorted[xmiInsertPos++] = res;
            }
            ++i;
        }
        return Arrays.asList(sorted);
    }

    protected boolean processResourcesIfInterrested(List aSomeResources) {
        ArrayList someResources = new ArrayList(aSomeResources);
        int size = someResources.size();
        boolean processed = false;
        int i = 0;
        while (i < size) {
            Resource res = (Resource)someResources.get(i);
            if (res != null && this.isInterrestedInResource(res)) {
                this.processResource(res);
                processed = true;
            }
            ++i;
        }
        return processed;
    }

    public EMFWorkbenchContext getEmfContext() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Edit Model already disposed");
        }
        if (this.emfContext == null) {
            throw new IllegalStateException("EMF context is null");
        }
        return this.emfContext;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public IProject getProject() {
        if (this.project == null) {
            throw new IllegalStateException("The value of the project attribute is null");
        }
        return this.project;
    }

    public void access(Object accessorKey) {
        this.registry.access(accessorKey);
    }

    protected void access(ReferencedResource aResource) {
        if (this.shouldAccessForRead(aResource)) {
            aResource.accessForRead();
        } else {
            aResource.accessForWrite();
        }
    }

    public void releaseAccess(Object accessorKey) {
        this.registry.release(accessorKey);
        if (!this.isDisposing()) {
            boolean shouldDispose = false;
            boolean bl = shouldDispose = this.registry.size() == 0;
            if (shouldDispose) {
                this.dispose();
            }
        }
    }

    protected void release(Resource aResource) {
        this.removeResource(aResource);
        if (aResource != null && aResource instanceof ReferencedResource) {
            this.release((ReferencedResource)aResource);
        }
    }

    protected void release(ReferencedResource aResource) {
        if (this.isReadOnly()) {
            aResource.releaseFromRead();
        } else {
            aResource.releaseFromWrite();
        }
    }

    protected void releaseResources() {
        List tResources = this.getSortedResources();
        int i = 0;
        while (i < tResources.size()) {
            Resource resource = (Resource)tResources.get(i);
            this.release(resource);
            ++i;
        }
    }

    public void deleteResource(Resource aResource) {
        if (aResource == null || this.resources == null || !this.getResources().contains(aResource)) {
            return;
        }
        this.getResourcesTargetedForTermination().add(aResource);
    }

    protected List getResourcesTargetedForTermination() {
        if (this.resourcesTargetedForTermination == null) {
            this.resourcesTargetedForTermination = new ArrayList(5);
        }
        return this.resourcesTargetedForTermination;
    }

    public void primDeleteResource(Resource aResource) {
        if (this.primFlushResource(aResource)) {
            try {
                this.getEmfContext().deleteResource(aResource);
            }
            catch (CoreException coreException) {}
            if (this.hasListeners()) {
                EditModelEvent event = new EditModelEvent(3, this);
                event.addResource(aResource);
                this.notifyListeners(event);
            }
        }
    }

    public void flushResource(Resource aResource) {
        if (this.primFlushResource(aResource) && this.hasListeners()) {
            EditModelEvent event = new EditModelEvent(3, this);
            event.addResource(aResource);
            this.notifyListeners(event);
        }
    }

    public Set getAffectedFiles() {
        HashSet<IFile> aSet = new HashSet<IFile>();
        List mofResources = this.getResources();
        int i = 0;
        while (i < mofResources.size()) {
            Resource aResource = (Resource)mofResources.get(i);
            IFile output = WorkbenchResourceHelper.getFile(aResource);
            if (output != null) {
                aSet.add(output);
            }
            ++i;
        }
        return aSet;
    }

    protected List resetKnownResourceUris() {
        this.initializeKnownResourceUris();
        return this.knownResourceUris;
    }

    @Override
    public List getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList(5);
        }
        return this.resources;
    }

    public String[] getResourceURIs() {
        return this.getResourceURIs(false);
    }

    public String[] getResourceURIs(boolean onlyDirty) {
        List list = this.getResources();
        int dirtyCount = 0;
        String[] uris = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            Resource res = (Resource)list.get(i);
            if (!onlyDirty) {
                uris[i] = res.getURI().toString();
            } else if (res.isModified()) {
                uris[i] = res.getURI().toString();
                ++dirtyCount;
            }
            ++i;
        }
        if (onlyDirty && dirtyCount > 0) {
            String[] dirty = new String[dirtyCount];
            int j = 0;
            int i2 = 0;
            while (i2 < uris.length) {
                if (uris[i2] != null) {
                    dirty[j] = uris[i2];
                    ++j;
                }
                ++i2;
            }
            uris = dirty;
        }
        return uris;
    }

    public static EObject getRoot(Resource aResource) {
        EList extent = aResource.getContents();
        if (extent.size() < 1) {
            return null;
        }
        return (EObject)extent.get(0);
    }

    protected void handleSaveFailed(Resource aResource, Exception e) {
        aResource.setModified(true);
        if (this.isFailedWriteFileFailure(e) && this.shouldSaveReadOnly(aResource)) {
            this.saveResource(aResource);
        } else {
            this.primHandleSaveFailed(aResource, e);
        }
    }

    protected boolean isAnyResourceDirty() {
        List list = this.getResources();
        int i = 0;
        while (i < list.size()) {
            if (((Resource)list.get(i)).isModified()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isDirty() {
        return this.isAnyResourceDirty();
    }

    protected boolean isFailedWriteFileFailure(Exception ex) {
        return SaveHandlerHeadless.isFailedWriteFileFailure((Exception)ex);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected boolean isReadOnlyFailure(Exception ex) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasReadOnlyResource() {
        try {
            List list = this.getResources();
            int size = list.size();
            Resource res = null;
            int i = 0;
            while (true) {
                if (i >= size) {
                    return false;
                }
                res = (Resource)list.get(i);
                IFile file = WorkbenchResourceHelper.getFile(res);
                if (file != null && file.isReadOnly()) {
                    return true;
                }
                ++i;
            }
        }
        catch (NullPointerException e) {
            System.out.println(e);
        }
        return false;
    }

    public Resource makeResource(String aUri) {
        return this.createResource(URI.createURI((String)aUri));
    }

    public boolean needsToSave() {
        return !this.isShared() && this.isDirty();
    }

    protected boolean primFlushResource(Resource aResource) {
        if (aResource != null && this.hasResourceReference(aResource)) {
            this.removeResource(aResource);
            this.removeResourceSetResource(aResource);
            return true;
        }
        return false;
    }

    protected void primHandleSaveFailed(Resource aResource, Exception e) {
        EMFWorkbenchEditPlugin.logError(e);
        Exception nested = null;
        nested = e instanceof IWFTWrappedException ? ((IWFTWrappedException)e).getNestedException() : e;
        throw new SaveFailedException(EMFWorkbenchResourceHandler.getString((String)"An_error_occurred_while_sa_ERROR_"), nested);
    }

    protected boolean promptToSave(IOperationHandler operationHandler) {
        if (operationHandler == null) {
            return false;
        }
        return operationHandler.canContinue(EMFWorkbenchResourceHandler.getString((String)"The_following_resources_ne_UI_"), this.getResourceURIs(true));
    }

    public void primSave(IProgressMonitor monitor) {
        if (this.isReadOnly()) {
            return;
        }
        this.deleteResourcesIfNecessary();
        if (this.getResources().isEmpty()) {
            return;
        }
        List localResources = this.getSortedResources();
        int i = 0;
        while (i < localResources.size()) {
            Resource resource = (Resource)localResources.get(i);
            this.saveResource(resource);
            ++i;
        }
        this.getCommandStack().saveIsDone();
        if (this.hasListeners()) {
            EditModelEvent event = new EditModelEvent(1, this);
            this.notifyListeners(event);
        }
    }

    protected void deleteResourcesIfNecessary() {
        if (this.resourcesTargetedForTermination == null || this.resourcesTargetedForTermination.size() == 0) {
            return;
        }
        Resource deadres = null;
        int i = 0;
        while (i < this.getResourcesTargetedForTermination().size()) {
            deadres = (Resource)this.getResourcesTargetedForTermination().get(i);
            this.primDeleteResource(deadres);
            this.getResources().remove(deadres);
            this.getResourcesTargetedForTermination().remove(deadres);
            ++i;
        }
    }

    protected void primSaveResource(Resource aResource) throws Exception {
        if (aResource.isModified()) {
            aResource.save(Collections.EMPTY_MAP);
        }
    }

    protected void processLoadedResources() {
        EList loaded = this.getResourceSet().getResources();
        if (!loaded.isEmpty()) {
            this.processResourcesIfInterrested((List)loaded);
        }
    }

    private void processPreloadResources() {
        int i = 0;
        while (i < this.preloadResourceUris.size()) {
            URI uri = (URI)this.preloadResourceUris.get(i);
            this.getResource(uri);
            ++i;
        }
    }

    protected boolean removeResourceSetResource(Resource aResource) {
        aResource.eSetDeliver(false);
        aResource.unload();
        aResource.eSetDeliver(true);
        return this.getResourceSet().getResources().remove((Object)aResource);
    }

    protected void saveResource(Resource resource) {
        try {
            this.primSaveResource(resource);
        }
        catch (Exception e) {
            this.handleSaveFailed(resource, e);
        }
    }

    protected boolean shouldSave() {
        return !this.isReadOnly() && !this.isShared();
    }

    protected boolean shouldSave(IOperationHandler operationHandler) {
        return this.shouldSave() || this.promptToSave(operationHandler);
    }

    protected boolean shouldSaveReadOnly(Resource aResource) {
        IFile aFile = WorkbenchResourceHelper.getFile(aResource);
        if (aFile == null || !aFile.isReadOnly()) {
            return false;
        }
        return this.getSaveHandler().shouldContinueAndMakeFileEditable(aFile);
    }

    public void forceLoadKnownResources() {
        List uris = this.getKnownResourceUris();
        URI uri = null;
        int i = 0;
        while (i < uris.size()) {
            uri = (URI)uris.get(i);
            this.getResource(uri);
            ++i;
        }
    }

    public void manageExtensionResourceURI(String aRelativeURI) {
        URI uri;
        if (aRelativeURI != null && aRelativeURI.length() > 0 && !this.isInterrestedInResourceUri(uri = URI.createURI((String)aRelativeURI))) {
            this.getKnownResourceUris().add(uri);
            try {
                Resource res = this.getEmfContext().getResource(uri);
                if (res != null) {
                    this.processResource(res);
                }
            }
            catch (Exception exception) {}
        }
    }

    public Resource getOrCreateResource(URI uri) {
        return this.getResource(uri);
    }

    public boolean isAccessAsReadForUnKnownURIs() {
        return this.accessAsReadForUnKnownURIs;
    }

    public void setAccessAsReadForUnKnownURIs(boolean b) {
        this.accessAsReadForUnKnownURIs = b;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append(": ");
        if (this.isReadOnly()) {
            buffer.append(" R = ");
        } else {
            buffer.append(" W = ");
        }
        buffer.append(this.getRegistry().size());
        buffer.append("[ID: \"");
        buffer.append(this.getEditModelID());
        buffer.append("\" Known Resources: [");
        List uris = this.getKnownResourceUris();
        if (uris != null) {
            int i = 0;
            i = 0;
            while (i < uris.size() - 1) {
                buffer.append(uris.get(i) + ", ");
                ++i;
            }
            buffer.append(uris.get(i));
            buffer.append("]");
        } else {
            buffer.append("none");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public Reference getReference() {
        if (this.reference == null) {
            this.reference = new Reference();
        }
        return this.reference;
    }

    protected ClientAccessRegistry getRegistry() {
        return this.registry;
    }

    public EObject getPrimaryRootObject() {
        Resource res = this.getPrimaryResource();
        if (res == null || res.getContents().isEmpty()) {
            return null;
        }
        return (EObject)res.getContents().get(0);
    }

    public Resource getPrimaryResource() {
        if (this.knownResourceUris == null) {
            this.getKnownResourceUris();
        }
        if (this.knownResourceUris == null || this.knownResourceUris.isEmpty()) {
            return null;
        }
        URI uri = (URI)this.knownResourceUris.get(0);
        return this.getResource(uri);
    }

    public void identifierChanged(EnablementIdentifierEvent evt) {
        if (evt.hasEnabledChanged()) {
            EditModelEvent editModelEvent = new EditModelEvent(8, this);
            this.notifyListeners(editModelEvent);
            IEnablementIdentifier id = evt.getIdentifier();
            if (id.isEnabled()) {
                this.addKnownResources(id);
            } else {
                this.removeKnownResources(id);
            }
            editModelEvent = new EditModelEvent(9, this);
            this.notifyListeners(editModelEvent);
        }
    }

    private void removeKnownResources(IEnablementIdentifier id) {
        List editModelResources = this.getEditModelResources(id);
        EditModelResource editModelResource = null;
        ResourceSetWorkbenchEditSynchronizer sync = (ResourceSetWorkbenchEditSynchronizer)this.getResourceSetSynchronizer();
        int i = 0;
        while (i < editModelResources.size()) {
            editModelResource = (EditModelResource)editModelResources.get(i);
            if (editModelResource.isAutoLoad() && sync != null) {
                sync.disableAutoload(editModelResource.getURI());
                this.preloadResourceUris.remove(editModelResource.getURI());
            }
            this.knownResourceUris.remove(editModelResource.getURI());
            this.removeResource(editModelResource.getURI());
            ++i;
        }
    }

    private void addKnownResources(IEnablementIdentifier id) {
        List editModelResources = this.getEditModelResources(id);
        EditModelResource editModelResource = null;
        ResourceSetWorkbenchEditSynchronizer sync = (ResourceSetWorkbenchEditSynchronizer)this.getResourceSetSynchronizer();
        int i = 0;
        while (i < editModelResources.size()) {
            editModelResource = (EditModelResource)editModelResources.get(i);
            if (editModelResource.isAutoLoad() && sync != null) {
                sync.enableAutoload(editModelResource.getURI());
                this.preloadResourceUris.add(editModelResource.getURI());
                this.getResource(editModelResource.getURI());
            }
            this.knownResourceUris.add(editModelResource.getURI());
            ++i;
        }
    }

    public Map getParams() {
        return this.params;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public class NotifyRunner
    implements ISafeRunnable {
        private final EditModelEvent event;
        private EditModelListener listener;

        public NotifyRunner(EditModelEvent event) {
            Assert.isNotNull((Object)event);
            this.event = event;
        }

        public void setListener(EditModelListener listener) {
            this.listener = listener;
        }

        public void handleException(Throwable exception) {
            EMFWorkbenchEditPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.common.emfworkbench.integration", 0, exception.getMessage(), exception));
        }

        public void run() throws Exception {
            if (this.listener != null) {
                this.listener.editModelChanged(this.event);
            }
        }
    }

    public class Reference {
        protected String tostring = null;

        public String toString() {
            if (this.tostring == null) {
                StringBuffer result = new StringBuffer("EditModel.Reference [");
                result.append("{");
                result.append(EditModel.this.getEditModelID());
                result.append("} {");
                result.append(EditModel.this.getProject().getName());
                result.append("}]");
                this.tostring = result.toString();
            }
            return this.tostring;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    protected class ResourceAdapter
    extends AdapterImpl {
        protected ResourceAdapter() {
        }

        public void notifyChanged(Notification notification) {
            if (!EditModel.this.isDisposing() && notification.getEventType() == 1 && notification.getFeatureID(null) == 4) {
                EditModel.this.resourceIsLoadedChanged((Resource)notification.getNotifier(), notification.getOldBooleanValue(), notification.getNewBooleanValue());
            }
        }
    }
}

