/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.common.internal.emf.resource.DefaultTranslatorFactory;
import org.eclipse.wst.common.internal.emf.resource.GenericTranslator;
import org.eclipse.wst.common.internal.emf.resource.ReadAheadHelper;
import org.eclipse.wst.common.internal.emf.resource.TranslatorPath;
import org.eclipse.wst.common.internal.emf.resource.VariableTranslatorFactory;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;
import org.eclipse.wst.common.internal.emf.utilities.FeatureValueConverter;
import org.w3c.dom.Node;

public class Translator {
    public static final int NO_STYLE = 0;
    public static final int DOM_ATTRIBUTE = 1;
    public static final int EMPTY_TAG = 2;
    public static final int CDATA_CONTENT = 4;
    public static final int END_TAG_NO_INDENT = 8;
    public static final int BOOLEAN_LOWERCASE = 16;
    public static final int ENUM_FEATURE_WITH_HYPHENS = 32;
    protected static final int OBJECT_MAP = 64;
    protected static final int BOOLEAN_FEATURE = 128;
    protected static final int SHARED_REFERENCE = 256;
    public static final int EMPTY_CONTENT_IS_SIGNIFICANT = 512;
    protected static final int COMMENT_FEATURE = 1024;
    public static final int UNSET_IF_NULL = 2048;
    public static final int STRING_RESULT_OK = 4096;
    public static final int IGNORE_DEFAULT_ATTRIBUTE_VALUE = 8192;
    protected String[] fDOMNames;
    protected String fDOMPath = "";
    protected Map readAheadNames;
    protected int fStyle = 0;
    protected EStructuralFeature feature;
    protected TranslatorPath[] fTranslatorPaths;
    protected EClass emfClass;
    protected String fNameSpace = "";
    protected String domNameAndPath = null;
    protected Boolean isDependencyParent;
    protected EStructuralFeature dependencyFeature;
    protected static EcorePackage ECORE_PACKAGE = EcorePackage.eINSTANCE;
    public static final String TEXT_ATTRIBUTE_VALUE = "$TEXT_ATTRIBUTE_VALUE";
    public static final EStructuralFeature CONTAINER_FEATURE = new ContainerFeature();
    public static final EStructuralFeature ROOT_FEATURE = new RootFeature();

    public Translator findChild(String tagName, Object target, int versionID) {
        VariableTranslatorFactory factory;
        Translator result = null;
        Translator[] maps = this.getChildren(target, versionID);
        if (maps != null) {
            int i = 0;
            while (i < maps.length) {
                Translator map = maps[i];
                if (map.isMapFor(tagName)) {
                    result = map;
                    break;
                }
                ++i;
            }
        }
        if (result == null && (factory = this.getVariableTranslatorFactory()) != null && factory.accepts(tagName)) {
            result = factory.create(tagName);
        }
        return result;
    }

    public static Object[] concat(Object[] array1, Object[] array2) {
        Object[] result = (Object[])Array.newInstance(array1.getClass().getComponentType(), array1.length + array2.length);
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static Object[] concat(Object[] array1, Object object2) {
        Object[] newArray = new Object[]{object2};
        return Translator.concat(array1, newArray);
    }

    public static Translator createParentAndTextAttributeTranslator(String domName, EStructuralFeature parentFeature, EStructuralFeature childFeature) {
        GenericTranslator parent = new GenericTranslator(domName, parentFeature, 8);
        parent.setChildren(new Translator[]{new Translator(TEXT_ATTRIBUTE_VALUE, childFeature)});
        return parent;
    }

    public Translator(String domNameAndPath, EClass eClass) {
        this.initializeDOMNameAndPath(domNameAndPath);
        this.setEMFClass(eClass);
    }

    public Translator(String domNameAndPath, EStructuralFeature aFeature) {
        this.initializeDOMNameAndPath(domNameAndPath);
        this.setFeature(aFeature);
    }

    public Translator(String domNameAndPath, EStructuralFeature aFeature, EClass eClass) {
        this(domNameAndPath, aFeature);
        this.setEMFClass(eClass);
    }

    public Translator(String domNameAndPath, EStructuralFeature aFeature, TranslatorPath path) {
        this(domNameAndPath, aFeature, new TranslatorPath[]{path});
    }

    public Translator(String domNameAndPath, EStructuralFeature aFeature, TranslatorPath[] paths) {
        this.initializeDOMNameAndPath(domNameAndPath);
        this.fTranslatorPaths = paths;
        this.setFeature(aFeature);
    }

    public Translator(String domNameAndPath, EStructuralFeature aFeature, int style) {
        this.initializeDOMNameAndPath(domNameAndPath);
        this.fStyle = style;
        this.setFeature(aFeature);
    }

    public static EcorePackage getEcorePackage() {
        return EcorePackage.eINSTANCE;
    }

    public String getDOMName(Object value) {
        return this.fDOMNames[0];
    }

    public String[] getDOMNames() {
        return this.fDOMNames;
    }

    public String getDOMPath() {
        return this.fDOMPath;
    }

    public boolean hasDOMPath() {
        return this.fDOMPath != null && this.fDOMPath.length() != 0;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    protected void initializeDOMNameAndPath(String domNameAndPathArg) {
        if (domNameAndPathArg == null) {
            return;
        }
        int inx = domNameAndPathArg.lastIndexOf(47);
        if (inx != -1) {
            this.fDOMNames = this.parseDOMNames(domNameAndPathArg.substring(inx + 1));
            this.fDOMPath = domNameAndPathArg.substring(0, inx);
        } else {
            this.fDOMNames = this.parseDOMNames(domNameAndPathArg);
            this.fDOMPath = "";
        }
        this.domNameAndPath = domNameAndPathArg;
    }

    public boolean isCDATAContent() {
        return (this.fStyle & 4) != 0;
    }

    public boolean isDOMAttribute() {
        return (this.fStyle & 1) != 0;
    }

    public boolean isEmptyTag() {
        return (this.fStyle & 2) != 0;
    }

    public boolean isBooleanUppercase() {
        return (this.fStyle & 0x80) != 0 && (this.fStyle & 0x10) == 0;
    }

    public boolean isBooleanFeature() {
        return (this.fStyle & 0x80) != 0;
    }

    public boolean shouldIndentEndTag() {
        return (this.fStyle & 8) == 0;
    }

    public boolean shouldIndentEndTag(Node node) {
        return this.shouldIndentEndTag();
    }

    public boolean isEmptyContentSignificant() {
        return (this.fStyle & 2) != 0 || (this.fStyle & 0x200) != 0;
    }

    public boolean isObjectMap() {
        return (this.fStyle & 0x40) != 0;
    }

    public boolean isShared() {
        return (this.fStyle & 0x100) != 0;
    }

    public boolean isEnumWithHyphens() {
        return (this.fStyle & 0x20) != 0;
    }

    public boolean isIgnoreDefaultAttributeValue() {
        return (this.fStyle & 0x2000) != 0;
    }

    public boolean isDOMTextValue() {
        return this.fDOMNames[0] == TEXT_ATTRIBUTE_VALUE;
    }

    public boolean isIDMap() {
        return false;
    }

    public boolean isLinkMap() {
        return this.fTranslatorPaths != null;
    }

    public boolean isTargetLinkMap() {
        return this.isLinkMap() && !this.isObjectMap();
    }

    public boolean isMapFor(String domName) {
        if (domName.equals(this.getDOMPath())) {
            return true;
        }
        int i = 0;
        while (i < this.fDOMNames.length) {
            if (domName.equals(this.fDOMNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isMapFor(Object aFeature, Object oldValue, Object newValue) {
        return this.feature == aFeature;
    }

    public boolean isMultiValued() {
        if (this.feature != null) {
            return this.feature.isMany();
        }
        return false;
    }

    protected String[] parseDOMNames(String domNamesString) {
        int startInx = 0;
        int inx = domNamesString.indexOf(44);
        ArrayList<String> results = new ArrayList<String>(1);
        while (inx != -1) {
            results.add(domNamesString.substring(startInx, inx));
            startInx = inx + 1;
            inx = domNamesString.indexOf(44, startInx);
        }
        if (startInx == 0) {
            results.add(domNamesString);
        } else {
            results.add(domNamesString.substring(startInx));
        }
        return results.toArray(new String[results.size()]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String cn = this.getClass().getName();
        int i = cn.lastIndexOf(46);
        cn = cn.substring(++i, cn.length());
        sb.append(cn);
        sb.append('(');
        sb.append(this.fDOMNames[0]);
        int j = 1;
        while (j < this.fDOMNames.length) {
            sb.append('|');
            sb.append(this.fDOMNames[j]);
            ++j;
        }
        sb.append(',');
        sb.append(this.hashCode());
        sb.append(')');
        return sb.toString();
    }

    public TranslatorPath[] getTranslatorPaths() {
        return this.fTranslatorPaths;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Translator)) {
            return false;
        }
        Translator mapInfo = (Translator)object;
        return this.fDOMNames.equals(mapInfo.getDOMNames()) && (this.feature == null && mapInfo.getFeature() == null || this.feature.equals(mapInfo.getFeature()));
    }

    public int hashCode() {
        return super.hashCode() + this.fDOMNames.hashCode();
    }

    public boolean isManagedByParent() {
        return this.getChildren(null, -1) == null;
    }

    public EObject createEMFObject(String nodeName, String readAheadName) {
        if (this.emfClass == null) {
            if (this.feature == null) {
                return null;
            }
            if (this.isObjectMap()) {
                return Translator.createEMFObject(this.feature);
            }
        }
        return Translator.createEMFObject(this.emfClass);
    }

    public static EObject createEMFObject(EStructuralFeature aFeature) {
        if (aFeature == null) {
            return null;
        }
        return Translator.createEMFObject(((EReference)aFeature).getEReferenceType());
    }

    public static EObject createEMFObject(EClass anEClass) {
        if (anEClass == null) {
            return null;
        }
        return anEClass.getEPackage().getEFactoryInstance().create(anEClass);
    }

    public void setTextValueIfNecessary(String textValue, Notifier owner, int versionId) {
        Translator textTranslator = this.findChild(TEXT_ATTRIBUTE_VALUE, owner, versionId);
        if (textTranslator != null) {
            Object objectValue = textTranslator.convertStringToValue(textValue, (EObject)owner);
            textTranslator.setMOFValue(owner, objectValue);
        }
    }

    public boolean featureExists(EObject emfObject) {
        if (this.feature == null || emfObject == null) {
            return false;
        }
        return emfObject.eClass().getEStructuralFeature(this.feature.getName()) != null;
    }

    public String extractStringValue(EObject emfObject) {
        if (this.isEmptyTag() && this.feature == null) {
            return "";
        }
        return null;
    }

    public Object convertStringToValue(String nodeName, String readAheadName, String value, Notifier owner) {
        Object result = null;
        try {
            result = !this.isManagedByParent() ? this.createEMFObject(nodeName, readAheadName) : this.convertStringToValue(value, (EObject)owner);
        }
        catch (ClassCastException classCastException) {}
        return result;
    }

    public Object convertStringToValue(String strValue, EObject owner) {
        Object value;
        if (this.feature == null) {
            return strValue;
        }
        String innerStrValue = strValue;
        if (innerStrValue != null) {
            if (this.isEnumWithHyphens()) {
                innerStrValue = innerStrValue.replace('-', '_');
            }
            if (!this.isCDATAContent()) {
                innerStrValue = innerStrValue.trim();
            }
        }
        if ((value = FeatureValueConverter.DEFAULT.convertValue(innerStrValue, this.feature)) == null) {
            if (this.isEmptyTag() && !this.isDOMAttribute() && !this.isDOMTextValue() && this.isBooleanFeature()) {
                return Boolean.TRUE;
            }
            EClassifier convertToType = this.feature.getEType();
            if (convertToType == null) {
                value = innerStrValue;
            } else if (convertToType.equals(Translator.getEcorePackage().getEString())) {
                value = "";
            }
        }
        return value;
    }

    public String convertValueToString(Object value, EObject owner) {
        if (this.isEmptyTag() || value == null) {
            return null;
        }
        if (this.isEnumWithHyphens()) {
            return value.toString().replace('_', '-');
        }
        if (this.isBooleanUppercase()) {
            return (Boolean)value != false ? "True" : "False";
        }
        return value.toString();
    }

    public Translator[] getVariableChildren(Notifier target, int version) {
        List variableTranslators;
        Translator[] results = null;
        VariableTranslatorFactory factory = this.getVariableTranslatorFactory();
        if (factory != null && (variableTranslators = factory.create(target)) != null && variableTranslators.size() > 0) {
            Object[] vtoa = variableTranslators.toArray();
            results = new Translator[vtoa.length];
            int i = 0;
            while (i < results.length) {
                results[i] = (Translator)vtoa[i];
                ++i;
            }
        }
        if (results == null) {
            results = new Translator[]{};
        }
        return results;
    }

    public Translator[] getChildren(Object target, int versionID) {
        return this.getChildren();
    }

    protected Translator[] getChildren() {
        return null;
    }

    public List getMOFChildren(EObject mofObject) {
        if (this.feature == null) {
            return Collections.EMPTY_LIST;
        }
        Object value = this.getMOFValue(mofObject);
        List<Object> result = Collections.EMPTY_LIST;
        if (this.isMultiValued()) {
            result = (List)value;
        } else if (value != null) {
            result = Collections.singletonList(value);
        }
        return result;
    }

    public Object getMOFValue(EObject mofObject) {
        if (this.feature == null) {
            return null;
        }
        return mofObject.eGet(this.feature);
    }

    public void setMOFValue(Notifier owner, Object value, int newIndex) {
        if (this.feature != null) {
            if ((this.fStyle & 0x800) != 0 && value == null) {
                ExtendedEcoreUtil.eUnsetOrRemove((EObject)owner, this.feature, value);
            } else {
                ExtendedEcoreUtil.eSetOrAdd((EObject)owner, this.feature, value, newIndex);
            }
        }
    }

    public void setMOFValue(Notifier owner, Object value) {
        if (owner instanceof EObject) {
            this.setMOFValue((EObject)owner, value);
        } else if (owner instanceof Resource) {
            this.setMOFValue((Resource)owner, value);
        }
    }

    public void setMOFValue(EObject emfObject, Object value) {
        this.setMOFValue((Notifier)emfObject, value, -1);
    }

    public void setMOFValue(Resource res, Object value) {
        if (res != null && value != null) {
            res.getContents().add((Object)((EObject)value));
        }
    }

    public void removeMOFValue(Notifier owner, Object value) {
        if (this.feature != null) {
            ExtendedEcoreUtil.eUnsetOrRemove((EObject)owner, this.feature, value);
        }
    }

    public boolean isSetMOFValue(EObject emfObject) {
        boolean isSet;
        boolean bl = isSet = this.feature != null && emfObject.eIsSet(this.feature);
        if (this.isEmptyTag()) {
            return isSet && (Boolean)emfObject.eGet(this.feature) != false;
        }
        return isSet;
    }

    public void unSetMOFValue(EObject emfObject) {
        if (this.feature != null) {
            emfObject.eUnset(this.feature);
        }
    }

    public void clearList(EObject mofObject) {
        if (this.feature != null) {
            ((List)mofObject.eGet(this.feature)).clear();
        }
    }

    protected void setFeature(EStructuralFeature aFeature) {
        this.feature = aFeature;
        if (this.feature == null) {
            return;
        }
        if (aFeature instanceof EReference) {
            this.fStyle |= 0x40;
            if (!((EReference)aFeature).isContainment()) {
                this.fStyle |= 0x100;
            }
        }
        if (Translator.getEcorePackage().getEBoolean() == this.feature.getEType()) {
            this.fStyle |= 0x80;
        }
    }

    protected void setEMFClass(EClass anEClass) {
        this.emfClass = anEClass;
        if (anEClass != null) {
            this.fStyle |= 0x40;
        }
    }

    public boolean hasReadAheadNames() {
        return this.readAheadNames != null && !this.readAheadNames.isEmpty();
    }

    public ReadAheadHelper getReadAheadHelper(String parentName) {
        if (this.readAheadNames == null) {
            return null;
        }
        return (ReadAheadHelper)this.readAheadNames.get(parentName);
    }

    public void addReadAheadHelper(ReadAheadHelper helper) {
        if (this.readAheadNames == null) {
            this.readAheadNames = new HashMap(3);
        }
        this.readAheadNames.put(helper.getParentDOMName(), helper);
    }

    public boolean isDependencyChild() {
        return false;
    }

    public boolean isDependencyParent() {
        if (this.isDependencyParent == null) {
            this.isDependencyParent = Boolean.FALSE;
            Translator[] theChildren = this.getChildren(null, -1);
            if (theChildren != null) {
                int i = 0;
                while (i < theChildren.length) {
                    if (theChildren[i].isDependencyChild()) {
                        this.isDependencyParent = Boolean.TRUE;
                        this.dependencyFeature = theChildren[i].getDependencyFeature();
                    }
                    ++i;
                }
            }
        }
        return this.isDependencyParent;
    }

    public EStructuralFeature getDependencyFeature() {
        return this.dependencyFeature;
    }

    public EObject basicGetDependencyObject(EObject parent) {
        return (EObject)parent.eGet(this.dependencyFeature);
    }

    public boolean shouldRenderEmptyDOMPath(EObject eObject) {
        return this.isEmptyContentSignificant();
    }

    public void setMOFValueFromEmptyDOMPath(EObject eObject) {
    }

    public String getNameSpace() {
        return this.fNameSpace;
    }

    public void setNameSpace(String string) {
        this.fNameSpace = string;
    }

    public VariableTranslatorFactory getVariableTranslatorFactory() {
        if (this.isObjectMap()) {
            return DefaultTranslatorFactory.INSTANCE;
        }
        return null;
    }

    public boolean isEnumFeature() {
        return this.feature != null && ECORE_PACKAGE.getEEnum().isInstance((Object)this.feature.getEType());
    }

    public boolean isUnsettable() {
        return this.feature != null && this.feature.isUnsettable();
    }

    public boolean isDataType() {
        return this.feature != null && this.feature.getEType() instanceof EDataType;
    }

    public boolean isComment() {
        return (this.fStyle & 0x400) != 0;
    }

    protected static class ContainerFeature
    extends EStructuralFeatureImpl {
        protected ContainerFeature() {
        }
    }

    protected static class RootFeature
    extends EStructuralFeatureImpl {
        protected RootFeature() {
        }
    }
}

