/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.node;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.lsp4e.debug.launcher.DSPLaunchDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.Messages;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;

public class NodeRunDAPDebugDelegate
extends DSPLaunchDelegate {
    public static final String ID = "org.eclipse.wildwebdeveloper.launchConfiguration.nodeDebug";
    public static final String ARGUMENTS = "args";
    private static final String CWD = "cwd";
    private static final String ENV = "env";
    private static final String RUNTIME_EXECUTABLE = "runtimeExecutable";
    public static final String NODE_DEBUG_CMD = "/node_modules/node-debug2/out/src/nodeDebug.js";
    public static final String TYPESCRIPT_CONTENT_TYPE = "org.eclipse.wildwebdeveloper.ts";
    public static final String JAVACRIPT_CONTENT_TYPE = "org.eclipse.wildwebdeveloper.js";
    public static final String JAVACRIPT_DEBUGGABLE_PATTERNS = "__debuggablePatterns";
    public static final String JAVACRIPT_DEBUGGABLE_PATTERNS_DEFAULT = "[\"*.js\",\"*.es6\",\"*.jsx\",\"*.mjs\".\"*.cjs\"]";
    private static final String TS_CONFIG_NAME = "tsconfig.json";
    private static final String COMPILER_OPTIONS = "compilerOptions";
    private static final String SOURCE_MAP = "sourceMap";
    private static final String SOURCE_MAPS = "sourceMaps";
    private static final String MODULE = "module";
    private static final String MODULE_AMD = "amd";
    private static final String MODULE_SYSTEM = "system";
    private static final String OUT_DIR = "outDir";
    private static final String OUT_FILE = "outFile";
    private static final String ROOT_DIR = "rootDir";
    private static final Pattern BlockCommentPattern = Pattern.compile("(?<!//.*)/\\*(?:.|\\R)*?\\*/");
    private static final Pattern LineCommentPattern = Pattern.compile("\\s*//.*");
    private static final Pattern TrailingCommaPattern = Pattern.compile(",(\\s*)\\}");

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        File runtimeExecutable;
        String cwd;
        Map env;
        Object[] args;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("program", VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(configuration.getAttribute("program", "no program path defined")));
        String argsString = configuration.getAttribute(ARGUMENTS, "").trim();
        if (!argsString.isEmpty() && (args = Arrays.asList(argsString.split(" ")).stream().filter(s -> !s.trim().isEmpty()).map(s -> {
            try {
                return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(s);
            }
            catch (CoreException e) {
                Status errorStatus = new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)errorStatus);
                return s;
            }
        }).toArray()).length > 0) {
            param.put(ARGUMENTS, args);
        }
        if (!(env = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, Collections.emptyMap())).isEmpty()) {
            JsonObject envJson = new JsonObject();
            for (Map.Entry entry : env.entrySet()) {
                envJson.addProperty((String)entry.getKey(), VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution((String)entry.getValue()));
            }
            param.put(ENV, envJson);
        }
        if (!(cwd = configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", "").trim()).isEmpty()) {
            param.put(CWD, VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(cwd));
        }
        if ((runtimeExecutable = NodeJSManager.getNodeJsLocation()) != null) {
            param.put(RUNTIME_EXECUTABLE, runtimeExecutable.getAbsolutePath());
        }
        if (!this.configureAdditionalParameters(param)) {
            return;
        }
        try {
            URL fileURL = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource(NODE_DEBUG_CMD));
            File file = new File(fileURL.getPath());
            List<String> debugCmdArgs = Collections.singletonList(file.getAbsolutePath());
            DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder builder = new DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder(configuration, mode, launch, monitor);
            builder.setLaunchDebugAdapter(NodeJSManager.getNodeJsLocation().getAbsolutePath(), debugCmdArgs);
            builder.setMonitorDebugAdapter(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false));
            builder.setDspParameters(param);
            super.launch(builder);
        }
        catch (IOException e) {
            Status errorStatus = new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)errorStatus);
            Display.getDefault().asyncExec(() -> NodeRunDAPDebugDelegate.lambda$2(e, (IStatus)errorStatus));
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean configureAdditionalParameters(Map<String, Object> param) {
        block30: {
            block31: {
                program = (String)param.get("program");
                cwd = (String)param.get("cwd");
                if (program == null) {
                    return false;
                }
                programFile = new File(program);
                if (!Platform.getContentTypeManager().getContentType("org.eclipse.wildwebdeveloper.ts").isAssociatedWith(programFile.getName())) break block30;
                parentDirectory = cwd == null ? programFile.getParentFile() : new File(cwd);
                tsConfigFile = this.findTSConfigFile(parentDirectory);
                if (tsConfigFile != null && tsConfigFile.exists()) {
                    parentDirectory = tsConfigFile.getParentFile();
                }
                errorMessage = null;
                tsConfig = this.readJSonFile(tsConfigFile);
                v0 = co = tsConfig == null ? null : (HashMap<K, V>)tsConfig.get("compilerOptions");
                if (co == null) {
                    errorMessage = Messages.NodeDebug_TSConfirError_NoTsConfig;
                    co = new HashMap<K, V>();
                }
                param.putAll((Map<String, Object>)co);
                if (errorMessage != null) break block31;
                option = co.get("sourceMap");
                var14_12 = option;
                if (!(var14_12 instanceof Boolean)) ** GOTO lbl-1000
                var12_13 = (Boolean)var14_12;
                (Boolean)var14_12;
                if (b.booleanValue()) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = sourceMap = false;
                }
                if (!sourceMap) {
                    errorMessage = Messages.NodeDebug_TSConfirError_SourceMapIsNotEnabled;
                }
            }
            outDirOrFileIsSet = false;
            option = co.get("module");
            var15_16 = option;
            if (var15_16 instanceof String) {
                var13_17 = (String)var15_16;
                (String)var15_16;
                v2 = o.trim();
            } else {
                v2 = null;
            }
            module = v2;
            var19_18 = option = co.get("outDir");
            if (var19_18 instanceof String) {
                var17_19 = (String)var19_18;
                (String)var19_18;
                v3 = o.trim();
            } else {
                v3 = outDir = null;
            }
            if (outDir != null && outDir.length() > 0 && !".".equals(outDir) && !"./".equals(outDir)) {
                outDirFile = new File(parentDirectory, outDir);
                try {
                    outDir = outDirFile.getCanonicalPath();
                }
                catch (IOException e) {
                    outDir = outDirFile.getAbsolutePath();
                }
                param.put("outDir", outDir);
                outDirOrFileIsSet = true;
            }
            if ((var23_24 = (option = co.get("outFile"))) instanceof String) {
                e = (String)var23_24;
                (String)var23_24;
                v4 = o.trim();
            } else {
                v4 = outFile = null;
            }
            if (outFile != null && outFile.length() != 0) {
                outFileFile = new File(parentDirectory, outFile);
                try {
                    outFile = outFileFile.getCanonicalPath();
                }
                catch (IOException e) {
                    outFile = outFileFile.getAbsolutePath();
                }
                param.put("outFile", outFile);
                outDirOrFileIsSet = true;
                if (!"amd".equalsIgnoreCase(module) && !"system".equalsIgnoreCase(module)) {
                    errorMessage = Messages.NodeDebug_TSConfigError_OutDirNotSupportedModule;
                }
            }
            if ((var27_28 = (option = co.get("rootDir"))) instanceof String) {
                e = (String)var27_28;
                (String)var27_28;
                v5 = o.trim();
            } else {
                v5 = rootDir = null;
            }
            if (rootDir != null && rootDir.length() > 0 && !".".equals(outDir) && !"./".equals(outDir)) {
                rootDirFile = new File(parentDirectory, rootDir);
                try {
                    rootDir = rootDirFile.getCanonicalPath();
                }
                catch (IOException e) {
                    rootDir = rootDirFile.getAbsolutePath();
                }
                param.put("rootDir", rootDir);
            }
            if (!outDirOrFileIsSet && errorMessage == null) {
                errorMessage = Messages.NodeDebug_TSConfigError_OutDirIsNotSet;
            }
            if (errorMessage != null) {
                result = new int[1];
                dialogMessage = errorMessage;
                editTSConfig = tsConfigFile.exists() != false && tsConfigFile.isFile() != false ? Messages.NodeDebug_TSConfirError_OpenTSConfigInEditor : Messages.NodeDebug_TSConfirError_CreateAndOpenTSConfigInEditor;
                directory = parentDirectory;
                Display.getDefault().syncExec((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$3(java.lang.String java.lang.String int[] ), ()V)((String)dialogMessage, (String)editTSConfig, (int[])result));
                if (result[0] == 0) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IFile file = this.createNewEmptyFile(new File(directory, NodeRunDAPDebugDelegate.TS_CONFIG_NAME));
                            if (file != null) {
                                try {
                                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)new FileEditorInput(file), (String)"org.eclipse.ui.genericeditor.GenericEditor", (boolean)true);
                                }
                                catch (PartInitException e1) {
                                    Activator.getDefault().getLog().error(e1.getMessage(), (Throwable)e1);
                                }
                            }
                        }

                        private IFile createNewEmptyFile(File fsFile) {
                            IWorkspace ws = ResourcesPlugin.getWorkspace();
                            IWorkspaceRoot wr = ws.getRoot();
                            IFile file = wr.getFileForLocation((IPath)new Path(fsFile.getAbsolutePath()));
                            if (!file.exists() || !file.isAccessible()) {
                                IFile[] result = new IFile[1];
                                try {
                                    ws.run(monitor -> {
                                        iFileArray[0] = null;
                                        try {
                                            Throwable throwable = null;
                                            Object var5_7 = null;
                                            try (ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);){
                                                this.createContainers((IResource)file);
                                                file.create((InputStream)is, true, null);
                                                file.refreshLocal(0, null);
                                                iFileArray[0] = file;
                                            }
                                            catch (Throwable throwable2) {
                                                if (throwable == null) {
                                                    throwable = throwable2;
                                                } else if (throwable != throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                                throw throwable;
                                            }
                                        }
                                        catch (IOException | CoreException e) {
                                            Activator.getDefault().getLog().error(e.getMessage(), e);
                                        }
                                    }, null);
                                }
                                catch (CoreException e) {
                                    Activator.getDefault().getLog().error(e.getMessage(), (Throwable)e);
                                }
                                return result[0];
                            }
                            return file;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        void createContainers(IResource resource) throws CoreException {
                            IContainer container = resource.getParent();
                            IContainer iContainer = container;
                            if (iContainer instanceof IFolder) {
                                void parent;
                                IFolder iFolder = (IFolder)iContainer;
                                IFolder cfr_ignored_0 = (IFolder)iContainer;
                                if (!parent.exists()) {
                                    this.createContainers((IResource)parent);
                                    parent.create(false, true, null);
                                }
                            }
                        }
                    });
                } else if (result[0] == 1) {
                    return true;
                }
                return false;
            }
            return true;
        }
        if (Platform.getContentTypeManager().getContentType("org.eclipse.wildwebdeveloper.js").isAssociatedWith(programFile.getName())) {
            param.put("sourceMaps", false);
            param.put("__debuggablePatterns", "[\"*.js\",\"*.es6\",\"*.jsx\",\"*.mjs\".\"*.cjs\"]");
            return true;
        }
        return false;
    }

    private File findTSConfigFile(File parentDirectory) {
        do {
            File tsConfigFile;
            if (!(tsConfigFile = new File(parentDirectory, TS_CONFIG_NAME)).isFile()) continue;
            return tsConfigFile;
        } while ((parentDirectory = parentDirectory.getParentFile()) != null && parentDirectory.isDirectory());
        return null;
    }

    private String getSanitisedTSConfigForGson(String tsConfgContent) {
        tsConfgContent = BlockCommentPattern.matcher(tsConfgContent).replaceAll("");
        tsConfgContent = LineCommentPattern.matcher(tsConfgContent).replaceAll("");
        tsConfgContent = TrailingCommaPattern.matcher(tsConfgContent).replaceAll("$1}");
        return tsConfgContent;
    }

    public Map<String, Object> readJSonFile(File tsConfgFile) {
        if (tsConfgFile == null || !tsConfgFile.isFile()) {
            return Map.of();
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader in = new BufferedReader(new FileReader(tsConfgFile));){
                String inputLine;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine).append('\n');
                }
                Type type = new TypeToken<Map<String, Object>>(){}.getType();
                return (Map)new Gson().fromJson(this.getSanitisedTSConfigForGson(response.toString()), type);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return Map.of();
        }
    }

    private static /* synthetic */ void lambda$2(IOException iOException, IStatus iStatus) {
        int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug error", (String)iOException.getMessage(), (IStatus)iStatus);
    }

    private static /* synthetic */ void lambda$3(String string, String string2, int[] nArray) {
        MessageDialog dialog = new MessageDialog(DebugUIPlugin.getShell(), Messages.NodeDebug_TSConfirError_Title, null, string, 6, 2, new String[]{string2, Messages.NodeDebug_TSConfirError_StartDebuggingAsIs, Messages.NodeDebug_TSConfirError_Cancel});
        nArray[0] = dialog.open();
    }
}

