/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.java6.gef;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.AbsoluteBasedLayoutEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions.AbstractAlignmentActionsSupport;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions.ComplexAlignmentActionsSupport;
import org.eclipse.wb.internal.swing.gef.policy.layout.AbsoluteBasedLayoutEditPolicySwing;
import org.eclipse.wb.internal.swing.java6.gef.GroupSelectionEditPolicy;
import org.eclipse.wb.internal.swing.java6.model.GroupLayoutInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;

public final class GroupLayoutEditPolicy
extends AbsoluteBasedLayoutEditPolicySwing {
    private final GroupLayoutInfo m_layout;

    public GroupLayoutEditPolicy(GroupLayoutInfo layout) {
        super((LayoutInfo)layout);
        this.m_layout = layout;
        this.createPlacementsSupport(this.m_layout);
    }

    protected void decorateChild(EditPart child) {
        Object model = child.getModel();
        if (model instanceof ComponentInfo) {
            child.installEditPolicy((Object)"Selection Feedback", (EditPolicy)new GroupSelectionEditPolicy(this.m_layout));
        }
    }

    public Dimension getContainerSize() {
        return this.m_layout.getContainer().getModelBounds().getSize();
    }

    public Point getClientAreaOffset() {
        return new Point(0, 0);
    }

    protected void eraseSelectionFeedbacks() {
        super.eraseSelectionFeedbacks();
        for (EditPart child : this.getHost().getChildren()) {
            if (!(child.getModel() instanceof ComponentInfo)) continue;
            GroupSelectionEditPolicy editPolicy = (GroupSelectionEditPolicy)child.getEditPolicy((Object)"Selection Feedback");
            editPolicy.hideSelection();
        }
    }

    protected void showSelectionFeedbacks() {
        super.showSelectionFeedbacks();
        for (EditPart child : this.getHost().getChildren()) {
            if (!(child.getModel() instanceof ComponentInfo) || child.getSelected() == 0) continue;
            GroupSelectionEditPolicy editPolicy = (GroupSelectionEditPolicy)child.getEditPolicy((Object)"Selection Feedback");
            editPolicy.showSelection();
        }
    }

    protected Command getCreateCommand(final CreateRequest request) {
        return new EditCommand((ObjectInfo)this.m_layout){

            protected void executeEdit() throws Exception {
                ComponentInfo component = (ComponentInfo)request.getNewObject();
                GroupLayoutEditPolicy.this.m_layout.command_CREATE(component, null);
                GroupLayoutEditPolicy.this.placementsSupport.commitAdd();
            }
        };
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        return new EditCommand((ObjectInfo)this.m_layout){

            protected void executeEdit() throws Exception {
                GroupLayoutEditPolicy.this.placementsSupport.commit();
            }
        };
    }

    protected Command getAddCommand(ChangeBoundsRequest request) {
        final List editParts = request.getEditParts();
        return new EditCommand((ObjectInfo)this.m_layout){

            protected void executeEdit() throws Exception {
                for (EditPart editPart : editParts) {
                    ComponentInfo component = (ComponentInfo)editPart.getModel();
                    GroupLayoutEditPolicy.this.m_layout.command_MOVE(component, null);
                }
                GroupLayoutEditPolicy.this.placementsSupport.commitAdd();
            }
        };
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        return null;
    }

    protected void doPasteComponent(Point pasteLocation, AbsoluteBasedLayoutEditPolicy.PastedComponentInfo pastedWidget) throws Exception {
        ComponentInfo control = (ComponentInfo)pastedWidget.getComponent();
        this.m_layout.command_CREATE(control, null);
    }

    protected AbstractAlignmentActionsSupport<ComponentInfo> getAlignmentActionsSupport() {
        return new ComplexAlignmentActionsSupport<ComponentInfo>(this.placementsSupport){

            protected boolean isComponentInfo(ObjectInfo object) {
                return object instanceof ComponentInfo;
            }

            protected AbstractComponentInfo getLayoutContainer() {
                return GroupLayoutEditPolicy.this.m_layout.getContainer();
            }
        };
    }
}

