/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.platform;

import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class PluginUtilities {
    private PluginUtilities() {
    }

    public static String getId(Plugin plugin) {
        return plugin.getBundle().getSymbolicName();
    }

    public static String getName(Plugin plugin) {
        String label = null;
        Object bundleName = plugin.getBundle().getHeaders().get("Bundle-Name");
        if (bundleName instanceof String) {
            label = (String)bundleName;
        }
        if (label == null || label.trim().length() == 0) {
            return PluginUtilities.getId(plugin);
        }
        return label;
    }

    public static Version getVersion(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return null;
        }
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        return new Version(version);
    }

    public static Version getVersion(Plugin plugin) {
        if (plugin == null) {
            return null;
        }
        String version = (String)plugin.getBundle().getHeaders().get("Bundle-Version");
        return new Version(version);
    }

    public static String getVersionString(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return null;
        }
        return (String)bundle.getHeaders().get("Bundle-Version");
    }

    public static String getVersionString(Plugin plugin) {
        if (plugin == null) {
            return null;
        }
        return (String)plugin.getBundle().getHeaders().get("Bundle-Version");
    }

    public static URL getInstallUrl(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return null;
        }
        return bundle.getEntry("/");
    }

    public static URL getInstallUrl(Plugin plugin) {
        if (plugin == null) {
            return null;
        }
        return plugin.getBundle().getEntry("/");
    }

    public static URL getUrl(String pluginId, String relativePath) {
        if (pluginId == null || relativePath == null) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null) {
            return bundle.getEntry(relativePath);
        }
        return null;
    }

    public static URL getUrl(Plugin plugin, String relativePath) {
        if (plugin == null || relativePath == null) {
            return null;
        }
        return plugin.getBundle().getEntry(relativePath);
    }
}

