/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.editor.color;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.AbstractColorDialog;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.AbstractColorsComposite;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorInfo;

public class CustomColorPickerComposite
extends AbstractColorsComposite {
    private Label colorLabelBlue;
    private Label colorLabelRed;
    private Label colorLabelGreen;
    private Label colorLabelHue;
    private Label colorLabelSaturation;
    private Label colorLabelbrightness;
    private Text colorTextBlue;
    private Text colorTextRed;
    private Text colorTextGreen;
    private Text colorTextHue;
    private Text colorTextSaturation;
    private Text colorTextbrightness;
    private Text previewText;
    private Composite previewImage;
    private Text previewTextBackgroundBlack;
    private Text previewTextBackgroundWhite;
    ColorSelector colorSelector;

    public CustomColorPickerComposite(Composite parent, int style, AbstractColorDialog colorDialog) {
        super(parent, style, colorDialog);
        this.setLayout((Layout)new GridLayout());
        this.createContent(this);
    }

    private void createContent(Composite parent) {
        Composite color = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(color);
        GridDataFactory.swtDefaults().applyTo((Control)color);
        Composite colorSelectorComp = new Composite(color, 0);
        GridLayoutFactory.swtDefaults().applyTo(colorSelectorComp);
        GridDataFactory.swtDefaults().applyTo((Control)colorSelectorComp);
        Label buttonLabel = new Label(colorSelectorComp, 0);
        buttonLabel.setText(ModelMessages.CustomColorPicker_btnSelectColor);
        this.colorSelector = new ColorSelector(colorSelectorComp);
        this.createInfoComposite(color);
        this.previewComposite(color);
        this.colorSelector.getButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomColorPickerComposite.this.colorSelector.getColorValue() == null) {
                    return;
                }
                RGB currentColor = CustomColorPickerComposite.this.colorSelector.getColorValue();
                CustomColorPickerComposite.this.m_colorDialog.setResultColor(new ColorInfo(currentColor.red, currentColor.green, currentColor.blue));
                CustomColorPickerComposite.this.colorSelector.setColorValue(currentColor);
                CustomColorPickerComposite.this.updatePreview(currentColor);
                CustomColorPickerComposite.this.colorTextRed.setText("" + currentColor.red);
                CustomColorPickerComposite.this.colorTextGreen.setText("" + currentColor.green);
                CustomColorPickerComposite.this.colorTextBlue.setText("" + currentColor.blue);
                CustomColorPickerComposite.this.colorTextHue.setText(String.format("%.2f", Float.valueOf(currentColor.getHSB()[0])));
                CustomColorPickerComposite.this.colorTextSaturation.setText(String.format("%.2f", Float.valueOf(currentColor.getHSB()[1])));
                CustomColorPickerComposite.this.colorTextbrightness.setText(String.format("%.2f", Float.valueOf(currentColor.getHSB()[2])));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void previewComposite(Composite parent) {
        Composite previewComposite = new Composite(parent, 2048);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(previewComposite);
        GridDataFactory.swtDefaults().applyTo((Control)previewComposite);
        Font mono = new Font((Device)parent.getDisplay(), "Monospaced", 15, 1);
        this.previewText = new Text(previewComposite, 8);
        this.previewText.setFont(mono);
        this.previewText.setText(ModelMessages.CustomColorPicker_previewTextExample);
        this.previewImage = new Composite(previewComposite, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(this.previewImage);
        GridDataFactory.swtDefaults().hint(106, 26).indent(0, 0).applyTo((Control)this.previewImage);
        this.previewTextBackgroundBlack = new Text(previewComposite, 8);
        this.previewTextBackgroundBlack.setFont(mono);
        this.previewTextBackgroundBlack.setForeground(parent.getDisplay().getSystemColor(2));
        this.previewTextBackgroundBlack.setText(ModelMessages.CustomColorPicker_previewTextExample);
        this.previewTextBackgroundWhite = new Text(previewComposite, 8);
        this.previewTextBackgroundWhite.setFont(mono);
        this.previewTextBackgroundWhite.setForeground(parent.getDisplay().getSystemColor(1));
        this.previewTextBackgroundWhite.setText(ModelMessages.CustomColorPicker_previewTextExample);
    }

    private void updatePreview(RGB rgb) {
        Color color = new Color((Device)Display.getCurrent(), rgb);
        this.previewText.setForeground(color);
        this.previewTextBackgroundBlack.setBackground(color);
        this.previewTextBackgroundWhite.setBackground(color);
        this.previewImage.setBackground(color);
    }

    public void updateColorBeforeOpen() {
        if (this.m_colorDialog.getColorInfo() == null) {
            this.m_colorDialog.setColorInfo(new ColorInfo(0, 0, 0));
        }
        this.updatePreview(this.m_colorDialog.getColorInfo().getRGB());
        this.colorSelector.setColorValue(this.m_colorDialog.getColorInfo().getRGB());
    }

    private void createInfoComposite(Composite parent) {
        Composite infoComposite = new Composite(parent, 2048);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(infoComposite);
        GridDataFactory.swtDefaults().applyTo((Control)infoComposite);
        Composite rgbComposite = new Composite(infoComposite, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(rgbComposite);
        GridDataFactory.swtDefaults().applyTo((Control)rgbComposite);
        Composite hsbComposite = new Composite(infoComposite, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(hsbComposite);
        GridDataFactory.swtDefaults().applyTo((Control)hsbComposite);
        this.colorLabelBlue = new Label(rgbComposite, 0);
        this.colorLabelBlue.setText(ModelMessages.CustomColorPicker_lblBlue);
        this.colorTextBlue = new Text(rgbComposite, 8);
        this.colorLabelRed = new Label(rgbComposite, 0);
        this.colorLabelRed.setText(ModelMessages.CustomColorPicker_lblRed);
        this.colorTextRed = new Text(rgbComposite, 8);
        this.colorLabelGreen = new Label(rgbComposite, 0);
        this.colorLabelGreen.setText(ModelMessages.CustomColorPicker_lblGreen);
        this.colorTextGreen = new Text(rgbComposite, 8);
        this.colorLabelHue = new Label(hsbComposite, 0);
        this.colorLabelHue.setText(ModelMessages.CustomColorPicker_lblHue);
        this.colorTextHue = new Text(hsbComposite, 8);
        this.colorLabelSaturation = new Label(hsbComposite, 0);
        this.colorLabelSaturation.setText(ModelMessages.CustomColorPicker_lblSaturation);
        this.colorTextSaturation = new Text(hsbComposite, 8);
        this.colorLabelbrightness = new Label(hsbComposite, 0);
        this.colorLabelbrightness.setText(ModelMessages.CustomColorPicker_lblBrightness);
        this.colorTextbrightness = new Text(hsbComposite, 8);
    }
}

