/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.AssociationUtils;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.variable.AbstractSimpleVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupportUtils;
import org.eclipse.wb.internal.core.model.variable.NamesManager;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class LazyVariableSupport
extends AbstractSimpleVariableSupport {
    public MethodDeclaration m_accessor;
    private static final String BASE = "variable.lazy.";
    public static final String[] V_MODIFIER_CODE = new String[]{"private ", "", "protected ", "public "};
    public static final String P_METHOD_MODIFIER = "variable.lazy.methodModifier";
    public static final int V_METHOD_MODIFIER_PRIVATE = 0;
    public static final int V_METHOD_MODIFIER_PACKAGE = 1;
    public static final int V_METHOD_MODIFIER_PROTECTED = 2;
    public static final int V_METHOD_MODIFIER_PUBLIC = 3;

    public LazyVariableSupport(JavaInfo javaInfo) {
        super(javaInfo);
    }

    public LazyVariableSupport(JavaInfo javaInfo, LazyVariableInformation lazyVariableInformation) {
        super(javaInfo, lazyVariableInformation.m_variable);
        this.m_accessor = lazyVariableInformation.m_accessor;
    }

    public String toString() {
        return "lazy: " + this.m_variable + " " + this.getAccessorSignature();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isJavaInfo(ASTNode node) {
        ASTNode aSTNode = node;
        if (aSTNode instanceof MethodInvocation) {
            void invocation;
            MethodInvocation methodInvocation = (MethodInvocation)aSTNode;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
            String signature = AstNodeUtils.getMethodSignature((MethodInvocation)invocation);
            if (this.getAccessorSignature().equals(signature)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValidStatementForChild(Statement statement) {
        return AstNodeUtils.getEnclosingMethod((ASTNode)statement) == this.m_accessor;
    }

    @Override
    public void setName(String newName) throws Exception {
        String actualMethodName = this.m_accessor.getName().getIdentifier();
        String expectedMethodName = LazyVariableSupportUtils.getExpectedMethodName(this.m_javaInfo, this.getName());
        if (expectedMethodName.equals(actualMethodName)) {
            String newMethodName = LazyVariableSupportUtils.getExpectedMethodName(this.m_javaInfo, newName);
            List<MethodInvocation> invocations = AstNodeUtils.getMethodInvocations(this.m_accessor);
            AstEditor editor = this.m_javaInfo.getEditor();
            editor.replaceMethodName(this.m_accessor, newMethodName);
            for (MethodInvocation invocation : invocations) {
                editor.replaceInvocationName(invocation, newMethodName);
            }
        }
        this.modifyName(newName);
    }

    @Override
    public boolean hasExpression(NodeTarget target) {
        return true;
    }

    @Override
    public String getReferenceExpression(NodeTarget target) throws Exception {
        if (this.isTargetInAccessor(target)) {
            return this.getName();
        }
        return this.getAccessorReferenceExpression();
    }

    public String getAccessorReferenceExpression() {
        return String.valueOf(this.m_accessor.getName().getIdentifier()) + "()";
    }

    private boolean isTargetInAccessor(NodeTarget target) {
        StatementTarget statementTarget = target.getStatementTarget();
        if (statementTarget != null) {
            return AstNodeUtils.contains((ASTNode)this.m_accessor, statementTarget.getNode());
        }
        return false;
    }

    @Override
    public boolean canConvertLocalToField() {
        return false;
    }

    @Override
    public void convertLocalToField() throws Exception {
        throw new IllegalStateException();
    }

    @Override
    public boolean canConvertFieldToLocal() {
        return false;
    }

    @Override
    public void convertFieldToLocal() throws Exception {
        throw new IllegalStateException();
    }

    @Override
    public void ensureInstanceReadyAt(StatementTarget target) throws Exception {
    }

    @Override
    public StatementTarget getAssociationTarget(StatementTarget target) throws Exception {
        return target;
    }

    @Override
    public String add_getVariableStatementSource(StatementTarget associationTarget) throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        boolean isStatic = this.isStaticContext(associationTarget.getPosition());
        String className = ReflectionUtils.getCanonicalName(this.m_javaInfo.getDescription().getComponentClass());
        String modifiers = "private ";
        if (isStatic) {
            modifiers = String.valueOf(modifiers) + "static ";
        }
        String fieldName = editor.getUniqueVariableName(-1, NamesManager.getName(this.m_javaInfo), null);
        FieldDeclaration field = this.addField(String.valueOf(modifiers) + className + " " + fieldName + ";");
        String methodName = LazyVariableSupportUtils.getExpectedMethodName(this.m_javaInfo, fieldName);
        methodName = editor.getUniqueMethodName(methodName);
        TypeDeclaration typeDeclaration = AstNodeUtils.getEnclosingType((ASTNode)field);
        BodyDeclarationTarget bodyTarget = new BodyDeclarationTarget(typeDeclaration, false);
        NodeTarget creationTarget = new NodeTarget(bodyTarget);
        String initializer = this.m_javaInfo.getCreationSupport().add_getSource(creationTarget);
        initializer = AssociationUtils.replaceTemplates(this.m_javaInfo, initializer, creationTarget);
        String modifiers2 = LazyVariableSupport.prefMethodModifier(this.m_javaInfo);
        if (isStatic) {
            modifiers2 = String.valueOf(modifiers2) + "static ";
        }
        String header = String.valueOf(modifiers2) + className + " " + methodName + "()";
        ArrayList bodyLines = Lists.newArrayList();
        bodyLines.add("if (" + fieldName + " == null) {");
        bodyLines.add("\t" + fieldName + " = " + initializer + ";");
        bodyLines.add("}");
        bodyLines.add("return " + fieldName + ";");
        this.m_accessor = editor.addMethodDeclaration(header, bodyLines, bodyTarget);
        JavaInfoUtils.getState(this.m_javaInfo).getFlowDescription().addStartMethod(this.m_accessor);
        IfStatement ifStatement = (IfStatement)this.m_accessor.getBody().statements().get(0);
        Block thenBlock = (Block)ifStatement.getThenStatement();
        ExpressionStatement expressionStatement = (ExpressionStatement)thenBlock.statements().get(0);
        Assignment assignment = (Assignment)expressionStatement.getExpression();
        this.add_setVariableAndInitializer(assignment.getLeftHandSide(), assignment.getRightHandSide());
        return null;
    }

    @Override
    protected void add_setVariableParameterizedType(Expression initializer) throws Exception {
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding(initializer);
        if (typeBinding.isParameterizedType()) {
            AstEditor editor = this.m_javaInfo.getEditor();
            String genericTypeName = editor.getTypeBindingSource(typeBinding);
            editor.replaceVariableType(this.m_declaration, genericTypeName);
            editor.replaceMethodType(this.m_accessor, genericTypeName);
        }
    }

    @Override
    public void deleteAfter() throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        editor.removeVariableDeclaration(this.m_declaration);
        editor.removeBodyDeclaration((BodyDeclaration)this.m_accessor);
    }

    @Override
    public void setType(String newTypeName) throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        editor.replaceVariableType(this.m_declaration, newTypeName);
        editor.replaceMethodType(this.m_accessor, newTypeName);
    }

    private String getAccessorSignature() {
        return AstNodeUtils.getMethodSignature(this.m_accessor);
    }

    public static String prefMethodModifier(JavaInfo javaInfo) {
        IPreferenceStore preferences = javaInfo.getDescription().getToolkit().getPreferences();
        return V_MODIFIER_CODE[preferences.getInt(P_METHOD_MODIFIER)];
    }

    public static final class LazyVariableInformation {
        private final MethodDeclaration m_accessor;
        private final Expression m_variable;
        private final Expression m_creation;

        public LazyVariableInformation(MethodDeclaration accessor, Expression variable, Expression creation) {
            this.m_accessor = accessor;
            this.m_variable = variable;
            this.m_creation = creation;
        }

        public Expression getCreation() {
            return this.m_creation;
        }
    }
}

