/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.factory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.internal.core.model.description.CreationInvocationDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.utils.StringUtilities;

public final class FactoryMethodDescription
extends MethodDescription {
    private boolean m_factory;
    private IMethod m_modelMethod;
    private ImageDescriptor m_icon;
    private String m_presentationName;
    private String m_description;
    private final Map<String, String> m_parameters = Maps.newTreeMap();
    private final List<CreationInvocationDescription> m_invocations = Lists.newArrayList();

    public FactoryMethodDescription(Class<?> declaringClass) {
        super(declaringClass);
    }

    public boolean isFactory() {
        return this.m_factory;
    }

    public void setFactory(boolean factory) {
        this.m_factory = factory;
    }

    public IMethod getModelMethod() {
        return this.m_modelMethod;
    }

    public void setModelMethod(IMethod modelMethod) {
        this.m_modelMethod = modelMethod;
    }

    public ImageDescriptor getIcon() {
        return this.m_icon;
    }

    public void setIcon(ImageDescriptor icon) {
        this.m_icon = icon;
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public void setPresentationName(String presentationName) {
        this.m_presentationName = presentationName;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = StringUtilities.normalizeWhitespaces((String)description);
    }

    public void addParameter(String name, String value) {
        this.m_parameters.put(name, value);
    }

    public String getParameter(String name) {
        return this.m_parameters.get(name);
    }

    public List<CreationInvocationDescription> getInvocations() {
        return this.m_invocations;
    }

    public void addInvocation(CreationInvocationDescription invocation) {
        this.m_invocations.add(invocation);
    }
}

