/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.osgi.framework.Version;

public final class CoreUtils {
    private static final String TYPE_PROPERTY = "49100913-2275-4e82-8382-c1ef7d8d62b8";

    public static <T> List<T> cast(List<?> list) {
        return list;
    }

    public static <T> T evaluate(Class<T> objectType, AstEditor editor, Expression expression) throws Exception {
        Object object = CoreUtils.evaluateObject(editor, expression);
        if (object != null) {
            Assert.instanceOf(objectType, (Object)object);
        }
        return (T)object;
    }

    public static <T> T evaluate(Class<T> objectType, AstEditor editor, Expression[] expressions, int index) throws Exception {
        return index == -1 ? null : (T)CoreUtils.evaluate(objectType, editor, expressions[index]);
    }

    public static Object evaluateObject(AstEditor editor, Expression expression) throws Exception {
        EditorState state = EditorState.get((AstEditor)editor);
        EvaluationContext context = new EvaluationContext(state.getEditorLoader(), state.getFlowDescription());
        return AstEvaluationEngine.evaluate((EvaluationContext)context, (Expression)expression);
    }

    /*
     * WARNING - void declaration
     */
    public static String getNodeReference(ASTNode node) {
        ASTNode aSTNode = node;
        if (aSTNode instanceof QualifiedName) {
            void name;
            QualifiedName qualifiedName = (QualifiedName)aSTNode;
            QualifiedName cfr_ignored_0 = (QualifiedName)aSTNode;
            return String.valueOf(AstNodeUtils.getFullyQualifiedName((Expression)name.getQualifier(), (boolean)false)) + "." + name.getName().getIdentifier();
        }
        ASTNode aSTNode2 = node;
        if (aSTNode2 instanceof SimpleName) {
            void name;
            SimpleName simpleName = (SimpleName)aSTNode2;
            SimpleName cfr_ignored_1 = (SimpleName)aSTNode2;
            return name.getIdentifier();
        }
        ASTNode aSTNode3 = node;
        if (aSTNode3 instanceof MethodInvocation) {
            void invocation;
            MethodInvocation methodInvocation = (MethodInvocation)aSTNode3;
            MethodInvocation cfr_ignored_2 = (MethodInvocation)aSTNode3;
            String reference = String.valueOf(invocation.getName().getIdentifier()) + "()";
            Expression expression = invocation.getExpression();
            if (expression != null) {
                reference = String.valueOf(CoreUtils.getNodeReference((ASTNode)expression)) + "." + reference;
            }
            return reference;
        }
        ASTNode aSTNode4 = node;
        if (aSTNode4 instanceof FieldAccess) {
            void fieldAccess;
            FieldAccess reference = (FieldAccess)aSTNode4;
            FieldAccess cfr_ignored_3 = (FieldAccess)aSTNode4;
            String reference2 = fieldAccess.getName().getIdentifier();
            Expression expression = fieldAccess.getExpression();
            if (expression instanceof ThisExpression) {
                return reference2;
            }
            return String.valueOf(CoreUtils.getNodeReference((ASTNode)expression)) + "." + reference2;
        }
        ASTNode aSTNode5 = node;
        if (aSTNode5 instanceof ThisExpression) {
            void thisExpression;
            ThisExpression reference2 = (ThisExpression)aSTNode5;
            ThisExpression cfr_ignored_4 = (ThisExpression)aSTNode5;
            String reference = "this";
            Name qualifier = thisExpression.getQualifier();
            if (qualifier != null) {
                reference = String.valueOf(qualifier.getFullyQualifiedName()) + ".this";
            }
            return reference;
        }
        ASTNode aSTNode6 = node;
        if (aSTNode6 instanceof ClassInstanceCreation) {
            void creation;
            ClassInstanceCreation reference = (ClassInstanceCreation)aSTNode6;
            ClassInstanceCreation cfr_ignored_5 = (ClassInstanceCreation)aSTNode6;
            return "new " + AstNodeUtils.getFullyQualifiedName((Expression)creation, (boolean)false) + "(" + creation.arguments().size() + ")";
        }
        Assert.fail((String)("Unknown reference: " + node));
        return null;
    }

    public static String getSafeNodeReference(ASTNode node) {
        if (node instanceof Name || node instanceof MethodInvocation || node instanceof FieldAccess || node instanceof ThisExpression || node instanceof ClassInstanceCreation) {
            return CoreUtils.getNodeReference(node);
        }
        return null;
    }

    public static List<VariableDeclarationFragment> getLocalFragments(TypeDeclaration rootNode, String methodName) throws Exception {
        final ArrayList fragments = Lists.newArrayList();
        MethodDeclaration initDataBindings = AstNodeUtils.getMethodBySignature((TypeDeclaration)rootNode, (String)(String.valueOf(methodName) + "()"));
        if (initDataBindings != null) {
            initDataBindings.accept(new ASTVisitor(){

                public void endVisit(VariableDeclarationFragment fragment) {
                    ITypeBinding binding;
                    IVariableBinding variableBinding = AstNodeUtils.getVariableBinding((ASTNode)fragment);
                    ITypeBinding iTypeBinding = binding = variableBinding == null ? null : variableBinding.getType();
                    if (CoreUtils.isIncludeTypeBinding(binding)) {
                        fragment.setProperty(CoreUtils.TYPE_PROPERTY, (Object)binding);
                        fragments.add(fragment);
                    }
                }
            });
        }
        return fragments;
    }

    public static List<VariableDeclarationFragment> getFieldFragments(TypeDeclaration rootNode) throws Exception {
        ArrayList fragments = Lists.newArrayList();
        FieldDeclaration[] fieldDeclarationArray = rootNode.getFields();
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            Type type = fieldDeclaration.getType();
            if (type != null && AstNodeUtils.getTypeBinding((Type)type) != null) {
                for (VariableDeclarationFragment fragment : DomGenerics.fragments((FieldDeclaration)fieldDeclaration)) {
                    if (!CoreUtils.isIncludeType(type)) continue;
                    fragment.setProperty(TYPE_PROPERTY, (Object)type);
                    fragments.add(fragment);
                }
            }
            ++n2;
        }
        Collections.sort(fragments, new Comparator<VariableDeclarationFragment>(){

            @Override
            public int compare(VariableDeclarationFragment fragment1, VariableDeclarationFragment fragment2) {
                return fragment1.getStartPosition() - fragment2.getStartPosition();
            }
        });
        return fragments;
    }

    public static <T> T getType(VariableDeclarationFragment fragment, boolean clearProperty) {
        Object type = fragment.getProperty(TYPE_PROPERTY);
        Assert.isNotNull((Object)type);
        if (clearProperty) {
            fragment.setProperty(TYPE_PROPERTY, null);
        }
        return (T)type;
    }

    public static boolean isIncludeType(Type type) {
        return !type.isPrimitiveType() && !type.isArrayType();
    }

    public static boolean isIncludeTypeBinding(ITypeBinding binding) {
        return binding != null && !binding.isPrimitive() && !binding.isArray();
    }

    public static String getMethodSignature(MethodInvocation invocation) {
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding((MethodInvocation)invocation);
        if (methodBinding == null) {
            return null;
        }
        ITypeBinding invocationType = methodBinding.getDeclaringClass();
        return String.valueOf(AstNodeUtils.getFullyQualifiedName((ITypeBinding)invocationType, (boolean)false)) + "." + AstNodeUtils.getMethodSignature((MethodInvocation)invocation);
    }

    public static String getCreationSignature(ClassInstanceCreation creation) {
        return String.valueOf(AstNodeUtils.getFullyQualifiedName((Expression)creation, (boolean)false)) + "." + AstNodeUtils.getCreationSignature((ClassInstanceCreation)creation);
    }

    public static Expression[] getExpressionArray(List<Expression> expressionList) {
        return expressionList.toArray(new Expression[expressionList.size()]);
    }

    public static boolean useGenerics(IJavaProject javaProject) {
        try {
            String versionValue = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
            Version version = new Version(versionValue);
            return version.getMinor() >= 5;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getDefaultString(String string, String prefix, String defaultString) {
        if (string == null) {
            return defaultString;
        }
        return String.valueOf(prefix) + string + prefix;
    }

    public static String joinStrings(String delimeter, String ... strings) {
        StringBuffer buffer = new StringBuffer();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string != null) {
                if (buffer.length() > 0) {
                    buffer.append(delimeter);
                }
                buffer.append(string);
            }
            ++n2;
        }
        return buffer.toString();
    }

    public static ClassLoader classLoader(JavaInfo javaInfo) {
        return EditorState.get((AstEditor)javaInfo.getEditor()).getEditorLoader();
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            return CoreUtils.load(classLoader, className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class<?> load(ClassLoader classLoader, String className) throws ClassNotFoundException {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            int index = className.lastIndexOf(46);
            if (index > 0) {
                try {
                    return classLoader.loadClass(String.valueOf(className.substring(0, index)) + "$" + className.substring(index + 1));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static boolean isAssignableFrom(Class<?> baseClass, Class<?> testClass) {
        return baseClass != null && baseClass.isAssignableFrom(testClass);
    }

    public static boolean isAssignableFrom(ClassLoader classLoader, String baseClass, Class<?> testClass) {
        return CoreUtils.isAssignableFrom(CoreUtils.loadClass(classLoader, baseClass), testClass);
    }

    public static Class<?> getClass(Class<?> testClass, Class<?> defaultClass) {
        return testClass == null ? defaultClass : testClass;
    }

    public static String getClassName(Class<?> clazz) {
        return clazz.getName().replace('$', '.');
    }
}

