/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.Messages;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.ui.BindWizardPage;
import org.eclipse.wb.internal.core.databinding.ui.EditComposite;
import org.eclipse.wb.internal.core.databinding.ui.ObserveElementsComposite;
import org.eclipse.wb.internal.core.databinding.ui.UiUtils;
import org.eclipse.wb.internal.core.databinding.ui.property.Context;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public class ObserveElementsWizardPage
extends WizardPage {
    private final Context m_context;
    private final IObserveInfo m_observeProperty;
    private ObserveElementsComposite m_composite;
    private BindWizardPage m_secondPage;

    public ObserveElementsWizardPage(Context context, IObserveInfo observeProperty) {
        super("first");
        this.m_context = context;
        this.m_observeProperty = observeProperty;
        this.setTitle(Messages.ObserveElementsWizardPage_title);
        this.setMessage(Messages.ObserveElementsWizardPage_message);
        this.setPageComplete(false);
    }

    public void setSecondPage(BindWizardPage page) {
        this.m_secondPage = page;
    }

    public IBindingInfo getBinding() throws Exception {
        IStructuredSelection modelSelection = EditComposite.getSelection(this.m_composite, true);
        IStructuredSelection modelPropertySelection = EditComposite.getSelection(this.m_composite, false);
        IObserveInfo model = (IObserveInfo)modelSelection.getFirstElement();
        IObserveInfo modelProperty = (IObserveInfo)modelPropertySelection.getFirstElement();
        return this.m_context.provider.createBinding(this.m_context.observeObject, this.m_observeProperty, model, modelProperty);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.create((Composite)container).noMargins().noSpacing();
        Composite titleComposite = new Composite(container, 0);
        GridLayoutFactory.create((Composite)titleComposite).columns(2);
        GridDataFactory.create((Control)titleComposite).fillH().grabH();
        Label titleLable = new Label(titleComposite, 0);
        titleLable.setText(Messages.ObserveElementsWizardPage_targetLabel);
        Label valueLabel = new Label(titleComposite, 0);
        GridDataFactory.create((Control)valueLabel).fillH().grabH();
        valueLabel.setFont(FontDescriptor.createFrom((Font)valueLabel.getFont()).setStyle(1).createFont(null));
        valueLabel.setText((String)ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<String>(){

            public String runObject() throws Exception {
                String text = ObserveElementsWizardPage.this.m_context.observeObject.getPresentation().getTextForBinding();
                String propertyText = ObserveElementsWizardPage.this.m_observeProperty.getPresentation().getTextForBinding();
                if (propertyText.length() > 0) {
                    text = String.valueOf(text) + "." + propertyText;
                }
                return text;
            }
        }, (Object)"<exception, see log>"));
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ObserveElementsWizardPage.this.handleObserveSelection();
            }
        };
        this.m_composite = new ObserveElementsComposite(container, 0, Messages.ObserveElementsWizardPage_modelLabel, this.m_context.provider, false);
        GridDataFactory.create((Control)this.m_composite).fill().grab();
        this.m_composite.showPage(this.m_context.provider.getModelStartType());
        this.m_composite.getMasterViewer().addPostSelectionChangedListener(listener);
        this.m_composite.getPropertiesViewer().addPostSelectionChangedListener(listener);
        this.setControl((Control)container);
    }

    private void handleObserveSelection() {
        IStructuredSelection modelSelection = EditComposite.getSelection(this.m_composite, true);
        IStructuredSelection modelPropertySelection = EditComposite.getSelection(this.m_composite, false);
        if (UiUtils.isEmpty((ISelection)modelSelection) || UiUtils.isEmpty((ISelection)modelPropertySelection)) {
            this.setPageComplete(false);
        } else {
            IObserveInfo model = (IObserveInfo)modelSelection.getFirstElement();
            IObserveInfo modelProperty = (IObserveInfo)modelPropertySelection.getFirstElement();
            for (IBindingInfo binding : this.m_context.provider.getBindings()) {
                if (this.m_context.observeObject != binding.getTarget() || this.m_observeProperty != binding.getTargetProperty() || model != binding.getModel() || modelProperty != binding.getModelProperty()) continue;
                this.setPageComplete(false);
                return;
            }
            try {
                this.setPageComplete(this.m_context.provider.validate(this.m_context.observeObject, this.m_observeProperty, model, modelProperty));
                if (this.isPageComplete()) {
                    this.m_secondPage.calculateFinish();
                }
            }
            catch (Throwable e) {
                DesignerPlugin.log((Throwable)e);
            }
        }
    }
}

