/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wb.core.editor.IDesignPage;
import org.eclipse.wb.core.editor.IDesignerEditor;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.Activator;
import org.eclipse.wb.internal.core.databinding.Messages;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.ui.IBindingSelectionListener;
import org.eclipse.wb.internal.core.databinding.ui.UiUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.TableFactory;
import org.eclipse.wb.internal.gef.tree.dnd.TreeTransfer;

public final class BindingElementsComposite
extends Composite {
    private final IDatabindingsProvider m_databindingsProvider;
    private final TableViewer m_bindingViewer;
    private final ToolItem m_editAction;
    private final ToolItem m_deleteAction;
    private final ToolItem m_deleteAllAction;
    private final ToolItem m_upAction;
    private final ToolItem m_downAction;
    private final ToolItem m_gotoDefinitionAction;
    private final MenuItem m_editActionMenu;
    private final MenuItem m_deleteActionMenu;
    private final MenuItem m_deleteAllActionMenu;
    private final MenuItem m_upActionMenu;
    private final MenuItem m_downActionMenu;
    private final MenuItem m_gotoDefinitionActionMenu;
    private final SelectionListener m_deleteBindingListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            BindingElementsComposite.this.deleteBindind();
        }
    };
    private final SelectionListener m_deleteAllBindingsListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            BindingElementsComposite.this.deleteAllBindinds();
        }
    };
    private final SelectionListener m_moveUpListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            BindingElementsComposite.this.moveBinding(true);
        }
    };
    private final SelectionListener m_moveDownListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            BindingElementsComposite.this.moveBinding(false);
        }
    };
    private final SelectionListener m_gotoDefinitionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            BindingElementsComposite.this.gotoDefinition();
        }
    };
    private boolean m_skipSelectionEvent;
    private IBindingSelectionListener m_listener;
    private SelectionListener m_editBindingListener;

    public BindingElementsComposite(Composite parent, int style, IDatabindingsProvider databindingsProvider, IDialogSettings settings) {
        super(parent, style);
        this.m_databindingsProvider = databindingsProvider;
        GridLayoutFactory.create((Composite)this).columns(2);
        Label titleLabel = new Label((Composite)this, 0);
        titleLabel.setText(Messages.BindingElementsComposite_boundProperties);
        GridDataFactory.create((Control)titleLabel).fillH().grabH();
        ToolBar toolBar = new ToolBar((Composite)this, 0x800000);
        GridDataFactory.create((Control)toolBar).alignHR().grabH();
        this.m_bindingViewer = new TableViewer((Composite)this, 68352);
        GridDataFactory.create((Control)this.m_bindingViewer.getControl()).fill().grab().spanH(2);
        TableFactory.modify((TableViewer)this.m_bindingViewer).standard();
        this.m_bindingViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_databindingsProvider.configureBindingViewer(settings, this.m_bindingViewer);
        this.m_bindingViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                BindingElementsComposite.this.handleBindingSelection(selection);
            }
        });
        this.m_bindingViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (BindingElementsComposite.this.m_editBindingListener != null && !UiUtils.isEmpty(BindingElementsComposite.this.m_bindingViewer.getSelection())) {
                    BindingElementsComposite.this.m_editBindingListener.widgetSelected(null);
                }
            }
        });
        this.m_bindingViewer.getControl().addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\u007f' && !UiUtils.isEmpty(BindingElementsComposite.this.m_bindingViewer.getSelection())) {
                    BindingElementsComposite.this.deleteBindind();
                }
            }
        });
        this.setupDragAndDrop();
        Table bindingTable = this.m_bindingViewer.getTable();
        Menu contextMenu = new Menu((Control)bindingTable);
        bindingTable.setMenu(contextMenu);
        this.m_editActionMenu = new MenuItem(contextMenu, 0);
        this.m_editActionMenu.setText(Messages.BindingElementsComposite_editAction);
        this.m_editActionMenu.setImage(Activator.getImage("link_edit_action.png"));
        this.m_editActionMenu.setEnabled(false);
        new MenuItem(contextMenu, 2);
        this.m_deleteActionMenu = new MenuItem(contextMenu, 0);
        this.m_deleteActionMenu.setText(Messages.BindingElementsComposite_deleteAction);
        this.m_deleteActionMenu.setImage(Activator.getImage("link_delete_action.png"));
        this.m_deleteActionMenu.setEnabled(false);
        this.m_deleteActionMenu.addSelectionListener(this.m_deleteBindingListener);
        this.m_deleteAllActionMenu = new MenuItem(contextMenu, 0);
        this.m_deleteAllActionMenu.setText(Messages.BindingElementsComposite_deleteAllAction);
        this.m_deleteAllActionMenu.setImage(Activator.getImage("link_delete_all_action.png"));
        this.m_deleteAllActionMenu.setEnabled(false);
        this.m_deleteAllActionMenu.addSelectionListener(this.m_deleteAllBindingsListener);
        new MenuItem(contextMenu, 2);
        this.m_upActionMenu = new MenuItem(contextMenu, 0);
        this.m_upActionMenu.setText(Messages.BindingElementsComposite_moveUpAction);
        this.m_upActionMenu.setImage(Activator.getImage("up.png"));
        this.m_upActionMenu.setEnabled(false);
        this.m_upActionMenu.addSelectionListener(this.m_moveUpListener);
        this.m_downActionMenu = new MenuItem(contextMenu, 0);
        this.m_downActionMenu.setText(Messages.BindingElementsComposite_moveDownAction);
        this.m_downActionMenu.setImage(Activator.getImage("down.png"));
        this.m_downActionMenu.setEnabled(false);
        this.m_downActionMenu.addSelectionListener(this.m_moveDownListener);
        new MenuItem(contextMenu, 2);
        this.m_gotoDefinitionActionMenu = new MenuItem(contextMenu, 0);
        this.m_gotoDefinitionActionMenu.setText(Messages.BindingElementsComposite_gotoDefinitionAction);
        this.m_gotoDefinitionActionMenu.setImage(Activator.getImage("goto_definition.gif"));
        this.m_gotoDefinitionActionMenu.setEnabled(false);
        this.m_gotoDefinitionActionMenu.addSelectionListener(this.m_gotoDefinitionListener);
        ToolItem refreshItem = new ToolItem(toolBar, 0);
        refreshItem.setToolTipText(Messages.BindingElementsComposite_reparseItem);
        refreshItem.setImage(DesignerPlugin.getImage((String)"editor_refresh.png"));
        refreshItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - void declaration
             */
            public void widgetSelected(SelectionEvent e) {
                IEditorPart editor = DesignerPlugin.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                IEditorPart iEditorPart = editor;
                if (iEditorPart instanceof IDesignerEditor) {
                    void designerEditor;
                    IDesignerEditor iDesignerEditor = (IDesignerEditor)iEditorPart;
                    IDesignerEditor cfr_ignored_0 = (IDesignerEditor)iEditorPart;
                    IDesignPage designPage = designerEditor.getMultiMode().getDesignPage();
                    designPage.refreshGEF();
                } else if (BindingElementsComposite.this.m_databindingsProvider != null) {
                    BindingElementsComposite.this.m_databindingsProvider.refreshDesigner();
                }
            }
        });
        new ToolItem(toolBar, 2);
        this.m_editAction = new ToolItem(toolBar, 0);
        this.m_editAction.setToolTipText(Messages.BindingElementsComposite_editItem);
        this.m_editAction.setImage(Activator.getImage("link_edit_action.png"));
        this.m_editAction.setEnabled(false);
        new ToolItem(toolBar, 2);
        this.m_deleteAction = new ToolItem(toolBar, 0);
        this.m_deleteAction.setToolTipText(Messages.BindingElementsComposite_deleteItem);
        this.m_deleteAction.setImage(Activator.getImage("link_delete_action.png"));
        this.m_deleteAction.setEnabled(false);
        this.m_deleteAction.addSelectionListener(this.m_deleteBindingListener);
        this.m_deleteAllAction = new ToolItem(toolBar, 0);
        this.m_deleteAllAction.setToolTipText(Messages.BindingElementsComposite_deleteAllItem);
        this.m_deleteAllAction.setImage(Activator.getImage("link_delete_all_action.png"));
        this.m_deleteAllAction.setEnabled(false);
        this.m_deleteAllAction.addSelectionListener(this.m_deleteAllBindingsListener);
        new ToolItem(toolBar, 2);
        this.m_upAction = new ToolItem(toolBar, 0);
        this.m_upAction.setToolTipText(Messages.BindingElementsComposite_moveUpItem);
        this.m_upAction.setImage(Activator.getImage("up.png"));
        this.m_upAction.setEnabled(false);
        this.m_upAction.addSelectionListener(this.m_moveUpListener);
        this.m_downAction = new ToolItem(toolBar, 0);
        this.m_downAction.setToolTipText(Messages.BindingElementsComposite_moveDownItem);
        this.m_downAction.setImage(Activator.getImage("down.png"));
        this.m_downAction.setEnabled(false);
        this.m_downAction.addSelectionListener(this.m_moveDownListener);
        new ToolItem(toolBar, 2);
        this.m_gotoDefinitionAction = new ToolItem(toolBar, 0);
        this.m_gotoDefinitionAction.setToolTipText(Messages.BindingElementsComposite_gotoDefinitionItem);
        this.m_gotoDefinitionAction.setImage(Activator.getImage("goto_definition.gif"));
        this.m_gotoDefinitionAction.setEnabled(false);
        this.m_gotoDefinitionAction.addSelectionListener(this.m_gotoDefinitionListener);
        this.m_databindingsProvider.fillExternalBindingActions(toolBar, contextMenu);
    }

    private void setupDragAndDrop() {
        Transfer[] transfers = new Transfer[]{TreeTransfer.INSTANCE};
        final IBindingInfo[] binding = new IBindingInfo[1];
        this.m_bindingViewer.addDragSupport(2, transfers, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                List<IBindingInfo> bindings = BindingElementsComposite.this.m_databindingsProvider.getBindings();
                event.doit = bindings.size() > 1;
                binding[0] = BindingElementsComposite.this.getSelectionBinding();
            }
        });
        ViewerDropAdapter adapter = new ViewerDropAdapter((Viewer)this.m_bindingViewer){

            protected int determineLocation(DropTargetEvent event) {
                int location = super.determineLocation(event);
                if (location == 1 || location == 2) {
                    location = 3;
                }
                return location;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (binding[0] != target && target != null) {
                    List<IBindingInfo> bindings = BindingElementsComposite.this.m_databindingsProvider.getBindings();
                    return BindingElementsComposite.this.m_databindingsProvider.canMoveBinding(binding[0], bindings.indexOf(target), false);
                }
                return false;
            }

            public boolean performDrop(Object data) {
                List<IBindingInfo> bindings = BindingElementsComposite.this.m_databindingsProvider.getBindings();
                int sourceIndex = bindings.indexOf(binding[0]);
                int targetIndex = bindings.indexOf(this.getCurrentTarget());
                BindingElementsComposite.this.m_databindingsProvider.moveBinding(binding[0], sourceIndex, targetIndex, false);
                BindingElementsComposite.this.m_bindingViewer.refresh();
                BindingElementsComposite.this.handleBindingSelection((IStructuredSelection)BindingElementsComposite.this.m_bindingViewer.getSelection());
                return true;
            }
        };
        adapter.setFeedbackEnabled(true);
        this.m_bindingViewer.addDropSupport(18, transfers, (DropTargetListener)adapter);
    }

    public void setInput(boolean refresh) {
        List<IBindingInfo> bindings = this.m_databindingsProvider.getBindings();
        if (refresh) {
            this.m_bindingViewer.refresh();
        } else {
            this.m_bindingViewer.setInput(bindings);
        }
        this.setDeleteAllActionEnabled(!bindings.isEmpty());
    }

    public TableViewer getViewer() {
        return this.m_bindingViewer;
    }

    public void setEditBindingListener(SelectionListener listener) {
        this.m_editBindingListener = listener;
        this.m_editAction.addSelectionListener(listener);
        this.m_editActionMenu.addSelectionListener(listener);
    }

    public void setDeleteAllActionEnabled(boolean enabled) {
        this.m_deleteAllAction.setEnabled(enabled);
        this.m_deleteAllActionMenu.setEnabled(enabled);
    }

    public IBindingInfo getSelectionBinding() {
        IStructuredSelection selection = (IStructuredSelection)this.m_bindingViewer.getSelection();
        return UiUtils.isEmpty((ISelection)selection) ? null : (IBindingInfo)selection.getFirstElement();
    }

    public void setBindingSelectionListener(IBindingSelectionListener listener) {
        this.m_listener = listener;
    }

    protected void handleBindingSelection(IStructuredSelection selection) {
        if (this.m_skipSelectionEvent) {
            return;
        }
        this.m_skipSelectionEvent = true;
        try {
            List<IBindingInfo> bindings;
            int size;
            boolean enabled = !UiUtils.isEmpty((ISelection)selection);
            this.m_editAction.setEnabled(enabled);
            this.m_editActionMenu.setEnabled(enabled);
            this.m_deleteAction.setEnabled(enabled);
            this.m_deleteActionMenu.setEnabled(enabled);
            IBindingInfo binding = enabled ? (IBindingInfo)selection.getFirstElement() : null;
            boolean moveUpEnabled = false;
            boolean moveDownEnabled = false;
            if (enabled && (size = (bindings = this.m_databindingsProvider.getBindings()).size()) > 1) {
                int index = bindings.indexOf(binding);
                if (index > 0) {
                    moveUpEnabled = this.m_databindingsProvider.canMoveBinding(binding, index - 1, true);
                }
                if (index < size - 1) {
                    moveDownEnabled = this.m_databindingsProvider.canMoveBinding(binding, index + 1, true);
                }
            }
            this.m_upAction.setEnabled(moveUpEnabled);
            this.m_upActionMenu.setEnabled(moveUpEnabled);
            this.m_downAction.setEnabled(moveDownEnabled);
            this.m_downActionMenu.setEnabled(moveDownEnabled);
            this.m_gotoDefinitionAction.setEnabled(enabled);
            this.m_gotoDefinitionActionMenu.setEnabled(enabled);
            if (enabled && this.m_listener != null) {
                this.m_listener.selectionChanged(binding);
            }
            this.m_bindingViewer.getTable().setFocus();
        }
        finally {
            this.m_skipSelectionEvent = false;
        }
    }

    protected void deleteBindind() {
        IBindingInfo binding = this.getSelectionBinding();
        boolean canDelete = BindingElementsComposite.canDeleteBinding(this.m_databindingsProvider, binding, this.getShell());
        if (canDelete) {
            List<IBindingInfo> bindings = this.m_databindingsProvider.getBindings();
            int index = bindings.indexOf(binding);
            this.m_databindingsProvider.deleteBinding(binding);
            if (!this.isDisposed()) {
                this.m_bindingViewer.refresh();
                if (this.m_listener != null) {
                    this.m_listener.selectionChanged(null);
                }
                if (index == bindings.size()) {
                    --index;
                }
                if (index != -1) {
                    this.m_bindingViewer.setSelection((ISelection)new StructuredSelection((Object)bindings.get(index)), true);
                }
            }
        }
    }

    public static boolean canDeleteBinding(final IDatabindingsProvider databindingsProvider, final IBindingInfo binding, Shell shell) {
        String message = (String)ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<String>(){

            public String runObject() throws Exception {
                String message = databindingsProvider.getBindingPresentationText(binding);
                if (message == null) {
                    message = "Binding[" + UiUtils.getPresentationText(binding.getTarget(), binding.getTargetProperty()) + " : " + UiUtils.getPresentationText(binding.getModel(), binding.getModelProperty()) + "]";
                }
                return message;
            }
        }, (Object)"<exception, see log>");
        boolean canDelete = MessageDialog.openConfirm((Shell)shell, (String)Messages.BindingElementsComposite_deleteTitle, (String)MessageFormat.format(Messages.BindingElementsComposite_deleteMessage, message));
        return canDelete;
    }

    protected void deleteAllBindinds() {
        boolean canDelete = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.BindingElementsComposite_deleteAllTitle, (String)Messages.BindingElementsComposite_deleteAllMessage);
        if (canDelete) {
            this.m_databindingsProvider.deleteAllBindings();
            this.m_bindingViewer.refresh();
            if (this.m_listener != null) {
                this.m_listener.selectionChanged(null);
            }
            this.setDeleteAllActionEnabled(false);
        }
    }

    private void moveBinding(boolean up) {
        List<IBindingInfo> bindings = this.m_databindingsProvider.getBindings();
        IBindingInfo binding = this.getSelectionBinding();
        int sourceIndex = bindings.indexOf(binding);
        int targetIndex = sourceIndex + (up ? -1 : 1);
        this.m_databindingsProvider.moveBinding(binding, sourceIndex, targetIndex, true);
        this.m_bindingViewer.refresh();
        this.handleBindingSelection((IStructuredSelection)this.m_bindingViewer.getSelection());
    }

    private void gotoDefinition() {
        this.m_databindingsProvider.gotoDefinition(this.getSelectionBinding());
    }
}

