/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.index;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.memories.MaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.Signed;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.rete.index.StandardIndexer;
import org.eclipse.viatra.query.runtime.rete.matcher.TimelyConfiguration;
import org.eclipse.viatra.query.runtime.rete.network.NetworkStructureChangeSensitiveNode;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.ResumableNode;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless.BehaviorChangingMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timely.TimelyMailbox;

public abstract class IndexerWithMemory
extends StandardIndexer
implements Receiver,
NetworkStructureChangeSensitiveNode,
ResumableNode {
    protected MaskedTupleMemory<Timestamp> memory;
    protected NetworkStructureChangeSensitiveLogic logic;
    protected final Mailbox mailbox;
    protected CommunicationGroup group;
    private final NetworkStructureChangeSensitiveLogic TIMELY = new NetworkStructureChangeSensitiveLogic(){

        @Override
        public void resumeAt(Timestamp timestamp) {
            Iterable signatures = IndexerWithMemory.this.memory.getResumableSignatures();
            Map wasPresent = CollectionsFactory.createMap();
            for (Tuple signature : signatures) {
                wasPresent.put(signature, IndexerWithMemory.this.memory.isPresentAtInfinity((ITuple)signature));
            }
            Map signatureMap = IndexerWithMemory.this.memory.resumeAt((Comparable)timestamp);
            for (Map.Entry outerEntry : signatureMap.entrySet()) {
                Tuple signature = (Tuple)outerEntry.getKey();
                Map diffMap = (Map)outerEntry.getValue();
                boolean isPresent = IndexerWithMemory.this.memory.isPresentAtInfinity((ITuple)signature);
                boolean change = (Boolean)wasPresent.get(signature) ^ isPresent;
                for (Map.Entry innerEntry : diffMap.entrySet()) {
                    Tuple tuple = (Tuple)innerEntry.getKey();
                    Diff diffs = (Diff)innerEntry.getValue();
                    for (Signed signed : diffs) {
                        IndexerWithMemory.this.update(signed.getDirection(), tuple, signature, change, (Timestamp)signed.getPayload());
                    }
                    change = false;
                }
            }
            Timestamp nextTimestamp = (Timestamp)IndexerWithMemory.this.memory.getResumableTimestamp();
            if (nextTimestamp != null) {
                IndexerWithMemory.this.group.notifyHasMessage(IndexerWithMemory.this.mailbox, nextTimestamp);
            }
        }

        @Override
        public void update(Direction direction, Tuple update, Timestamp timestamp) {
            Tuple signature = IndexerWithMemory.this.mask.transform((ITuple)update);
            boolean wasPresent = IndexerWithMemory.this.memory.isPresentAtInfinity((ITuple)signature);
            Diff resultDiff = direction == Direction.INSERT ? IndexerWithMemory.this.memory.addWithTimestamp(update, signature, (Comparable)timestamp) : IndexerWithMemory.this.memory.removeWithTimestamp(update, signature, (Comparable)timestamp);
            boolean isPresent = IndexerWithMemory.this.memory.isPresentAtInfinity((ITuple)signature);
            boolean change = wasPresent ^ isPresent;
            for (Signed signed : resultDiff) {
                IndexerWithMemory.this.update(signed.getDirection(), update, signature, change, (Timestamp)signed.getPayload());
            }
        }
    };
    private final NetworkStructureChangeSensitiveLogic TIMELESS = new NetworkStructureChangeSensitiveLogic(){

        @Override
        public void update(Direction direction, Tuple update, Timestamp timestamp) {
            Tuple signature = IndexerWithMemory.this.mask.transform((ITuple)update);
            boolean change = direction == Direction.INSERT ? IndexerWithMemory.this.memory.add(update, signature) : IndexerWithMemory.this.memory.remove(update, signature);
            IndexerWithMemory.this.update(direction, update, signature, change, timestamp);
        }

        @Override
        public void resumeAt(Timestamp timestamp) {
        }
    };

    public IndexerWithMemory(ReteContainer reteContainer, TupleMask mask) {
        super(reteContainer, mask);
        boolean isTimely = reteContainer.isTimelyEvaluation() && reteContainer.getCommunicationTracker().isInRecursiveGroup(this);
        this.memory = MaskedTupleMemory.create((TupleMask)mask, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.SETS, (Object)this, (boolean)isTimely, (isTimely && reteContainer.getTimelyConfiguration().getTimelineRepresentation() == TimelyConfiguration.TimelineRepresentation.FAITHFUL ? 1 : 0) != 0);
        reteContainer.registerClearable((Clearable)this.memory);
        this.mailbox = this.instantiateMailbox();
        reteContainer.registerClearable(this.mailbox);
        this.logic = this.createLogic();
    }

    @Override
    public CommunicationGroup getCurrentGroup() {
        return this.group;
    }

    @Override
    public void setCurrentGroup(CommunicationGroup group) {
        this.group = group;
    }

    @Override
    public void networkStructureChanged() {
        boolean isTimely;
        super.networkStructureChanged();
        boolean wasTimely = this.memory.isTimely();
        boolean bl = isTimely = this.reteContainer.isTimelyEvaluation() && this.reteContainer.getCommunicationTracker().isInRecursiveGroup(this);
        if (wasTimely != isTimely) {
            MaskedTupleMemory newMemory = MaskedTupleMemory.create((TupleMask)this.mask, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.SETS, (Object)this, (boolean)isTimely, (isTimely && this.reteContainer.getTimelyConfiguration().getTimelineRepresentation() == TimelyConfiguration.TimelineRepresentation.FAITHFUL ? 1 : 0) != 0);
            newMemory.initializeWith(this.memory, (Comparable)Timestamp.ZERO);
            this.memory.clear();
            this.memory = newMemory;
        }
        this.logic = this.createLogic();
    }

    protected Mailbox instantiateMailbox() {
        if (this.reteContainer.isTimelyEvaluation()) {
            return new TimelyMailbox(this, this.reteContainer);
        }
        return new BehaviorChangingMailbox(this, this.reteContainer);
    }

    @Override
    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public MaskedTupleMemory<Timestamp> getMemory() {
        return this.memory;
    }

    @Override
    public void update(Direction direction, Tuple updateElement, Timestamp timestamp) {
        this.logic.update(direction, updateElement, timestamp);
    }

    protected abstract void update(Direction var1, Tuple var2, Tuple var3, boolean var4, Timestamp var5);

    @Override
    public void appendParent(Supplier supplier) {
        if (this.parent != null) {
            throw new UnsupportedOperationException("Illegal RETE edge: " + this + " already has a parent (" + this.parent + ") and cannot connect to additional parent (" + supplier + "). ");
        }
        this.parent = supplier;
    }

    @Override
    public void removeParent(Supplier supplier) {
        if (this.parent != supplier) {
            throw new IllegalArgumentException("Illegal RETE edge removal: the parent of " + this + " is not " + supplier);
        }
        this.parent = null;
    }

    @Override
    public Collection<Supplier> getParents() {
        return Collections.singleton(this.parent);
    }

    @Override
    public void resumeAt(Timestamp timestamp) {
        this.logic.resumeAt(timestamp);
    }

    @Override
    public Timestamp getResumableTimestamp() {
        return (Timestamp)this.memory.getResumableTimestamp();
    }

    protected NetworkStructureChangeSensitiveLogic createLogic() {
        if (this.reteContainer.isTimelyEvaluation() && this.reteContainer.getCommunicationTracker().isInRecursiveGroup(this)) {
            return this.TIMELY;
        }
        return this.TIMELESS;
    }

    protected static abstract class NetworkStructureChangeSensitiveLogic {
        protected NetworkStructureChangeSensitiveLogic() {
        }

        public abstract void update(Direction var1, Tuple var2, Timestamp var3);

        public abstract void resumeAt(Timestamp var1);
    }
}

