/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.core.violationkey;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.addon.validation.core.violationkey.ViolationKey;

public class CompositeSymmetricViolationKey
implements ViolationKey {
    private Map<String, Object> keyObjects;
    private Set<List<String>> symmetricKeyObjectNames;

    public CompositeSymmetricViolationKey(Map<String, Object> keyObjects, Set<List<String>> symmetricKeyObjectNames) {
        this.keyObjects = keyObjects;
        this.symmetricKeyObjectNames = symmetricKeyObjectNames;
    }

    public Map<String, Object> getKeyObjects() {
        return this.keyObjects;
    }

    public void setKeyObjects(Map<String, Object> keyObjects) {
        this.keyObjects = keyObjects;
    }

    public Set<List<String>> getSymmetricKeyObjectNames() {
        return this.symmetricKeyObjectNames;
    }

    public void setSymmetricKeyObjectNames(Set<List<String>> symmetricKeyObjectNames) {
        this.symmetricKeyObjectNames = symmetricKeyObjectNames;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.keyObjects == null) {
            result *= 31;
        } else {
            int parametersHash = 0;
            for (Map.Entry<String, Object> entry : this.keyObjects.entrySet()) {
                boolean nonSymmetric = true;
                for (List<String> symmetrics : this.symmetricKeyObjectNames) {
                    if (!symmetrics.contains(entry.getKey())) continue;
                    parametersHash += (symmetrics.get(0) == null ? 0 : symmetrics.get(0).hashCode()) ^ (entry.getValue() == null ? 0 : entry.getValue().hashCode());
                    nonSymmetric = false;
                    break;
                }
                if (!nonSymmetric) continue;
                parametersHash += entry.hashCode();
            }
            result = 31 * result + parametersHash;
        }
        result = 31 * result + (this.symmetricKeyObjectNames == null ? 0 : this.symmetricKeyObjectNames.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeSymmetricViolationKey other = (CompositeSymmetricViolationKey)obj;
        if (this.keyObjects == null) {
            if (other.keyObjects != null) {
                return false;
            }
        } else {
            for (Map.Entry<String, Object> entry : this.keyObjects.entrySet()) {
                if (entry.getValue().equals(other.keyObjects.get(entry.getKey()))) continue;
                boolean symmetric = false;
                for (List<String> symmetrics : this.symmetricKeyObjectNames) {
                    if (!symmetrics.contains(entry.getKey())) continue;
                    symmetric = true;
                    boolean match = false;
                    for (String key : symmetrics) {
                        if (!entry.getValue().equals(other.keyObjects.get(key))) continue;
                        match = true;
                        break;
                    }
                    if (match) break;
                    return false;
                }
                if (symmetric) continue;
                return false;
            }
        }
        return !(this.symmetricKeyObjectNames == null ? other.symmetricKeyObjectNames != null : !this.symmetricKeyObjectNames.equals(other.symmetricKeyObjectNames));
    }
}

