/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.registry.GrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.internal.AbstractGrammarRegistryManager;
import org.eclipse.tm4e.registry.internal.preferences.PreferenceHelper;
import org.osgi.service.prefs.BackingStoreException;

public final class GrammarRegistryManager
extends AbstractGrammarRegistryManager {
    private static final String EXTENSION_GRAMMARS = "grammars";
    private static @Nullable GrammarRegistryManager INSTANCE;

    public static GrammarRegistryManager getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = GrammarRegistryManager.createInstance();
        return INSTANCE;
    }

    private static synchronized GrammarRegistryManager createInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        GrammarRegistryManager manager = new GrammarRegistryManager();
        manager.load();
        return manager;
    }

    private GrammarRegistryManager() {
    }

    private void load() {
        this.loadGrammarsFromExtensionPoints();
        this.loadGrammarsFromPreferences();
    }

    private void loadGrammarsFromExtensionPoints() {
        IConfigurationElement[] cf;
        IConfigurationElement[] iConfigurationElementArray = cf = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.tm4e.registry", EXTENSION_GRAMMARS);
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            String extensionName;
            IConfigurationElement ce = iConfigurationElementArray[n2];
            switch (extensionName = ce.getName()) {
                case "grammar": {
                    super.registerGrammarDefinition(new GrammarDefinition(ce));
                    break;
                }
                case "injection": {
                    String scopeName = ce.getAttribute("scopeName");
                    String injectTo = ce.getAttribute("injectTo");
                    super.registerInjection(scopeName, injectTo);
                    break;
                }
                case "scopeNameContentTypeBinding": {
                    String contentTypeId = ce.getAttribute("contentTypeId");
                    IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
                    if (contentType == null) {
                        Platform.getLog(this.getClass()).warn("No content-type found with id='" + contentTypeId + "', ignoring TM4E association.");
                        break;
                    }
                    String scopeName = ce.getAttribute("scopeName");
                    super.registerContentTypeBinding(contentType, scopeName);
                }
            }
            ++n2;
        }
    }

    private void loadGrammarsFromPreferences() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.registry");
        String json = prefs.get("org.eclipse.tm4e.registry.grammars", null);
        if (json != null) {
            IGrammarDefinition[] definitions;
            IGrammarDefinition[] iGrammarDefinitionArray = definitions = PreferenceHelper.loadGrammars(json);
            int n = definitions.length;
            int n2 = 0;
            while (n2 < n) {
                IGrammarDefinition definition = iGrammarDefinitionArray[n2];
                this.userCache.registerGrammarDefinition(definition);
                ++n2;
            }
        }
    }

    @Override
    public void save() throws BackingStoreException {
        String json = PreferenceHelper.toJson(this.userCache.getDefinitions());
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.registry");
        prefs.put("org.eclipse.tm4e.registry.grammars", json);
        prefs.flush();
    }
}

