/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationManager;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.ui.fields.FieldToolkit;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.AbstractContentProviderAdapter;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LanguageNewDialog
extends TitleAreaDialog {
    private final String m_title;
    private final TranslationManager m_manager;
    private String m_languageIso;
    private String m_countryIso;
    private ITranslationStore m_store;

    public LanguageNewDialog(Shell parentShell, TranslationManager manager) {
        super(parentShell);
        this.m_manager = (TranslationManager)Ensure.notNull((Object)manager);
        this.m_title = "Add a new language";
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_title);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.m_title);
        this.revalidate();
        this.setTitleImage(S2ESdkUiActivator.getImage("newscoutprj_wiz.png"));
        this.setHelpAvailable(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_language_page_context");
        return contents;
    }

    protected Control createDialogArea(Composite p) {
        Group rootArea = FieldToolkit.createGroupBox(p, "");
        P_LanguageContentProvider langContentProvider = new P_LanguageContentProvider();
        ProposalTextField languageChooser = FieldToolkit.createProposalField((Composite)rootArea, "Language", 1, 60);
        languageChooser.setContentProvider(langContentProvider);
        languageChooser.setLabelProvider((IBaseLabelProvider)langContentProvider);
        languageChooser.addProposalListener(item -> this.setLanguageIso(Optional.ofNullable((Locale)item).map(Locale::getLanguage).orElse(null)));
        P_CountryContentProvider countryContentProvider = new P_CountryContentProvider();
        ProposalTextField countryChooser = FieldToolkit.createProposalField((Composite)rootArea, "Country", 1, 60);
        countryChooser.setContentProvider(countryContentProvider);
        countryChooser.setLabelProvider((IBaseLabelProvider)countryContentProvider);
        countryChooser.addProposalListener(item -> this.setCountryIso(Optional.ofNullable((Locale)item).map(Locale::getCountry).orElse(null)));
        ProposalTextField storeChooser = FieldToolkit.createTranslationStoreProposalField((Composite)rootArea, "Create in", this.translationManager(), 60);
        storeChooser.addProposalListener(item -> this.setStore((ITranslationStore)item));
        storeChooser.acceptProposal(this.translationManager().primaryEditableStore().orElse(null));
        LanguageNewDialog.attachGridData((Control)storeChooser);
        LanguageNewDialog.attachGridData((Control)countryChooser);
        LanguageNewDialog.attachGridData((Control)languageChooser);
        GridDataFactory.defaultsFor((Control)rootArea).align(4, 4).grab(true, true).applyTo((Control)rootArea);
        GridLayoutFactory.swtDefaults().applyTo((Composite)rootArea);
        return rootArea;
    }

    private void revalidate() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(false);
        }
        if (Strings.isBlank((CharSequence)this.getLanguageIso())) {
            this.setMessage("Please choose a language to add.", 2);
            return;
        }
        if (this.getStore() == null) {
            this.setMessage("Please choose a service in which the new language should be created.", 2);
            return;
        }
        Language lang = new Language(new Locale(this.getLanguageIso(), Strings.notBlank((CharSequence)this.getCountryIso()).orElse("")));
        if (this.getStore().languages().anyMatch(Predicate.isEqual(lang))) {
            this.setMessage("This language already exists.", 2);
            return;
        }
        this.setMessage("Adds a new Language.");
        if (okButton != null) {
            okButton.setEnabled(true);
        }
    }

    private static void attachGridData(Control c) {
        GridDataFactory.defaultsFor((Control)c).align(4, 0x1000000).grab(true, false).applyTo(c);
    }

    public TranslationManager translationManager() {
        return this.m_manager;
    }

    public String getLanguageIso() {
        return this.m_languageIso;
    }

    protected void setLanguageIso(String languageIso) {
        this.m_languageIso = languageIso;
        this.revalidate();
    }

    public String getCountryIso() {
        return this.m_countryIso;
    }

    protected void setCountryIso(String countryIso) {
        this.m_countryIso = countryIso;
        this.revalidate();
    }

    public ITranslationStore getStore() {
        return this.m_store;
    }

    protected void setStore(ITranslationStore store) {
        this.m_store = store;
        this.revalidate();
    }

    private static final class P_LanguageContentProvider
    extends AbstractContentProviderAdapter {
        private final Image m_image = S2ESdkUiActivator.getImage("comment.png");

        private P_LanguageContentProvider() {
        }

        public String getText(Object element) {
            Locale loc = (Locale)element;
            String ds = loc.getDisplayLanguage();
            String l = loc.getLanguage();
            StringBuilder b = new StringBuilder(ds.length() + l.length() + 3);
            b.append(ds);
            b.append(" (");
            b.append(l);
            b.append(')');
            return b.toString();
        }

        @Override
        public Image getImage(Object element) {
            return this.m_image;
        }

        @Override
        protected Collection<?> loadProposals(IProgressMonitor monitor) {
            String[] isoLanguages = Locale.getISOLanguages();
            return Arrays.stream(isoLanguages).map(Locale::new).collect(Collectors.toList());
        }
    }

    private static final class P_CountryContentProvider
    extends AbstractContentProviderAdapter {
        private final Image m_image = S2ESdkUiActivator.getImage("comment.png");

        private P_CountryContentProvider() {
        }

        public String getText(Object element) {
            Locale loc = (Locale)element;
            String dc = loc.getDisplayCountry();
            String c = loc.getCountry();
            StringBuilder b = new StringBuilder(dc.length() + c.length() + 3);
            b.append(dc);
            b.append(" (");
            b.append(c);
            b.append(')');
            return b.toString();
        }

        @Override
        public Image getImage(Object element) {
            return this.m_image;
        }

        @Override
        protected Collection<?> loadProposals(IProgressMonitor monitor) {
            String[] isoCountries = Locale.getISOCountries();
            return Arrays.stream(isoCountries).map(isoCountry -> new Locale("", (String)isoCountry)).collect(Collectors.toList());
        }
    }
}

