/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.actions;

import java.util.BitSet;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.internal.ui.UIUtils;
import org.eclipse.ptp.internal.ui.actions.DeleteSetAction;
import org.eclipse.ptp.internal.ui.actions.ParallelAction;
import org.eclipse.ptp.internal.ui.messages.Messages;
import org.eclipse.ptp.internal.ui.model.IElementHandler;
import org.eclipse.ptp.internal.ui.model.IElementSet;
import org.eclipse.ptp.internal.ui.views.AbstractParallelElementView;

public class RemoveElementAction
extends ParallelAction {
    public static final String name = Messages.RemoveElementAction_0;

    public RemoveElementAction(AbstractParallelElementView view) {
        super(name, view);
        this.setImageDescriptor(ParallelImages.ID_ICON_DELETEELEMENT_NORMAL);
    }

    @Override
    public void run(BitSet elements) {
        if (this.validation(elements)) {
            IElementSet set = this.view.getCurrentSet();
            if (set.size() == elements.cardinality()) {
                this.callDeleteGroupAction();
            } else {
                IElementHandler setManager = this.view.getCurrentElementHandler();
                if (setManager == null) {
                    return;
                }
                if (UIUtils.showQuestionDialog(Messages.RemoveElementAction_1, NLS.bind((String)Messages.RemoveElementAction_2, (Object)elements.cardinality()))) {
                    this.view.getUIManager().removeFromSet(elements, set.getID(), setManager);
                    this.view.selectSet(setManager.getSet(set.getID()));
                    this.view.updateTitle();
                    this.view.refresh(false);
                }
            }
        }
    }

    private void callDeleteGroupAction() {
        IToolBarManager manager = this.view.getViewSite().getActionBars().getToolBarManager();
        IContributionItem item = manager.find(DeleteSetAction.name);
        if (item != null && item instanceof ActionContributionItem) {
            ((ActionContributionItem)item).getAction().run();
        }
    }
}

