/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.textview;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ptp.pldt.common.util.Utility;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPAnalysisManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.ActionDelegate;

public class ShowConcurrencyAction
extends ActionDelegate
implements IEditorActionDelegate {
    protected CEditor editor_ = null;
    protected static final String TITLE = "Show Concurrency";

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof CEditor) {
            this.editor_ = (CEditor)targetEditor;
        }
    }

    public void runWithEvent(IAction action, Event event) {
        TextSelection selection = null;
        if (this.editor_ != null && this.editor_.getSelectionProvider().getSelection() instanceof TextSelection) {
            selection = (TextSelection)this.editor_.getSelectionProvider().getSelection();
        }
        if (selection != null) {
            this.showConcurrency(selection);
        } else {
            this.showMessage(TITLE, "No selections made");
        }
    }

    protected void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)ShowConcurrencyAction.getStandardDisplay().getActiveShell(), (String)title, (String)message);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected void showConcurrency(TextSelection selection) {
        if (selection.getOffset() == 0 && selection.getLength() == 0) {
            this.showMessage(TITLE, "No selections made");
            return;
        }
        OpenMPAnalysisManager oam = OpenMPAnalysisManager.getCurrentManager();
        if (oam == null) {
            this.showMessage(TITLE, "No OpenMP Analysis has been performed");
            return;
        }
        if (oam.getTU() == null) {
            this.showMessage(TITLE, "Error in last OpenMP Analysis");
            return;
        }
        IEditorInput ieu = this.editor_.getEditorInput();
        IFile inputFile = null;
        if (!(ieu instanceof IFileEditorInput)) {
            this.showMessage(TITLE, "Cannot locate file in editor");
            return;
        }
        inputFile = ((IFileEditorInput)ieu).getFile();
        if (!oam.getTU().getFilePath().equals(inputFile.getLocation().toOSString())) {
            this.showMessage(TITLE, "OpenMP analysis required on editor file");
            return;
        }
        if (oam.getFileMap() == null) {
            this.showMessage(TITLE, "Internal Error: no file map");
            return;
        }
        IASTNode node = oam.getFileMap().find(selection.getOffset(), 1);
        if (node == null) {
            this.showMessage(TITLE, "Cannot locate statement at given selection point");
            return;
        }
        ShowConcurrencyAction.removeConcurrencyMarkers(this.editor_.getDocumentProvider().getAnnotationModel((Object)this.editor_.getEditorInput()));
        Set cSet = oam.getNodesConcurrentTo(node);
        for (IASTNode n : cSet) {
            this.showNode(n, "org.eclipse.ptp.pldt.openmp.analysis.concurrency");
        }
        if (!cSet.contains(node)) {
            this.showNode(node, "org.eclipse.ptp.pldt.openmp.analysis.nonconcurrency");
        }
        Utility.Location l = Utility.getLocation((IASTNode)node);
        this.editor_.selectAndReveal(l.low_, l.high_ - l.low_ + 1);
    }

    protected void showNode(IASTNode node, String markerType) {
        Utility.Location l = Utility.getLocation((IASTNode)node);
        IAnnotationModel am = this.editor_.getDocumentProvider().getAnnotationModel((Object)this.editor_.getEditorInput());
        Annotation a = new Annotation(markerType, true, "Hi");
        int end = l.high_ - l.low_ + 1;
        Position p = new Position(l.low_, end);
        am.addAnnotation(a, p);
    }

    public static void removeConcurrencyMarkers(IAnnotationModel am) {
        LinkedList ais = new LinkedList();
        Iterator ai = am.getAnnotationIterator();
        while (ai.hasNext()) {
            ais.add(ai.next());
        }
        for (Annotation a : ais) {
            if (!a.getType().equals("org.eclipse.ptp.pldt.openmp.analysis.concurrency") && !a.getType().equals("org.eclipse.ptp.pldt.openmp.analysis.nonconcurrency")) continue;
            am.removeAnnotation(a);
        }
    }
}

