/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.tau.messages.Messages;
import org.eclipse.ptp.etfw.tau.papiselect.PapiListSelectionDialog;
import org.eclipse.ptp.etfw.tau.papiselect.papic.EventTreeDialog;
import org.eclipse.ptp.etfw.toolopts.IToolUITab;
import org.eclipse.ptp.etfw.toolopts.ToolPaneListener;
import org.eclipse.ptp.internal.etfw.BuildLaunchUtils;
import org.eclipse.ptp.internal.etfw.RemoteBuildLaunchUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAUMakefileTab
implements IToolUITab {
    protected boolean noPTP = false;
    protected CheckItem[] checks = new CheckItem[]{new CheckItem("mpi", "MPI", "", "use_mpi", true), new CheckItem("callpath", "Callpath Profiling", "", "use_callpath_profiling", false), new CheckItem("phase", "Phase Based Profiling", "", "use_tau_phases", false), new CheckItem("memory", "Memory Profiling", "", "use_memory_profiling", false), new CheckItem("opari", "OPARI", "", "use_opari", false), new CheckItem("openmp", "OpenMP", "", "use_openmp", false), new CheckItem("epilog", "Epilog", "", "use_epilog", false), new CheckItem("vampirtrace", "VampirTrace", "", "use_vampirtrace", false), new CheckItem("papi", "PAPI", "", "use_papi_library", false), new CheckItem("perf", "Perflib", "", "use_perf_library", false), new CheckItem("trace", Messages.TAUAnalysisTab_31, "", "use_tau_tracing", false), new CheckItem("pdt", "PDT", "", "use_tau_with_PDT", false)};
    protected int mpiIndex = 0;
    protected int callpathIndex = 1;
    protected Button runTauinc;
    protected int papiIndex = 8;
    protected int pdtIndex = 11;
    protected Button papiSelect;
    protected Button[] papiCountRadios;
    protected Button[] pdtRadios;
    protected Composite papiComp;
    protected Composite pdtComp;
    protected Composite mpiComp;
    protected Composite selComp;
    protected Label selectLabel;
    protected Text compiler;
    protected Button nocleanCheck;
    protected LinkedHashSet<String> allmakefiles = null;
    protected LinkedHashSet<String> selmakefiles = null;
    protected LinkedHashSet<String> allopts = null;
    protected LinkedHashSet<String> selopts = null;
    protected Combo makecombo = null;
    protected Combo dbCombo = null;
    protected String selmakefile = null;
    private IFileStore taulib = null;
    protected Map<String, String> archvarmap = null;
    protected Map<String, String> varmap = null;
    private static final String UNIX_SLASH = "/";
    protected WidgetListener listener = new WidgetListener();
    private IBuildLaunchUtils blt;
    private static final String TAU_MAKEFILE_PREFIX = "Makefile.tau";
    private static final String BIN = "bin";
    private static final String EQ = "=";
    private static final String PAPI = "papi";
    private static final String PAPI_EVENT_CHOOSER = "papi_event_chooser";
    private static final String PAPIDIR = "PAPIDIR=";
    private static final String UTILS = "utils";
    private static final String SHARE = "share";
    private static final String PAPI_XML_BIN = "papi_xml_event_info";
    private ToolPaneListener paneListener;
    Composite fComp;

    protected static GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected static GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return SWTFactory.createCheckButton((Composite)parent, (String)label, null, (boolean)false, (int)1);
    }

    protected Button createPushButton(Composite parent, String label, Image image) {
        return SWTFactory.createPushButton((Composite)parent, (String)label, (Image)image);
    }

    protected Button createRadioButton(Composite parent, String label) {
        return SWTFactory.createRadioButton((Composite)parent, (String)label);
    }

    protected void createSeparator(Composite comp, int colSpan) {
        Label label = new Label(comp, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        SWTFactory.createVerticalSpacer((Composite)comp, (int)colSpan);
    }

    public String getArgument(ILaunchConfiguration configuration) {
        return null;
    }

    public String getConfigID() {
        return "TAU_MAKEFILE_SELECTION_PANE";
    }

    public String getConfigVarID() {
        return "TAU_MAKEFILE_SELECTION_PANE_VARS";
    }

    public Map<String, String> getEnvVars(ILaunchConfiguration configuration) {
        return null;
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals("")) {
            return null;
        }
        return text;
    }

    public String getName() {
        return "TAU Makefile";
    }

    public String getOptionString() {
        return "";
    }

    private IFileStore getPapiLoc() throws FileNotFoundException {
        if (this.makecombo == null || this.taulib == null) {
            return null;
        }
        int selDex = this.makecombo.getSelectionIndex();
        if (selDex == -1) {
            return null;
        }
        String selItem = this.makecombo.getItem(selDex);
        if (selItem == null) {
            return null;
        }
        IFileStore papimakefile = this.blt.getFile(this.taulib.toURI().getPath());
        if (!(papimakefile = papimakefile.getChild(selItem)).fetchInfo().exists()) {
            System.out.println(Messages.TAUAnalysisTab_InvalidPAPIMakefile);
        }
        String papiline = "";
        boolean found = false;
        try {
            BufferedReader readmake = new BufferedReader(new InputStreamReader(papimakefile.openInputStream(0, null)));
            papiline = readmake.readLine();
            while (papiline != null) {
                if (papiline.indexOf(PAPIDIR) == 0) {
                    found = true;
                    break;
                }
                papiline = readmake.readLine();
            }
            readmake.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IFileStore papibin = null;
        if (found) {
            IFileStore papihome = this.blt.getFile(papiline = papiline.substring(papiline.indexOf(EQ) + 1));
            papibin = papihome.getChild(BIN).getChild(PAPI_EVENT_CHOOSER);
            if (!papibin.fetchInfo().exists()) {
                papibin = papihome.getChild(SHARE).getChild(PAPI).getChild(UTILS).getChild(PAPI_EVENT_CHOOSER);
            }
            if (!papibin.fetchInfo().exists()) {
                throw new FileNotFoundException(Messages.TAUAnalysisTab_CouldNotLocatePapiUtils);
            }
        } else {
            System.out.println(Messages.TAUAnalysisTab_NoPapiDirInMakefile);
        }
        return papibin.getParent();
    }

    protected Shell getShell() {
        if (this.fComp != null) {
            return this.fComp.getShell();
        }
        return null;
    }

    public String getToolName() {
        return "TAU";
    }

    public Map<String, String> getVarMap() {
        return null;
    }

    protected void handlePapiSelect() {
        Object[] selected = null;
        try {
            IFileStore pdir = this.getPapiLoc();
            if (pdir == null || !pdir.fetchInfo().exists() || !pdir.fetchInfo().isDirectory()) {
                return;
            }
            IFileStore pcxi = pdir.getChild(PAPI_XML_BIN);
            if (pcxi.fetchInfo().exists()) {
                EventTreeDialog treeD = new EventTreeDialog(this.getShell(), pdir, this.blt);
                if (treeD.open() == 0) {
                    selected = treeD.getCommands().toArray();
                }
            } else {
                LabelProvider papilab = new LabelProvider();
                ArrayContentProvider paprov = new ArrayContentProvider();
                int papiCountType = 0;
                if (this.papiCountRadios[1].getSelection()) {
                    papiCountType = 1;
                }
                PapiListSelectionDialog papidialog = new PapiListSelectionDialog(this.getShell(), pdir, this.blt, (IStructuredContentProvider)paprov, (ILabelProvider)papilab, Messages.TAUAnalysisTab_SelectPapiCountersForTau, papiCountType);
                papidialog.setTitle(Messages.TAUAnalysisTab_PapiCounters);
                papidialog.setHelpAvailable(false);
                if (this.varmap != null && this.varmap.size() > 0) {
                    papidialog.setInitialSelections(this.varmap.values().toArray());
                }
                if (papidialog.open() == 0) {
                    selected = papidialog.getResult();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (selected != null && selected.length > 0) {
            LinkedHashSet selset = new LinkedHashSet(Arrays.asList(selected));
            String pn = "PAPI_NATIVE_";
            String pPre = "PAPI_";
            this.varmap = new HashMap<String, String>(selset.size());
            this.varmap.put("COUNTER1", "GET_TIME_OF_DAY");
            Iterator varit = selset.iterator();
            int counter = 2;
            while (varit.hasNext()) {
                String varTxt = (String)varit.next();
                if (varTxt.indexOf("PAPI_") != 0) {
                    varTxt = "PAPI_NATIVE_" + varTxt;
                }
                this.varmap.put("COUNTER" + counter, varTxt);
                ++counter;
            }
        } else {
            this.varmap = null;
        }
    }

    public void initializePane(ILaunchConfiguration configuration) throws CoreException {
        try {
            this.blt = RemoteBuildLaunchUtils.isRemote((ILaunchConfiguration)configuration) ? new RemoteBuildLaunchUtils(configuration) : new BuildLaunchUtils();
            this.selopts = new LinkedHashSet();
            this.initMakefiles();
            this.initMakeChecks();
            CheckItem[] checkItemArray = this.checks;
            int n = this.checks.length;
            int n2 = 0;
            while (n2 < n) {
                CheckItem check = checkItemArray[n2];
                check.unitCheck.setSelection(configuration.getAttribute(check.confString, check.defState));
                if (check.unitCheck.getSelection() && check.unitCheck.getEnabled()) {
                    this.selopts.add(check.makeCmd);
                }
                ++n2;
            }
            if (this.checks[this.mpiIndex].unitCheck.getSelection() && this.checks[this.callpathIndex].unitCheck.getSelection() && this.checks[this.mpiIndex].unitCheck.getEnabled()) {
                this.runTauinc.setEnabled(true);
            } else {
                this.runTauinc.setEnabled(false);
            }
            this.runTauinc.setSelection(configuration.getAttribute("use_tauinc_script", false));
            int pcr = configuration.getAttribute("papi_counter_type_selection", 0);
            if (pcr > 1) {
                pcr = 0;
            }
            this.papiCountRadios[pcr].setSelection(true);
            int pdtSel = configuration.getAttribute("pdt_or_compiler_inst_selection", 0);
            if (pdtSel > 1) {
                pdtSel = 0;
            }
            this.pdtRadios[pdtSel].setSelection(true);
            this.selmakefile = configuration.getAttribute("filename_of_last_selected_makefile", null);
            this.initMakeCombo();
            this.reinitMakeChecks();
            this.varmap = this.archvarmap = configuration.getAttribute("environment_variable_map", null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void initMakeChecks() {
        if (this.allmakefiles == null || this.allmakefiles.size() == 0 || this.allopts == null || this.allopts.size() == 0) {
            CheckItem[] checkItemArray = this.checks;
            int n = this.checks.length;
            int n2 = 0;
            while (n2 < n) {
                CheckItem check = checkItemArray[n2];
                check.unitCheck.setEnabled(false);
                ++n2;
            }
            return;
        }
        int i = 0;
        while (i < this.checks.length) {
            if (!this.allopts.contains(this.checks[i].makeCmd)) {
                this.checks[i].unitCheck.setEnabled(false);
            }
            ++i;
        }
    }

    private void initMakeCombo() {
        try {
            String adding2 = "";
            this.makecombo.removeAll();
            this.selectMakefiles();
            String select = "";
            if (this.selmakefiles != null && this.selmakefiles.size() > 0) {
                for (String adding2 : this.selmakefiles) {
                    if (select.length() > adding2.length() || select.equals("")) {
                        select = adding2;
                    }
                    this.makecombo.add(adding2);
                }
                if (this.selmakefile != null && this.makecombo.indexOf(this.selmakefile) >= 0) {
                    this.makecombo.select(this.makecombo.indexOf(this.selmakefile));
                } else {
                    this.makecombo.select(this.makecombo.indexOf(select));
                }
            } else {
                this.makecombo.add(Messages.TAUAnalysisTab_NoValidMakefiles);
                this.makecombo.select(0);
            }
            String makeStub = this.makecombo.getItem(this.makecombo.getSelectionIndex());
            this.updateComboDerivedOptions(makeStub);
            this.makecombo.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initMakefiles() {
        String binpath = this.blt.getToolPath("tau");
        IFileStore bindir = null;
        if (binpath == null || binpath.length() == 0) {
            binpath = this.blt.checkToolEnvPath("pprof");
            if (binpath != null && binpath.length() > 0) {
                bindir = this.blt.getFile(binpath);
            }
        } else {
            bindir = this.blt.getFile(binpath);
        }
        List<IFileStore> mfiles = this.testTAUEnv(bindir);
        this.allmakefiles = new LinkedHashSet();
        this.allopts = new LinkedHashSet();
        String name = null;
        if (mfiles == null) {
            return;
        }
        int i = 0;
        while (i < mfiles.size()) {
            name = mfiles.get(i).getName();
            this.allmakefiles.add(name);
            this.allopts.addAll(Arrays.asList(name.split("-")));
            ++i;
        }
        this.allopts.remove(TAU_MAKEFILE_PREFIX);
    }

    public boolean isEmbedded() {
        return false;
    }

    public boolean isVirtual() {
        return false;
    }

    public void makeToolPane(Composite comp) {
        this.makeToolPane(comp, null);
    }

    public void makeToolPane(Composite comp, ToolPaneListener paneListener) {
        this.fComp = comp;
        this.paneListener = paneListener;
        Composite anaComp = new Composite(comp, 0);
        anaComp.setLayout((Layout)TAUMakefileTab.createGridLayout(1, false, 0, 0));
        anaComp.setLayoutData((Object)TAUMakefileTab.spanGridData(768, 5));
        this.createVerticalSpacer(anaComp, 2);
        int i = 0;
        while (i < this.checks.length) {
            if (i == this.papiIndex) {
                this.papiComp = new Composite(anaComp, 0);
                this.papiComp.setLayout((Layout)TAUMakefileTab.createGridLayout(5, false, 0, 0));
                this.papiComp.setLayoutData((Object)new GridData(768));
                this.checks[i].unitCheck = this.createCheckButton(this.papiComp, this.checks[i].buttonText);
                this.checks[i].unitCheck.setToolTipText(this.checks[i].toolText);
                this.checks[i].unitCheck.addSelectionListener((SelectionListener)this.listener);
                this.papiSelect = this.createPushButton(this.papiComp, Messages.TAUAnalysisTab_SelectPapiCounters, null);
                this.papiSelect.setToolTipText(Messages.TAUAnalysisTab_SetPapiEnvVar);
                this.papiSelect.addSelectionListener((SelectionListener)this.listener);
                this.papiCountRadios = new Button[2];
                this.papiCountRadios[0] = this.createRadioButton(this.papiComp, Messages.TAUAnalysisTab_PresetCounters);
                this.papiCountRadios[1] = this.createRadioButton(this.papiComp, Messages.TAUAnalysisTab_NativeCounters);
            } else if (i == this.pdtIndex) {
                this.pdtComp = new Composite(anaComp, 0);
                this.pdtComp.setLayout((Layout)TAUMakefileTab.createGridLayout(5, false, 0, 0));
                this.pdtComp.setLayoutData((Object)new GridData(768));
                this.checks[i].unitCheck = this.createCheckButton(this.pdtComp, this.checks[i].buttonText);
                this.checks[i].unitCheck.setToolTipText(this.checks[i].toolText);
                this.checks[i].unitCheck.addSelectionListener((SelectionListener)this.listener);
                this.pdtRadios = new Button[2];
                this.pdtRadios[0] = this.createRadioButton(this.pdtComp, Messages.TAUAnalysisTab_PDTInstrumentation);
                this.pdtRadios[1] = this.createRadioButton(this.pdtComp, Messages.TAUAnalysisTab_CompilerInstrumentation);
                this.pdtRadios[0].addSelectionListener((SelectionListener)this.listener);
                this.pdtRadios[1].addSelectionListener((SelectionListener)this.listener);
            } else if (i == this.mpiIndex) {
                this.mpiComp = new Composite(anaComp, 0);
                this.mpiComp.setLayout((Layout)TAUMakefileTab.createGridLayout(5, false, 0, 0));
                this.mpiComp.setLayoutData((Object)new GridData(768));
                this.checks[i].unitCheck = this.createCheckButton(this.mpiComp, this.checks[i].buttonText);
                this.checks[i].unitCheck.setToolTipText(this.checks[i].toolText);
                this.checks[i].unitCheck.addSelectionListener((SelectionListener)this.listener);
                this.runTauinc = this.createCheckButton(this.mpiComp, Messages.TAUAnalysisTab_GenerateMPIIncludeList);
                this.runTauinc.addSelectionListener((SelectionListener)this.listener);
            } else {
                this.checks[i].unitCheck = this.createCheckButton(anaComp, this.checks[i].buttonText);
                this.checks[i].unitCheck.setToolTipText(this.checks[i].toolText);
                this.checks[i].unitCheck.addSelectionListener((SelectionListener)this.listener);
            }
            ++i;
        }
        Composite makeComp = new Composite(anaComp, 0);
        makeComp.setLayout((Layout)TAUMakefileTab.createGridLayout(2, false, 0, 0));
        makeComp.setLayoutData((Object)new GridData(768));
        Label makeLab = new Label(makeComp, 0);
        makeLab.setText(Messages.TAUAnalysisTab_SelectMakefile);
        this.makecombo = new Combo(makeComp, 2060);
        this.makecombo.addSelectionListener((SelectionListener)this.listener);
    }

    public void OptUpdate() {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        CheckItem[] checkItemArray = this.checks;
        int n = this.checks.length;
        int n2 = 0;
        while (n2 < n) {
            CheckItem check = checkItemArray[n2];
            configuration.setAttribute(check.confString, check.unitCheck.getSelection());
            ++n2;
        }
        configuration.setAttribute("use_tauinc_script", this.runTauinc.getSelection());
        if (this.varmap == null && this.archvarmap != null || this.varmap != null && this.archvarmap == null || this.varmap != null && this.archvarmap != null && !this.varmap.equals(this.archvarmap)) {
            HashMap<String, String> envvars = null;
            try {
                envvars = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (envvars != null && envvars.size() > 0 && this.archvarmap != null && this.archvarmap.size() > 0) {
                Iterator<String> archit = this.archvarmap.keySet().iterator();
                while (archit.hasNext()) {
                    envvars.remove(archit.next());
                }
            }
            if (this.varmap != null && this.varmap.size() > 0) {
                if (envvars == null) {
                    envvars = new HashMap<String, String>();
                }
                envvars.putAll(this.varmap);
            }
            configuration.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, (Map)envvars);
            configuration.setAttribute("environment_variable_map", this.varmap);
        }
        if (this.papiCountRadios[0].getSelection()) {
            configuration.setAttribute("papi_counter_type_selection", 0);
        } else if (this.papiCountRadios[1].getSelection()) {
            configuration.setAttribute("papi_counter_type_selection", 1);
        }
        if (this.pdtRadios[0].getSelection()) {
            configuration.setAttribute("pdt_or_compiler_inst_selection", 0);
        } else {
            configuration.setAttribute("pdt_or_compiler_inst_selection", 1);
        }
        int seldex = this.makecombo.getSelectionIndex();
        if (seldex < 0 || this.taulib == null) {
            return;
        }
        String tauMakeName = this.makecombo.getItem(seldex);
        configuration.setAttribute("filename_of_last_selected_makefile", tauMakeName);
        configuration.setAttribute("tau_makefile.performance.options.configuration_id_", "-tau_makefile=" + this.taulib.toURI().getPath() + UNIX_SLASH + this.makecombo.getItem(this.makecombo.getSelectionIndex()));
        configuration.setAttribute("performance_tool_build_configuration_name_modifier.TAU", "_" + tauMakeName.substring(tauMakeName.lastIndexOf(".") + 1));
    }

    private void reinitMakeChecks() {
        LinkedHashSet<String> goodopts = new LinkedHashSet<String>(this.allopts.size());
        String holdmake = null;
        String check2 = null;
        if (this.selopts == null || this.selopts.size() == 0) {
            goodopts.addAll(this.allopts);
        } else {
            Iterator makes = this.allmakefiles.iterator();
            boolean allgood = true;
            while (makes.hasNext()) {
                holdmake = (String)makes.next();
                for (String check2 : this.selopts) {
                    if (holdmake.indexOf("-" + check2) > 0) continue;
                    allgood = false;
                    break;
                }
                if (allgood) {
                    goodopts.addAll(Arrays.asList(holdmake.split("-")));
                    continue;
                }
                allgood = true;
            }
        }
        int i = 0;
        while (i < this.checks.length) {
            if (!goodopts.contains(this.checks[i].makeCmd)) {
                this.checks[i].unitCheck.setEnabled(false);
            } else {
                this.checks[i].unitCheck.setEnabled(true);
            }
            ++i;
        }
    }

    private void selectMakefiles() {
        this.selmakefiles = new LinkedHashSet();
        Iterator allit = this.allmakefiles.iterator();
        String curmake = "";
        String curopt = "";
        while (allit.hasNext()) {
            Iterator nameit = this.selopts.iterator();
            boolean hasall = true;
            curmake = (String)allit.next();
            while (nameit.hasNext()) {
                curopt = (String)nameit.next();
                if (curmake.indexOf("-" + curopt) > 0) continue;
                hasall = false;
                break;
            }
            if (hasall) {
                this.selmakefiles.add(curmake);
                continue;
            }
            hasall = true;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("use_mpi", !this.noPTP);
        configuration.setAttribute("use_tauinc_script", false);
        configuration.setAttribute("use_callpath_profiling", false);
        configuration.setAttribute("use_memory_profiling", false);
        configuration.setAttribute("use_papi_library", false);
        configuration.setAttribute("use_perf_library", false);
        configuration.setAttribute("use_tau_tracing", false);
        configuration.setAttribute("use_tau_phases", false);
        configuration.setAttribute("use_this_compiler", "");
        configuration.setAttribute("use_epilog", false);
        configuration.setAttribute("use_vampirtrace", false);
        configuration.setAttribute("keep_profile_files", false);
        configuration.setAttribute("selective_instrumentation", 0);
        configuration.setAttribute("selective_instrumentation_file_path_shown", "");
        configuration.setAttribute("environment_variable_map", null);
        configuration.setAttribute("tau_makefile.performance.options.configuration_id_", "");
    }

    private List<IFileStore> testTAUEnv(IFileStore bindir) {
        if (bindir == null || !bindir.fetchInfo().exists()) {
            return null;
        }
        this.taulib = bindir.getParent().getChild("lib");
        IFileStore[] mfiles = null;
        ArrayList<IFileStore> tmfiles = null;
        if (this.taulib.fetchInfo().exists()) {
            try {
                mfiles = this.taulib.childStores(0, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            tmfiles = new ArrayList<IFileStore>();
            IFileStore[] iFileStoreArray = mfiles;
            int n = mfiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore mfile = iFileStoreArray[n2];
                IFileInfo finf = mfile.fetchInfo();
                if (!finf.isDirectory() && finf.getName().startsWith(TAU_MAKEFILE_PREFIX)) {
                    tmfiles.add(mfile);
                }
                ++n2;
            }
        }
        return tmfiles;
    }

    private void updateComboDerivedOptions(String makeStub) {
        if (makeStub.indexOf("-papi") > 0) {
            this.papiSelect.setEnabled(true);
        } else {
            this.papiSelect.setEnabled(false);
        }
        if (makeStub.indexOf("-pdt") >= 0) {
            if (!this.pdtRadios[0].getEnabled()) {
                this.pdtRadios[0].setEnabled(true);
            }
        } else {
            this.pdtRadios[0].setEnabled(false);
            this.pdtRadios[0].setSelection(false);
            this.pdtRadios[1].setSelection(true);
        }
        if (makeStub.indexOf("-callpath") >= 0 && makeStub.indexOf("-mpi") >= 0) {
            this.runTauinc.setEnabled(true);
        } else {
            this.runTauinc.setSelection(false);
            this.runTauinc.setEnabled(false);
        }
    }

    public void updateOptDisplay() {
    }

    public boolean updateOptField(Object source) {
        return false;
    }

    protected class CheckItem {
        protected Button unitCheck;
        protected String makeCmd;
        protected String buttonText;
        protected String toolText;
        protected String confString;
        protected boolean defState;

        CheckItem() {
        }

        CheckItem(String cmd, String bText, String tText, String cString, boolean def) {
            this.defState = def;
            this.makeCmd = cmd;
            this.buttonText = bText;
            this.toolText = tText;
            this.confString = cString;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent evt) {
            TAUMakefileTab.this.paneListener.widgetSelected(null);
        }

        public void propertyChange(PropertyChangeEvent event) {
            TAUMakefileTab.this.paneListener.widgetSelected(null);
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == TAUMakefileTab.this.makecombo) {
                TAUMakefileTab.this.selmakefile = TAUMakefileTab.this.makecombo.getItem(TAUMakefileTab.this.makecombo.getSelectionIndex());
                TAUMakefileTab.this.updateComboDerivedOptions(TAUMakefileTab.this.selmakefile);
                TAUMakefileTab.this.paneListener.widgetSelected(null);
            } else if (source == TAUMakefileTab.this.papiSelect) {
                TAUMakefileTab.this.handlePapiSelect();
            } else {
                CheckItem[] checkItemArray = TAUMakefileTab.this.checks;
                int n = TAUMakefileTab.this.checks.length;
                int n2 = 0;
                while (n2 < n) {
                    CheckItem check = checkItemArray[n2];
                    if (source == check.unitCheck) {
                        if (((Button)source).getSelection()) {
                            TAUMakefileTab.this.selopts.add(check.makeCmd);
                        } else {
                            TAUMakefileTab.this.selopts.remove(check.makeCmd);
                        }
                        TAUMakefileTab.this.initMakeCombo();
                        TAUMakefileTab.this.reinitMakeChecks();
                    }
                    ++n2;
                }
            }
            TAUMakefileTab.this.paneListener.widgetSelected(null);
        }
    }
}

