/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor_vpg.contentassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.types.DerivedType;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeStmtNode;
import org.eclipse.photran.internal.core.parser.ASTTypeAttrSpecNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.editor.FortranEditor;
import org.eclipse.photran.internal.ui.editor.FortranStmtPartitionScanner;
import org.eclipse.photran.internal.ui.editor.FortranTemplateCompletionProcessor;
import org.eclipse.photran.internal.ui.editor_vpg.FortranEditorTasks;
import org.eclipse.photran.internal.ui.editor_vpg.contentassist.FortranCompletionProcessorASTTask;
import org.eclipse.photran.internal.ui.editor_vpg.contentassist.FortranCompletionProcessorVPGTask;
import org.eclipse.photran.internal.ui.editor_vpg.contentassist.FortranCompletionProposalComputer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class FortranCompletionProcessor
implements IContentAssistProcessor {
    ArrayList<String> scopes = new ArrayList();
    HashMap<String, TreeSet<Definition>> defs = new HashMap();
    private String errorMessage = null;
    private final Color LIGHT_YELLOW = new Color(null, new RGB(255, 255, 223));

    public IContentAssistant setup(FortranEditor editor) {
        String contentAssistEnabledProperty = new SearchPathProperties().getProperty(editor.getIFile(), "EnableContentAssist");
        if (contentAssistEnabledProperty != null && contentAssistEnabledProperty.equals("true")) {
            FortranEditorTasks.instance(editor).addASTTask(new FortranCompletionProcessorASTTask(this));
            FortranEditorTasks.instance(editor).addVPGTask(new FortranCompletionProcessorVPGTask(this));
            ContentAssistant assistant = new ContentAssistant();
            String[] stringArray = FortranStmtPartitionScanner.PARTITION_TYPES;
            int n = FortranStmtPartitionScanner.PARTITION_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String partitionType = stringArray[n2];
                assistant.setContentAssistProcessor((IContentAssistProcessor)this, partitionType);
                ++n2;
            }
            assistant.enableAutoActivation(false);
            assistant.setProposalPopupOrientation(21);
            assistant.setContextInformationPopupBackground(this.LIGHT_YELLOW);
            assistant.setProposalSelectorBackground(this.LIGHT_YELLOW);
            return assistant;
        }
        return null;
    }

    public synchronized ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        FortranCompletionProposalComputer computer = null;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>(256);
        if (this.defs != null) {
            try {
                this.errorMessage = null;
                IDocument document = viewer.getDocument();
                int line = this.determineLineNumberForOffset(offset, document);
                String scopeName = this.determineScopeNameForLine(line);
                FortranCompletionProposalComputer.Context contextType = this.determineContext(offset, line, document);
                List<Definition> classDefs = null;
                if (contextType == FortranCompletionProposalComputer.Context.USE) {
                    classDefs = this.determineModuleNames();
                    if (classDefs.isEmpty()) {
                        classDefs = null;
                    }
                } else if (contextType == FortranCompletionProposalComputer.Context.USE_ONLY) {
                    classDefs = this.determineModuleDefs(offset, line, document, scopeName);
                    if (classDefs.isEmpty()) {
                        classDefs = null;
                    }
                } else {
                    classDefs = this.determineDefsForClass(offset, line, document, scopeName);
                }
                if (scopeName != null) {
                    computer = new FortranCompletionProposalComputer(this.defs, scopeName, document, offset, contextType);
                }
                if (classDefs != null && computer != null) {
                    proposals.addAll(computer.proposalsFromTheseDefs(classDefs));
                } else {
                    if (computer != null) {
                        proposals.addAll(computer.proposalsFromDefs());
                    }
                    ICompletionProposal[] iCompletionProposalArray = new FortranTemplateCompletionProcessor().computeCompletionProposals(viewer, offset);
                    int n = iCompletionProposalArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICompletionProposal proposal = iCompletionProposalArray[n2];
                        proposals.add(proposal);
                        ++n2;
                    }
                    if (computer != null) {
                        proposals.addAll(computer.proposalsFromIntrinsics());
                    }
                }
            }
            catch (Exception e) {
                this.errorMessage = String.valueOf(e.getClass().getName()) + " - " + e.getMessage();
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private final FortranCompletionProposalComputer.Context determineContext(int offset, int line, IDocument document) throws BadLocationException {
        FortranCompletionProposalComputer.Context contextType = FortranCompletionProposalComputer.Context.GENERIC;
        int line_offset = document.getLineOffset(line);
        int cur_length = offset - line_offset;
        String current_line = document.get(line_offset, cur_length);
        current_line = current_line.toLowerCase();
        String keywordList = "[ ]*(class|type|use|allocate|deallocate|nullify)";
        Pattern var_pattern = Pattern.compile(keywordList);
        Matcher matchedKeyword = var_pattern.matcher(current_line);
        String keyword = null;
        if (matchedKeyword.find()) {
            keyword = matchedKeyword.group();
        }
        if (keyword != null) {
            if ((keyword = keyword.replaceAll(" ", "")).matches("class|type")) {
                if (current_line.contains("(") && !current_line.contains(")")) {
                    contextType = FortranCompletionProposalComputer.Context.TYPE_VARIABLE_DEF;
                }
            } else if (keyword.matches("allocate")) {
                if (current_line.contains("(") && !current_line.contains(")")) {
                    contextType = FortranCompletionProposalComputer.Context.ALLOCATE;
                }
            } else if (keyword.matches("deallocate|nullify")) {
                if (current_line.contains("(") && !current_line.contains(")")) {
                    contextType = FortranCompletionProposalComputer.Context.DEALLOCATE;
                }
            } else if (keyword.matches("use")) {
                contextType = !current_line.contains(":") ? FortranCompletionProposalComputer.Context.USE : FortranCompletionProposalComputer.Context.USE_ONLY;
            }
        }
        return contextType;
    }

    private final List<Definition> determineDefsForClass(int offset, int line, IDocument document, String scopeName) throws BadLocationException {
        Iterator identifier;
        String scopeTemp = scopeName;
        ScopingNode parentScope = null;
        List classDefs = null;
        ScopingNode classScope = null;
        int line_offset = document.getLineOffset(line);
        int cur_length = offset - line_offset;
        String current_line = document.get(line_offset, cur_length);
        String prevChar = document.get(offset - 1, 1);
        String current_variable = null;
        Pattern var_pattern = Pattern.compile("[a-zA-Z0-9_%(,)]*");
        Matcher matched_vars = var_pattern.matcher(current_line);
        while (matched_vars.find()) {
            String var_temp = matched_vars.group();
            if (var_temp.equals("")) continue;
            current_variable = matched_vars.group();
        }
        if (current_variable == null) {
            return classDefs;
        }
        if (!current_variable.contains("%") || !current_variable.endsWith(prevChar)) {
            return classDefs;
        }
        int parenLoc = (current_variable = current_variable.replaceAll("\\(([^\\)]+)\\)", "")).lastIndexOf(40);
        if (parenLoc >= 0) {
            current_variable = current_variable.substring(parenLoc + 1);
        }
        String[] sub_fields = current_variable.split("%");
        String base_variable = sub_fields[0].toLowerCase();
        String type_name = null;
        Iterable proposalsToConsider = null;
        while (true) {
            int colon;
            if ((proposalsToConsider = (Iterable)this.defs.get(scopeTemp)) != null) {
                for (Definition def : proposalsToConsider) {
                    Type var_type;
                    if (!def.isLocalVariable() || !((String)((Object)(identifier = def.getCanonicalizedName()))).equals(base_variable) || !((var_type = def.getType()) instanceof DerivedType)) continue;
                    DerivedType typeNode = (DerivedType)var_type;
                    type_name = typeNode.getName();
                    break;
                }
            }
            if (type_name != null || (colon = scopeTemp.indexOf(58)) < 0) break;
            scopeTemp = scopeTemp.substring(colon + 1);
        }
        block3: while (true) {
            int colon;
            if ((proposalsToConsider = (Iterable)this.defs.get(scopeTemp)) != null) {
                for (Definition def : proposalsToConsider) {
                    if (!def.isDerivedType() || !((String)((Object)(identifier = def.getCanonicalizedName()))).equals(type_name)) continue;
                    PhotranTokenRef mytoken = def.getTokenRef();
                    Token mydef = mytoken.getASTNode();
                    parentScope = mydef.getEnclosingScope();
                    classScope = mydef.getLocalScope();
                    classDefs = classScope.getAllDefinitions();
                    if (sub_fields.length <= 1) break block3;
                    break;
                }
            }
            if (classDefs != null || (colon = scopeTemp.indexOf(58)) < 0) break;
            scopeTemp = scopeTemp.substring(colon + 1);
        }
        if (sub_fields.length > 1) {
            int i = 1;
            while (i < sub_fields.length) {
                String identifier2;
                if (sub_fields[i] == "") break;
                proposalsToConsider = classDefs;
                if (proposalsToConsider != null) {
                    for (Definition def : proposalsToConsider) {
                        Type var_type;
                        if (!def.isDerivedTypeComponent() || !(identifier2 = def.getCanonicalizedName()).equals(sub_fields[i].toLowerCase()) || !((var_type = def.getType()) instanceof DerivedType)) continue;
                        DerivedType typeNode = (DerivedType)var_type;
                        type_name = typeNode.getName();
                        break;
                    }
                }
                if ((proposalsToConsider = parentScope.getAllDefinitions()) != null) {
                    for (Definition def : proposalsToConsider) {
                        if (!def.isDerivedType() || !(identifier2 = def.getCanonicalizedName()).equals(type_name)) continue;
                        PhotranTokenRef mytoken = def.getTokenRef();
                        Token mydef = mytoken.getASTNode();
                        List possParents = parentScope.manuallyResolve(mydef);
                        mytoken = (PhotranTokenRef)possParents.get(0);
                        mydef = mytoken.getASTNode();
                        classScope = mydef.getLocalScope();
                        parentScope = mydef.getEnclosingScope();
                        classDefs = classScope.getAllDefinitions();
                        break;
                    }
                }
                ++i;
            }
        }
        if (classScope != null) {
            classDefs = classScope.getAllDefinitions();
            PhotranTokenRef mytoken = null;
            while (true) {
                if (!(classScope instanceof ASTDerivedTypeDefNode)) {
                    continue;
                }
                Token parentClass = null;
                ASTDerivedTypeDefNode typeNode = (ASTDerivedTypeDefNode)classScope;
                ASTDerivedTypeStmtNode typeDef = typeNode.getDerivedTypeStmt();
                IASTListNode defList = typeDef.getTypeAttrSpecList();
                if (defList != null) {
                    for (ASTTypeAttrSpecNode currDef : defList) {
                        if (!currDef.isExtends()) continue;
                        parentClass = currDef.getParentTypeName();
                        List possParents = parentScope.manuallyResolve(parentClass);
                        mytoken = (PhotranTokenRef)possParents.get(0);
                        parentClass = mytoken.getASTNode();
                    }
                }
                if (parentClass == null) break;
                ScopingNode tempScope = parentClass.getLocalScope();
                List tempDefs = tempScope.getAllDefinitions();
                for (Definition newDef : tempDefs) {
                    boolean overridden = false;
                    for (Definition currDef : classDefs) {
                        String currIden = currDef.getCanonicalizedName();
                        if (!currIden.equals(newDef.getCanonicalizedName())) continue;
                        overridden = true;
                    }
                    if (overridden) continue;
                    classDefs.add(newDef);
                }
                classScope = tempScope;
            }
        }
        return classDefs;
    }

    private final List<Definition> determineModuleNames() {
        LinkedList<Definition> moduleDefs = new LinkedList<Definition>();
        PhotranVPG vpg = PhotranVPG.getInstance();
        Iterable moduleNames = vpg.listAllModules();
        for (String module : moduleNames) {
            Definition dummyDef = new Definition(module, null, Definition.Classification.MODULE, Type.VOID);
            moduleDefs.add(dummyDef);
        }
        return moduleDefs;
    }

    private final List<Definition> determineModuleDefs(int offset, int line, IDocument document, String scopeName) throws BadLocationException {
        LinkedList<Definition> moduleDefs = new LinkedList<Definition>();
        int line_offset = document.getLineOffset(line);
        int cur_length = offset - line_offset;
        String current_line = document.get(line_offset, cur_length);
        current_line = current_line.toLowerCase();
        String varChars = "[a-z0-9_]*";
        Pattern var_pattern = Pattern.compile(varChars);
        Matcher matchedKeyword = var_pattern.matcher(current_line);
        String moduleName = null;
        while (matchedKeyword.find()) {
            moduleName = matchedKeyword.group();
            if (!moduleName.matches("use") && !moduleName.isEmpty()) break;
        }
        if (moduleName == null) {
            return moduleDefs;
        }
        PhotranVPG vpg = PhotranVPG.getInstance();
        ArrayList modules = vpg.findAllModulesNamed(moduleName);
        if (modules != null) {
            if (modules.isEmpty() || modules.size() > 1) {
                return moduleDefs;
            }
            Definition module = (Definition)modules.get(0);
            PhotranTokenRef moduleTokenRef = module.getTokenRef();
            Token moduleToken = moduleTokenRef.getASTNode();
            ScopingNode moduleScope = moduleToken.getLocalScope();
            List tempDefs = moduleScope.getAllPublicDefinitions();
            String moduleFile = moduleTokenRef.getFilename();
            for (Definition def : tempDefs) {
                PhotranTokenRef defTokenRef = def.getTokenRef();
                if (!moduleFile.equals(defTokenRef.getFilename())) continue;
                moduleDefs.add(def);
            }
        }
        return moduleDefs;
    }

    private int determineLineNumberForOffset(int offset, IDocument document) throws BadLocationException {
        int line = document.getLineOfOffset(offset);
        if (!this.scopes.isEmpty() && line >= this.scopes.size()) {
            line = this.scopes.size() - 1;
        }
        return line;
    }

    private final String determineScopeNameForLine(int line) {
        String scopeName = "";
        if (line < this.scopes.size()) {
            scopeName = this.scopes.get(line);
        }
        if (scopeName == null) {
            scopeName = "";
        }
        while (scopeName.equals("") && line > 0) {
            if (--line >= this.scopes.size()) continue;
            scopeName = this.scopes.get(line);
        }
        return scopeName;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

