/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.feature;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureInstallHandler;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.feature.CreateFeaturePatchOperation;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class AbstractCreateFeatureOperation
extends WorkspaceModifyOperation {
    protected IProject fProject;
    protected IPath fLocation;
    protected FeatureData fFeatureData;
    private Shell fShell;

    public AbstractCreateFeatureOperation(IProject project, IPath location, FeatureData featureData, Shell shell) {
        this.fProject = project;
        this.fLocation = location;
        this.fFeatureData = featureData;
        this.fShell = shell;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            try {
                this.createFeature(monitor);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void createFeature(IProgressMonitor monitor) throws CoreException {
        IFile file;
        monitor.beginTask(PDEUIMessages.NewFeatureWizard_creatingProject, 3);
        if (this.shouldOverwriteFeature()) {
            this.createProject(monitor);
            monitor.worked(1);
            this.createBuildProperties();
            monitor.worked(1);
            monitor.subTask(PDEUIMessages.NewFeatureWizard_creatingManifest);
            file = this.createFeature();
            monitor.worked(1);
        } else {
            this.fProject.create(monitor);
            this.fProject.open(monitor);
            file = PDEProject.getFeatureXml((IProject)this.fProject);
            monitor.worked(3);
        }
        if (file.exists()) {
            this.openFeatureEditor(file);
        }
    }

    private void createProject(IProgressMonitor monitor) throws CoreException {
        CoreUtility.createProject((IProject)this.fProject, (IPath)this.fLocation, (IProgressMonitor)monitor);
        this.fProject.open(monitor);
        IProjectDescription desc = this.fProject.getWorkspace().newProjectDescription(this.fProject.getName());
        desc.setLocation(this.fLocation);
        if (!this.fProject.hasNature("org.eclipse.pde.FeatureNature")) {
            CoreUtility.addNatureToProject((IProject)this.fProject, (String)"org.eclipse.pde.FeatureNature", (IProgressMonitor)monitor);
        }
        if (this.fFeatureData.hasCustomHandler()) {
            IFolder folder;
            if (!this.fProject.hasNature("org.eclipse.jdt.core.javanature")) {
                CoreUtility.addNatureToProject((IProject)this.fProject, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
            }
            if (this.fFeatureData.getSourceFolderName() != null && this.fFeatureData.getSourceFolderName().trim().length() > 0 && !(folder = this.fProject.getFolder(this.fFeatureData.getSourceFolderName())).exists()) {
                CoreUtility.createFolder((IFolder)folder);
            }
            IJavaProject jproject = JavaCore.create((IProject)this.fProject);
            jproject.setOutputLocation(this.fProject.getFullPath().append(this.fFeatureData.getJavaBuildFolderName()), monitor);
            jproject.setRawClasspath(new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)this.fProject.getFullPath().append(this.fFeatureData.getSourceFolderName())), JavaCore.newContainerEntry((IPath)IPath.fromOSString((String)JavaRuntime.JRE_CONTAINER))}, monitor);
        }
    }

    protected void createBuildProperties() throws CoreException {
        IFile file = PDEProject.getBuildProperties((IProject)this.fProject);
        if (!file.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(file);
            IBuildEntry ientry = model.getFactory().createEntry("bin.includes");
            ientry.addToken("feature.xml");
            String library = this.fFeatureData.library;
            if (library != null) {
                Object output;
                Object source = this.fFeatureData.getSourceFolderName();
                if (source != null) {
                    IBuildEntry entry = model.getFactory().createEntry("source." + library);
                    if (!((String)source).endsWith("/")) {
                        source = (String)source + "/";
                    }
                    entry.addToken((String)source);
                    ientry.addToken(library);
                    model.getBuild().add(entry);
                }
                if ((output = this.fFeatureData.getJavaBuildFolderName()) != null) {
                    IBuildEntry entry = model.getFactory().createEntry("output." + library);
                    if (!((String)output).endsWith("/")) {
                        output = (String)output + "/";
                    }
                    entry.addToken((String)output);
                    model.getBuild().add(entry);
                }
            }
            model.getBuild().add(ientry);
            model.save();
        }
        IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.pde.ui.buildEditor");
    }

    protected IFile createFeature() throws CoreException {
        IFile file = PDEProject.getFeatureXml((IProject)this.fProject);
        WorkspaceFeatureModel model = new WorkspaceFeatureModel();
        model.setFile(file);
        IFeature feature = model.getFeature();
        feature.setLabel(this.fFeatureData.name);
        feature.setId(this.fFeatureData.id);
        feature.setVersion(this.fFeatureData.version);
        feature.setProviderName(this.fFeatureData.provider);
        if (this.fFeatureData.hasCustomHandler()) {
            feature.setInstallHandler(model.getFactory().createInstallHandler());
        }
        this.configureFeature(feature, model);
        IFeatureInstallHandler handler = feature.getInstallHandler();
        if (handler != null) {
            handler.setLibrary(this.fFeatureData.library);
        }
        IFeatureInfo info = model.getFactory().createInfo(1);
        feature.setFeatureInfo(info, 1);
        info.setURL("http://www.example.com/copyright");
        info.setDescription(PDEUIMessages.NewFeatureWizard_sampleCopyrightDesc);
        info = model.getFactory().createInfo(2);
        feature.setFeatureInfo(info, 2);
        info.setURL("http://www.example.com/license");
        info.setDescription(PDEUIMessages.NewFeatureWizard_sampleLicenseDesc);
        info = model.getFactory().createInfo(0);
        feature.setFeatureInfo(info, 0);
        info.setURL("http://www.example.com/description");
        info.setDescription(PDEUIMessages.NewFeatureWizard_sampleDescriptionDesc);
        model.save();
        model.dispose();
        IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.pde.ui.featureEditor");
        return file;
    }

    protected abstract void configureFeature(IFeature var1, WorkspaceFeatureModel var2) throws CoreException;

    protected void openFeatureEditor(IFile manifestFile) {
        IWorkbenchPage page = PDEPlugin.getActivePage();
        StructuredSelection selection = new StructuredSelection((Object)manifestFile);
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            this.fShell.getDisplay().asyncExec(() -> AbstractCreateFeatureOperation.lambda$0(activePart, (ISelection)selection));
        }
        try {
            page.openEditor((IEditorInput)new FileEditorInput(manifestFile), "org.eclipse.pde.ui.featureEditor");
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    protected boolean shouldOverwriteFeature() {
        return !this.fLocation.append(this.fProject.getName()).toFile().exists() || MessageDialog.openQuestion((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)(this instanceof CreateFeaturePatchOperation ? PDEUIMessages.FeaturePatch_wtitle : PDEUIMessages.NewFeatureWizard_wtitle), (String)PDEUIMessages.NewFeatureWizard_overwriteFeature);
    }

    private static /* synthetic */ void lambda$0(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        ((ISetSelectionTarget)iWorkbenchPart).selectReveal(iSelection);
    }
}

