/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.exports.ProductExportOperation;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.product.WorkspaceProductModel;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizard;
import org.eclipse.pde.internal.ui.wizards.exports.CrossPlatformExportPage;
import org.eclipse.pde.internal.ui.wizards.exports.ProductExportWizardPage;
import org.eclipse.pde.internal.ui.wizards.product.SynchronizationOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.IProgressConstants;
import org.osgi.framework.Version;

public class ProductExportWizard
extends BaseExportWizard {
    private static final String STORE_SECTION = "ProductExportWizard";
    private WorkspaceProductModel fProductModel;
    private CrossPlatformExportPage fPage2;
    private ProductExportWizardPage fPage;
    private IProject fProject;

    public ProductExportWizard() {
        this(null);
    }

    public ProductExportWizard(IProject project) {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PRODUCT_EXPORT_WIZ);
        this.fProject = project;
    }

    public void addPages() {
        this.fPage = new ProductExportWizardPage(this.getSelection());
        this.addPage((IWizardPage)this.fPage);
        IFeatureModel model = PDECore.getDefault().getFeatureModelManager().getDeltaPackFeature();
        if (model != null) {
            this.fPage2 = new CrossPlatformExportPage("environment", model);
            this.addPage((IWizardPage)this.fPage2);
        }
    }

    @Override
    protected String getSettingsSectionName() {
        return STORE_SECTION;
    }

    @Override
    protected void scheduleExportJob() {
        FeatureExportInfo info = new FeatureExportInfo();
        info.toDirectory = this.fPage.doExportToDirectory();
        info.exportSource = this.fPage.doExportSource();
        info.exportSourceBundle = this.fPage.doExportSourceBundles();
        info.allowBinaryCycles = this.fPage.doBinaryCycles();
        info.exportMetadata = this.fPage.doExportMetadata();
        info.destinationDirectory = this.fPage.getDestination();
        info.zipFileName = this.fPage.getFileName();
        if (this.fPage2 != null && this.fPage.doMultiPlatform()) {
            info.targets = this.fPage2.getTargets();
        }
        info.items = switch (this.fProductModel.getProduct().getType()) {
            case IProduct.ProductType.FEATURES -> this.getFeatureModels();
            case IProduct.ProductType.BUNDLES -> this.getPluginModels();
            case IProduct.ProductType.MIXED -> throw new IllegalStateException("Exporting mixed products is not (yet) supported");
            default -> throw new IncompatibleClassChangeError();
        };
        String rootDirectory = this.fPage.getRootDirectory();
        if ("".equals(rootDirectory.trim())) {
            rootDirectory = ".";
        }
        ProductExportOperation job = new ProductExportOperation(info, PDEUIMessages.ProductExportJob_name, this.fProductModel.getProduct(), rootDirectory);
        job.setUser(true);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)PDEPluginImages.DESC_FEATURE_OBJ);
    }

    private IFeatureModel[] getFeatureModels() {
        IProductFeature[] features;
        ArrayList<IFeatureModel> list = new ArrayList<IFeatureModel>();
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IProductFeature[] iProductFeatureArray = features = this.fProductModel.getProduct().getFeatures();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IProductFeature feature = iProductFeatureArray[n2];
            IFeatureModel model = manager.findFeatureModel(feature.getId(), feature.getVersion());
            if (model != null) {
                list.add(model);
            }
            ++n2;
        }
        return list.toArray(new IFeatureModel[list.size()]);
    }

    private BundleDescription[] getPluginModels() {
        IProductPlugin[] plugins;
        ArrayList<BundleDescription> list = new ArrayList<BundleDescription>();
        State state = TargetPlatformHelper.getState();
        IProductPlugin[] iProductPluginArray = plugins = this.fProductModel.getProduct().getPlugins();
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            IProductPlugin plugin = iProductPluginArray[n2];
            BundleDescription bundle = null;
            String v = plugin.getVersion();
            if (v != null && v.length() > 0) {
                bundle = state.getBundle(plugin.getId(), Version.parseVersion((String)v));
            }
            if (bundle == null) {
                bundle = state.getBundle(plugin.getId(), null);
            }
            if (bundle != null) {
                list.add(bundle);
            }
            ++n2;
        }
        return list.toArray(new BundleDescription[list.size()]);
    }

    @Override
    protected boolean performPreliminaryChecks() {
        this.fProductModel = new WorkspaceProductModel(this.fPage.getProductFile(), false);
        try {
            this.fProductModel.load();
            if (!this.fProductModel.isLoaded()) {
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)PDEUIMessages.ProductExportWizard_error, (String)PDEUIMessages.ProductExportWizard_corrupt);
                return false;
            }
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)PDEUIMessages.ProductExportWizard_error, (String)PDEUIMessages.ProductExportWizard_corrupt);
            return false;
        }
        if (this.fPage.doSync()) {
            try {
                this.getContainer().run(false, false, (IRunnableWithProgress)new SynchronizationOperation(this.fProductModel.getProduct(), this.getContainer().getShell(), this.fProject));
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)PDEUIMessages.ProductExportWizard_syncTitle, (String)e.getTargetException().getMessage());
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean confirmDelete() {
        File zipFile;
        if (!this.fPage.doExportToDirectory() && (zipFile = new File(this.fPage.getDestination(), this.fPage.getFileName())).exists()) {
            if (!MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)PDEUIMessages.BaseExportWizard_confirmReplace_title, (String)NLS.bind((String)PDEUIMessages.BaseExportWizard_confirmReplace_desc, (Object)zipFile.getAbsolutePath()))) {
                return false;
            }
            zipFile.delete();
        }
        return true;
    }

    public boolean canFinish() {
        return this.fPage.getNextPage() != null ? super.canFinish() : this.fPage.isPageComplete();
    }
}

