/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.RemoteTargetHandle;
import org.eclipse.pde.internal.core.target.TargetReferenceBundleContainer;
import org.eclipse.pde.internal.core.target.WorkspaceFileTargetHandle;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.shared.target.IEditBundleContainerPage;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EditTargetContainerPage
extends WizardPage
implements IEditBundleContainerPage {
    protected static final int TYPING_DELAY = 200;
    protected Combo furiLocation;
    protected TargetReferenceBundleContainer fContainer;
    private static final String SETTINGS_LOCATION_1 = "location1";
    private static final String SETTINGS_LOCATION_2 = "location2";
    private static final String SETTINGS_LOCATION_3 = "location3";
    private ITargetDefinition targetDefinition;

    public EditTargetContainerPage(ITargetDefinition targetDefinition, TargetReferenceBundleContainer container) {
        super("EditTargetContainerPage");
        this.targetDefinition = targetDefinition;
        this.fContainer = container;
    }

    public void createControl(Composite parent) {
        this.setMessage(this.getDefaultMessage());
        this.setTitle(this.getDefaultTitle());
        this.setPageComplete(false);
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        this.createLocationArea(comp);
        this.setControl((Control)comp);
        this.initializeInputFields((ITargetLocation)this.fContainer);
    }

    protected String getDefaultTitle() {
        if (this.fContainer == null) {
            return Messages.EditTargetContainerPage_Add_Title;
        }
        return Messages.EditTargetContainerPage_Edit_Title;
    }

    protected String getDefaultMessage() {
        return Messages.EditTargetContainerPage_Message;
    }

    protected void createLocationArea(Composite parent) {
        Composite locationComp = SWTFactory.createComposite(parent, 2, 1, 768, 0, 0);
        SWTFactory.createLabel(locationComp, Messages.AddDirectoryContainerPage_2, 1);
        this.furiLocation = SWTFactory.createCombo(locationComp, 2048, 1, this.getLocationComboItems());
        this.furiLocation.addModifyListener(e -> this.setPageComplete(this.validateInput()));
        try {
            String location = this.fContainer != null ? this.fContainer.getLocation(false) : "";
            this.furiLocation.setText(location);
        }
        catch (CoreException e2) {
            this.setErrorMessage(e2.getMessage());
        }
        Composite buttonComp = SWTFactory.createComposite(locationComp, 2, 2, 2, 0, 0);
        GridData gd = (GridData)buttonComp.getLayoutData();
        gd.horizontalAlignment = 131072;
        Button variablesButton = SWTFactory.createPushButton(buttonComp, Messages.EditDirectoryContainerPage_1, null);
        variablesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
            dialog.open();
            String variable = dialog.getVariableExpression();
            if (variable != null) {
                this.furiLocation.setText(this.furiLocation.getText() + variable);
            }
        }));
    }

    protected void initializeInputFields(ITargetLocation container) {
        try {
            String[] items;
            String currentLocation = this.fContainer != null ? this.fContainer.getLocation(false) : "";
            boolean found = false;
            String[] stringArray = items = this.furiLocation.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.equals(currentLocation)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                this.furiLocation.add(currentLocation);
            }
            this.furiLocation.setText(currentLocation);
            this.setPageComplete(this.validateInput());
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
    }

    public boolean isPageComplete() {
        return !this.furiLocation.getText().isBlank();
    }

    private String[] getLocationComboItems() {
        ITargetHandle handle;
        ArrayList<String> previousLocations = new ArrayList<String>(4);
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String location = settings.get(SETTINGS_LOCATION_1);
            if (location != null) {
                previousLocations.add(location);
            }
            if ((location = settings.get(SETTINGS_LOCATION_2)) != null) {
                previousLocations.add(location);
            }
            if ((location = settings.get(SETTINGS_LOCATION_3)) != null) {
                previousLocations.add(location);
            }
        }
        if ((handle = this.targetDefinition.getHandle()) instanceof WorkspaceFileTargetHandle) {
            WorkspaceFileTargetHandle wsHandle = (WorkspaceFileTargetHandle)handle;
            String name = wsHandle.getTargetFile().getProject().getName();
            previousLocations.add(String.format("file:${project_loc:/%s}/", name));
            ITargetHandle[] iTargetHandleArray = ((ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class)).getTargets((IProgressMonitor)new NullProgressMonitor());
            int n = iTargetHandleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile targetFile;
                String location;
                ITargetHandle targetHandle = iTargetHandleArray[n2];
                if (!handle.equals(targetHandle) && targetHandle instanceof WorkspaceFileTargetHandle && !previousLocations.contains(location = String.format("file:${project_loc:/%s}/%s", (targetFile = ((WorkspaceFileTargetHandle)targetHandle).getTargetFile()).getProject().getName(), targetFile.getProjectRelativePath())) && !this.alreadyContains(location)) {
                    previousLocations.add(location);
                }
                ++n2;
            }
        }
        return previousLocations.toArray(new String[previousLocations.size()]);
    }

    private boolean alreadyContains(String location) {
        boolean alreadyContains = false;
        if (this.targetDefinition.getTargetLocations() != null) {
            ITargetLocation[] containers;
            ITargetLocation[] iTargetLocationArray = containers = this.targetDefinition.getTargetLocations();
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation targetLoc = iTargetLocationArray[n2];
                String uri = null;
                try {
                    uri = targetLoc.getLocation(false);
                }
                catch (CoreException coreException) {}
                if (uri != null && uri.equals(location)) {
                    alreadyContains = true;
                    break;
                }
                ++n2;
            }
        }
        return alreadyContains;
    }

    @Override
    public void storeSettings() {
        String[] items;
        String newLocation = this.furiLocation.getText().trim();
        int length = newLocation.length();
        if (length > 0 && newLocation.charAt(length - 1) == File.separatorChar) {
            newLocation = newLocation.substring(0, length - 1);
        }
        String[] stringArray = items = this.furiLocation.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(newLocation)) {
                return;
            }
            ++n2;
        }
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String location = settings.get(SETTINGS_LOCATION_2);
            if (location != null) {
                settings.put(SETTINGS_LOCATION_3, location);
            }
            if ((location = settings.get(SETTINGS_LOCATION_1)) != null) {
                settings.put(SETTINGS_LOCATION_2, location);
            }
            settings.put(SETTINGS_LOCATION_1, newLocation);
        }
    }

    @Override
    public ITargetLocation getBundleContainer() {
        return this.fContainer;
    }

    protected boolean validateInput() {
        URI location;
        if (this.furiLocation.isDisposed()) {
            return false;
        }
        if (this.furiLocation.getText().trim().length() == 0) {
            this.setMessage(this.getDefaultMessage());
            return false;
        }
        try {
            location = RemoteTargetHandle.getEffectiveUri((String)this.furiLocation.getText().trim());
        }
        catch (CoreException e) {
            this.setMessage(e.getMessage(), 2);
            return true;
        }
        catch (URISyntaxException e) {
            this.setMessage(e.getMessage(), 3);
            return false;
        }
        try {
            File file;
            URL url = location.toURL();
            if ("file".equalsIgnoreCase(url.getProtocol()) && !(file = new File(location)).isFile()) {
                this.setMessage(NLS.bind((String)Messages.EditTargetContainerPage_Not_A_File, (Object)file.getAbsolutePath()), 3);
                return true;
            }
        }
        catch (RuntimeException | MalformedURLException e) {
            this.setMessage(e.getMessage(), 3);
            return false;
        }
        this.setMessage(this.getDefaultMessage());
        return true;
    }
}

