/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.ILauncherFormPageHelper;
import org.eclipse.pde.internal.ui.editor.LaunchShortcutOverviewPage;
import org.eclipse.pde.internal.ui.editor.PDELauncherFormEditor;
import org.eclipse.pde.internal.ui.editor.product.DependenciesPage;
import org.eclipse.pde.internal.ui.editor.product.GeneralInfoSection;
import org.eclipse.pde.internal.ui.editor.product.ProductExportAction;
import org.eclipse.pde.internal.ui.editor.product.ProductInfoSection;
import org.eclipse.pde.internal.ui.editor.product.ProductLauncherFormPageHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class OverviewPage
extends LaunchShortcutOverviewPage {
    public static final String PAGE_ID = "overview";
    private ProductLauncherFormPageHelper fLauncherHelper;

    public OverviewPage(PDELauncherFormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.OverviewPage_title);
    }

    @Override
    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.overview_page";
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(PDEUIMessages.OverviewPage_title);
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PRODUCT_DEFINITION));
        this.fillBody(managedForm, toolkit);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.overview_page");
    }

    private void fillBody(IManagedForm managedForm, FormToolkit toolkit) {
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout(true, 2));
        GeneralInfoSection generalSection = new GeneralInfoSection(this, body);
        ProductInfoSection productSection = new ProductInfoSection(this, body);
        managedForm.addPart((IFormPart)generalSection);
        managedForm.addPart((IFormPart)productSection);
        if (this.getModel().isEditable()) {
            this.createTestingSection(body, toolkit);
            this.createExportingSection(body, toolkit);
        }
    }

    private void createTestingSection(Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(toolkit, parent, PDEUIMessages.Product_OverviewPage_testing);
        FormText text = this.createClient((Composite)section, this.getLauncherText(this.getLauncherHelper().isOSGi(), PDEUIMessages.Product_overview_testing), toolkit);
        PDELabelProvider lp = PDEPlugin.getDefault().getLabelProvider();
        text.setImage("run", lp.get(PDEPluginImages.DESC_RUN_EXC));
        text.setImage("debug", lp.get(PDEPluginImages.DESC_DEBUG_EXC));
        text.setImage("profile", lp.get(PDEPluginImages.DESC_PROFILE_EXC));
        section.setClient((Control)text);
    }

    private void createExportingSection(Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(toolkit, parent, PDEUIMessages.OverviewPage_exportingTitle);
        section.setClient((Control)this.createClient((Composite)section, PDEUIMessages.Product_overview_exporting, toolkit));
    }

    @Override
    public void linkActivated(HyperlinkEvent e) {
        String href;
        switch (href = (String)e.getHref()) {
            case "action.synchronize": {
                ((ProductLauncherFormPageHelper)this.getLauncherHelper()).handleSynchronize(true);
                break;
            }
            case "action.export": {
                if (this.getPDEEditor().isDirty()) {
                    this.getPDEEditor().doSave(null);
                }
                new ProductExportAction(this.getPDEEditor()).run();
                break;
            }
            case "configuration": {
                IProduct product = ((ProductLauncherFormPageHelper)this.getLauncherHelper()).getProduct();
                this.getEditor().setActivePage(DependenciesPage.TYPE_2_ID.get(product.getType()));
                break;
            }
            case "multi-platform-wiki": {
                OverviewPage.openBrowser("https://wiki.eclipse.org/Building#Cross-platform_build");
                break;
            }
            default: {
                super.linkActivated(e);
            }
        }
    }

    private static void openBrowser(String url) {
        IWebBrowser browser;
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            browser = support.createBrowser(null);
        }
        catch (PartInitException e) {
            PDEPlugin.log(e);
            return;
        }
        try {
            browser.openURL(new URL(url));
        }
        catch (MalformedURLException | PartInitException e) {
            PDEPlugin.log(e);
        }
    }

    protected ILauncherFormPageHelper getLauncherHelper() {
        if (this.fLauncherHelper == null) {
            this.fLauncherHelper = new ProductLauncherFormPageHelper(this.getPDELauncherEditor());
        }
        return this.fLauncherHelper;
    }

    @Override
    protected short getIndent() {
        return 35;
    }
}

