/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.builders.DependencyLoop;
import org.eclipse.pde.internal.core.builders.DependencyLoopFinder;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.plugin.LoopDialog;
import org.eclipse.pde.internal.ui.search.dependencies.UnusedDependenciesAction;
import org.eclipse.pde.internal.ui.views.dependencies.OpenPluginDependenciesAction;
import org.eclipse.pde.internal.ui.views.dependencies.OpenPluginReferencesAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DependencyAnalysisSection
extends PDESection {
    public DependencyAnalysisSection(PDEFormPage page, Composite parent, int style) {
        super(page, parent, 0x102 | style);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    private String getFormText() {
        IBaseModel model = this.getPage().getModel();
        if (model == null) {
            return "";
        }
        if (model instanceof IPluginModel) {
            return model.isEditable() ? PDEUIMessages.DependencyAnalysisSection_plugin_editable : PDEUIMessages.DependencyAnalysisSection_plugin_notEditable;
        }
        return model.isEditable() ? PDEUIMessages.DependencyAnalysisSection_fragment_editable : PDEUIMessages.DependencyAnalysisSection_fragment_notEditable;
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.DependencyAnalysisSection_title);
        FormText formText = toolkit.createFormText((Composite)section, true);
        formText.setText(this.getFormText(), true, false);
        PDELabelProvider lp = PDEPlugin.getDefault().getLabelProvider();
        formText.setImage("loops", lp.get(PDEPluginImages.DESC_LOOP_OBJ));
        formText.setImage("search", lp.get(PDEPluginImages.DESC_PSEARCH_OBJ));
        formText.setImage("hierarchy", lp.get(PDEPluginImages.DESC_CALLEES));
        formText.setImage("dependencies", lp.get(PDEPluginImages.DESC_CALLERS));
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IBaseModel iBaseModel = DependencyAnalysisSection.this.getPage().getModel();
                if (iBaseModel instanceof IPluginModelBase) {
                    IPluginModelBase iPluginModelBase = (IPluginModelBase)iBaseModel;
                    IPluginModelBase cfr_ignored_0 = (IPluginModelBase)iBaseModel;
                    if (e.getHref().equals("unused")) {
                        new UnusedDependenciesAction((IPluginModelBase)pluginModel, false).run();
                    } else if (e.getHref().equals("loops")) {
                        DependencyAnalysisSection.this.doFindLoops((IPluginModelBase)pluginModel);
                    } else {
                        IPluginModelBase plugin = DependencyAnalysisSection.this.getStatePlugin((IPluginModelBase)pluginModel);
                        if (e.getHref().equals("references")) {
                            new OpenPluginReferencesAction(plugin).run();
                        } else if (e.getHref().equals("hierarchy")) {
                            new OpenPluginDependenciesAction(plugin).run();
                        }
                    }
                }
            }
        });
        section.setClient((Control)formText);
    }

    private IPluginModelBase getStatePlugin(IPluginModelBase pluginModel) {
        IPluginBase pluginBase = pluginModel.getPluginBase();
        return PluginRegistry.findModel((String)pluginBase.getId(), (String)pluginBase.getVersion(), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private void doFindLoops(IPluginModelBase pluginModelBase) {
        IPluginModelBase iPluginModelBase = pluginModelBase;
        if (iPluginModelBase instanceof IPluginModel) {
            void pluginModel;
            IPluginModel iPluginModel = (IPluginModel)iPluginModelBase;
            IPluginModel cfr_ignored_0 = (IPluginModel)iPluginModelBase;
            DependencyLoop[] loops = DependencyLoopFinder.findLoops((IPlugin)pluginModel.getPlugin());
            if (loops.length == 0) {
                MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.DependencyAnalysisSection_loops, (String)PDEUIMessages.DependencyAnalysisSection_noCycles);
            } else {
                LoopDialog dialog = new LoopDialog(PDEPlugin.getActiveWorkbenchShell(), loops);
                dialog.open();
            }
        }
    }
}

