/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.sourcelookup;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.ArchiveSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ExternalArchiveSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.WorkspaceSourceContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaSourceLookupParticipant;
import org.eclipse.pde.core.IBundleClasspathResolver;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDEClasspathContainer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.launching.launcher.VMHelper;
import org.eclipse.pde.internal.launching.sourcelookup.PDESourceLookupQuery;

public class PDESourceLookupDirector
extends AbstractSourceLookupDirector {
    private Map<String, List<ISourceContainer>> fSourceContainerMap = new LinkedHashMap<String, List<ISourceContainer>>();
    private ISourceContainer[] fJreSourceContainers;
    private static Set<String> fFilteredTypes = new HashSet<String>(3);
    private double fOSGiRuntimeVersion = Double.MIN_VALUE;

    static {
        fFilteredTypes.add(ProjectSourceContainer.TYPE_ID);
        fFilteredTypes.add(WorkspaceSourceContainer.TYPE_ID);
        fFilteredTypes.add("org.eclipse.debug.ui.containerType.workingSet");
    }

    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new JavaSourceLookupParticipant()});
    }

    public boolean supportsSourceContainerType(ISourceContainerType type) {
        return !fFilteredTypes.contains(type.getId());
    }

    public Object getSourceElement(Object element) {
        PDESourceLookupQuery query = new PDESourceLookupQuery(this, element);
        SafeRunner.run((ISafeRunnable)query);
        Object result = query.getResult();
        return result != null ? result : super.getSourceElement(element);
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        Object[] sourceElements = null;
        if (object instanceof IJavaStackFrame || object instanceof IJavaObject || object instanceof IJavaReferenceType) {
            sourceElements = new Object[]{this.getSourceElement(object)};
        }
        if (sourceElements == null) {
            sourceElements = super.findSourceElements(object);
        }
        return sourceElements;
    }

    List<ISourceContainer> getSourceContainers(String location, String id) throws CoreException {
        IPluginModelBase[] models;
        List<ISourceContainer> containers = this.fSourceContainerMap.get(location);
        if (containers != null) {
            return containers;
        }
        ArrayList<IRuntimeClasspathEntry> result = new ArrayList<IRuntimeClasspathEntry>();
        ModelEntry entry = PluginRegistry.findEntry((String)id);
        if (entry == null) {
            return Collections.emptyList();
        }
        boolean match = false;
        IPluginModelBase[] iPluginModelBaseArray = models = entry.getWorkspaceModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            if (this.isPerfectMatch(model, IPath.fromOSString((String)location))) {
                IResource resource = model.getUnderlyingResource();
                if (resource != null) {
                    this.addProjectSourceContainers(resource.getProject(), result);
                }
                match = true;
                break;
            }
            ++n2;
        }
        if (!match) {
            ISourceContainer container;
            File file = new File(location);
            if (file.isFile() && (container = this.getArchiveSourceContainer(location)) != null) {
                containers = List.of(container);
                this.fSourceContainerMap.put(location, containers);
                return containers;
            }
            IPluginModelBase[] iPluginModelBaseArray2 = models = entry.getExternalModels();
            int n3 = models.length;
            n = 0;
            while (n < n3) {
                IPluginModelBase model = iPluginModelBaseArray2[n];
                if (this.isPerfectMatch(model, IPath.fromOSString((String)location))) {
                    IClasspathEntry[] entries;
                    IClasspathEntry[] iClasspathEntryArray = entries = PDEClasspathContainer.getExternalEntries((IPluginModelBase)model);
                    int n4 = entries.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IClasspathEntry entrie = iClasspathEntryArray[n5];
                        IRuntimeClasspathEntry rte = this.convertClasspathEntry(entrie);
                        if (rte != null) {
                            result.add(rte);
                        }
                        ++n5;
                    }
                    break;
                }
                ++n;
            }
        }
        IRuntimeClasspathEntry[] entries = (IRuntimeClasspathEntry[])result.toArray(IRuntimeClasspathEntry[]::new);
        containers = List.of(JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])entries));
        this.fSourceContainerMap.put(location, containers);
        return containers;
    }

    ISourceContainer[] getJreSourceContainers() throws CoreException {
        if (this.fJreSourceContainers != null) {
            return this.fJreSourceContainers;
        }
        IRuntimeClasspathEntry unresolvedJreEntry = VMHelper.getJREEntry(this.getLaunchConfiguration());
        IRuntimeClasspathEntry[] resolvedJreEntries = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)unresolvedJreEntry, (ILaunchConfiguration)this.getLaunchConfiguration());
        this.fJreSourceContainers = JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolvedJreEntries);
        return this.fJreSourceContainers;
    }

    private boolean isPerfectMatch(IPluginModelBase model, IPath path) {
        return model == null ? false : path.equals((Object)IPath.fromOSString((String)model.getInstallLocation()));
    }

    private IRuntimeClasspathEntry convertClasspathEntry(IClasspathEntry entry) {
        if (entry == null) {
            return null;
        }
        IPath srcPath = entry.getSourceAttachmentPath();
        if (srcPath != null && srcPath.segmentCount() > 0) {
            IRuntimeClasspathEntry rte = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)entry.getPath());
            rte.setSourceAttachmentPath(srcPath);
            rte.setSourceAttachmentRootPath(entry.getSourceAttachmentRootPath());
            return rte;
        }
        return null;
    }

    private ISourceContainer getArchiveSourceContainer(String location) throws JavaModelException {
        IFile[] containers;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] iFileArray = containers = root.findFilesForLocationURI(URIUtil.toURI((String)location));
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot archive;
            IPath path;
            IFile container = iFileArray[n2];
            IJavaElement element = JavaCore.create((IFile)container);
            if (element instanceof IPackageFragmentRoot && (path = (archive = (IPackageFragmentRoot)element).getSourceAttachmentPath()) != null && path.segmentCount() != 0) {
                IPath rootPath = archive.getSourceAttachmentRootPath();
                boolean detectRootPath = rootPath != null && rootPath.segmentCount() > 0;
                IFile archiveFile = root.getFile(path);
                if (archiveFile.exists()) {
                    return new ArchiveSourceContainer(archiveFile, detectRootPath);
                }
                File file = path.toFile();
                if (file.exists()) {
                    return new ExternalArchiveSourceContainer(file.getAbsolutePath(), detectRootPath);
                }
            }
            ++n2;
        }
        return null;
    }

    private void addProjectSourceContainers(IProject project, List<IRuntimeClasspathEntry> result) throws CoreException {
        IBundleClasspathResolver[] resolvers;
        IClasspathEntry[] entries;
        if (project == null || !project.hasNature("org.eclipse.jdt.core.javanature")) {
            return;
        }
        IJavaProject jProject = JavaCore.create((IProject)project);
        result.add(JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)jProject));
        IClasspathEntry[] iClasspathEntryArray = entries = jProject.getRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry rte;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 1 && (rte = this.convertClasspathEntry(entry)) != null) {
                result.add(rte);
            }
            ++n2;
        }
        IBundleClasspathResolver[] iBundleClasspathResolverArray = resolvers = PDECore.getDefault().getClasspathContainerResolverManager().getBundleClasspathResolvers(project);
        int n3 = resolvers.length;
        n = 0;
        while (n < n3) {
            IBundleClasspathResolver resolver = iBundleClasspathResolverArray[n];
            result.addAll(resolver.getAdditionalSourceEntries(jProject));
            ++n;
        }
    }

    public synchronized void dispose() {
        this.fSourceContainerMap.values().stream().flatMap(Collection::stream).forEach(ISourceContainer::dispose);
        this.fSourceContainerMap.clear();
        super.dispose();
    }

    double getOSGiRuntimeVersion() {
        if (this.fOSGiRuntimeVersion == Double.MIN_VALUE) {
            this.fOSGiRuntimeVersion = TargetPlatformHelper.getTargetVersion();
        }
        return this.fOSGiRuntimeVersion;
    }
}

