/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;

public class IncludedSchemaDescriptor
implements ISchemaDescriptor {
    private final URL fSchemaURL;
    private String fSchemaLocation;
    private Schema fSchema;
    private long fLastModified;

    public IncludedSchemaDescriptor(URL schemaURL) {
        this.fSchemaURL = schemaURL;
        File file = new File(this.fSchemaURL.getFile());
        if (file.exists()) {
            this.fLastModified = file.lastModified();
        }
    }

    public static URL computeURL(ISchemaDescriptor parentDesc, String schemaLocation, List<IPath> additionalSearchLocations) throws MalformedURLException {
        URL parentURL;
        URL uRL = parentURL = parentDesc == null ? null : parentDesc.getSchemaURL();
        if (schemaLocation.startsWith("schema://")) {
            IPath path = IPath.fromOSString((String)schemaLocation.substring(9));
            return IncludedSchemaDescriptor.getPluginRelativePath(path.segment(0), path.removeFirstSegments(1), parentURL, additionalSearchLocations);
        }
        if (parentURL == null) {
            return null;
        }
        IPath path = IPath.fromOSString((String)parentURL.getPath());
        path = path.removeLastSegments(1).append(schemaLocation);
        return new URL(parentURL.getProtocol(), parentURL.getHost(), path.toString());
    }

    private static URL getPluginRelativePath(String pluginID, IPath path, URL parentURL, List<IPath> additionalSearchPath) {
        IPluginModelBase model;
        URL url = SchemaRegistry.getSchemaURL(pluginID, path.toString());
        if (url == null && (model = PluginRegistry.findModel(pluginID)) != null) {
            url = SchemaRegistry.getSchemaFromSourceExtension(model.getPluginBase(), path);
        }
        File parentFile = null;
        if (url == null && parentURL != null) {
            try {
                parentFile = URIUtil.toFile((URI)URIUtil.toURI((URL)parentURL));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        if (url == null && parentFile != null) {
            try {
                File schemaFile;
                File pluginFile = new File(String.valueOf(parentFile) + "/../../../" + pluginID);
                if (pluginFile.isDirectory() && (schemaFile = new File(pluginFile, path.toOSString())).exists()) {
                    url = schemaFile.toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (url == null && additionalSearchPath != null) {
            for (IPath searchPath : additionalSearchPath) {
                File pluginFile = null;
                if (searchPath.isAbsolute()) {
                    pluginFile = new File(searchPath.toFile(), pluginID);
                } else if (parentFile != null) {
                    File file = new File(parentFile, searchPath.toOSString());
                    pluginFile = new File(file, pluginID);
                }
                if (pluginFile == null || !pluginFile.isDirectory()) continue;
                try {
                    File schemaFile = new File(pluginFile, path.toOSString());
                    if (!schemaFile.exists()) continue;
                    url = schemaFile.toURL();
                    break;
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return url;
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getPointId() {
        int dotLoc = this.fSchemaLocation.lastIndexOf(46);
        if (dotLoc != -1) {
            return this.fSchemaLocation.substring(0, dotLoc);
        }
        return null;
    }

    @Override
    public URL getSchemaURL() {
        return this.fSchemaURL;
    }

    @Override
    public ISchema getSchema(boolean abbreviated) {
        if (this.fSchema == null && this.fSchemaURL != null) {
            this.fSchema = new Schema(this, this.fSchemaURL, abbreviated);
            this.fSchema.load();
        }
        return this.fSchema;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public long getLastModified() {
        return this.fLastModified;
    }
}

