/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.ui.delegate;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.pivot.internal.delegate.OCLValidationDelegate;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;

public class OCLDebugValidationDelegate
extends OCLValidationDelegate {
    public OCLDebugValidationDelegate(@NonNull OCLDelegateDomain delegateDomain, @NonNull EClassifier classifier) {
        super(delegateDomain, classifier);
    }

    protected boolean validateExpressionInOCL(@NonNull EClassifier eClassifier, final @NonNull Object value, final @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, String constraintName, final String source, final int code, @NonNull ExpressionInOCL query) {
        OCLValidationDelegate.CheckingConstraintEvaluator constraintEvaluator = new OCLValidationDelegate.CheckingConstraintEvaluator(eClassifier, query){

            protected String getObjectLabel() {
                return NameUtil.qualifiedNameFor((Object)value);
            }

            protected Boolean handleFailureResult(@Nullable Object result) {
                if (result == null) {
                    String message = this.getConstraintResultMessage(result);
                    throw new OCLDelegateException((Exception)new EvaluationException(message));
                }
                if (diagnostics != null) {
                    String message = this.getConstraintResultMessage(result);
                    int severity = this.getConstraintResultSeverity(result);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(severity, source, code, message, new Object[]{value}));
                }
                return Boolean.FALSE;
            }
        };
        OCL ocl = this.delegateDomain.getOCL();
        EvaluationVisitor evaluationVisitor = ocl.createEvaluationVisitor(value, query);
        return (Boolean)constraintEvaluator.evaluate(evaluationVisitor);
    }
}

