/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db.ddl.delta;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.net4j.db.ddl.delta.IDBDelta;
import org.eclipse.net4j.db.ddl.delta.IDBFieldDelta;
import org.eclipse.net4j.db.ddl.delta.IDBIndexDelta;
import org.eclipse.net4j.db.ddl.delta.IDBIndexFieldDelta;
import org.eclipse.net4j.db.ddl.delta.IDBPropertyDelta;
import org.eclipse.net4j.db.ddl.delta.IDBSchemaDelta;
import org.eclipse.net4j.db.ddl.delta.IDBTableDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBDeltaWithProperties;
import org.eclipse.net4j.internal.db.ddl.delta.DBFieldDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBIndexDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBIndexFieldDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBPropertyDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBSchemaDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBTableDelta;
import org.eclipse.net4j.util.collection.Pair;

public interface IDBDeltaVisitor {
    public void visit(IDBSchemaDelta var1);

    public void visit(IDBTableDelta var1);

    public void visit(IDBFieldDelta var1);

    public void visit(IDBIndexDelta var1);

    public void visit(IDBIndexFieldDelta var1);

    public void visit(IDBPropertyDelta<?> var1);

    public static class Copier
    extends Filter {
        private DBSchemaDelta result;

        public Copier() {
        }

        public Copier(Filter.Policy policy) {
            super(policy);
        }

        public final IDBSchemaDelta getResult() {
            return this.result;
        }

        @Override
        protected void doVisit(IDBSchemaDelta delta) {
            this.result = new DBSchemaDelta(delta.getName(), delta.getChangeKind());
        }

        @Override
        protected void doVisit(IDBTableDelta delta) {
            DBTableDelta copy = new DBTableDelta((DBDelta)this.result, delta.getName(), delta.getChangeKind());
            this.result.addTableDelta(copy);
        }

        @Override
        protected void doVisit(IDBFieldDelta delta) {
            DBTableDelta parentCopy = (DBTableDelta)this.getParentCopy(delta);
            DBFieldDelta copy = new DBFieldDelta((DBDelta)parentCopy, delta.getName(), delta.getChangeKind());
            parentCopy.addFieldDelta(copy);
        }

        @Override
        protected void doVisit(IDBIndexDelta delta) {
            DBTableDelta parentCopy = (DBTableDelta)this.getParentCopy(delta);
            DBIndexDelta copy = new DBIndexDelta((DBDelta)parentCopy, delta.getName(), delta.getChangeKind());
            parentCopy.addIndexDelta(copy);
        }

        @Override
        protected void doVisit(IDBIndexFieldDelta delta) {
            DBIndexDelta parentCopy = (DBIndexDelta)this.getParentCopy(delta);
            DBIndexFieldDelta copy = new DBIndexFieldDelta((DBDelta)parentCopy, delta.getName(), delta.getChangeKind());
            parentCopy.addIndexFieldDelta(copy);
        }

        @Override
        protected void doVisit(IDBPropertyDelta<?> delta) {
            DBDeltaWithProperties parentCopy = (DBDeltaWithProperties)this.getParentCopy(delta);
            DBPropertyDelta copy = new DBPropertyDelta(parentCopy, delta.getName(), delta.getType(), delta.getValue(), delta.getOldValue());
            parentCopy.addPropertyDelta(copy);
        }

        private <T extends DBDelta> T getParentCopy(IDBDelta delta) {
            if (this.result == null) {
                throw new IllegalStateException("Copier can only be accepted by schema deltas");
            }
            DBDelta parent = (DBDelta)delta.getParent();
            IDBDelta.DeltaType deltaType = parent.getDeltaType();
            switch (deltaType) {
                case SCHEMA: {
                    return (T)this.result;
                }
                case TABLE: {
                    return (T)this.result.getTableDelta(parent.getName());
                }
                case FIELD: {
                    return (T)this.result.getTableDelta(parent.getParent().getName()).getFieldDelta(parent.getName());
                }
                case INDEX: {
                    return (T)this.result.getTableDelta(parent.getParent().getName()).getIndexDelta(parent.getName());
                }
                case INDEX_FIELD: {
                    return (T)this.result.getTableDelta(parent.getParent().getParent().getName()).getIndexDelta(parent.getParent().getName()).getIndexFieldDelta(parent.getName());
                }
            }
            throw new IllegalStateException("Illegal delta type: " + (Object)((Object)deltaType));
        }
    }

    public static class Default
    implements IDBDeltaVisitor {
        @Override
        public void visit(IDBSchemaDelta delta) {
            block6: {
                block5: {
                    if (!this.handle(delta)) break block5;
                    IDBDelta.ChangeKind changeKind = delta.getChangeKind();
                    switch (changeKind) {
                        case ADD: {
                            this.added(delta);
                            break block6;
                        }
                        case REMOVE: {
                            this.removed(delta);
                            break block6;
                        }
                        case CHANGE: {
                            this.changed(delta);
                            break block6;
                        }
                        default: {
                            throw Default.illegalChangeKind(changeKind);
                        }
                    }
                }
                this.stopRecursion();
            }
        }

        protected void added(IDBSchemaDelta delta) {
            this.visitDefault(delta);
        }

        protected void removed(IDBSchemaDelta delta) {
            this.visitDefault(delta);
        }

        protected void changed(IDBSchemaDelta delta) {
            this.visitDefault(delta);
        }

        @Override
        public void visit(IDBTableDelta delta) {
            block6: {
                block5: {
                    if (!this.handle(delta)) break block5;
                    IDBDelta.ChangeKind changeKind = delta.getChangeKind();
                    switch (changeKind) {
                        case ADD: {
                            this.added(delta);
                            break block6;
                        }
                        case REMOVE: {
                            this.removed(delta);
                            break block6;
                        }
                        case CHANGE: {
                            this.changed(delta);
                            break block6;
                        }
                        default: {
                            throw Default.illegalChangeKind(changeKind);
                        }
                    }
                }
                this.stopRecursion();
            }
        }

        protected void added(IDBTableDelta delta) {
            this.visitDefault(delta);
        }

        protected void removed(IDBTableDelta delta) {
            this.visitDefault(delta);
        }

        protected void changed(IDBTableDelta delta) {
            this.visitDefault(delta);
        }

        @Override
        public void visit(IDBFieldDelta delta) {
            block6: {
                block5: {
                    if (!this.handle(delta)) break block5;
                    IDBDelta.ChangeKind changeKind = delta.getChangeKind();
                    switch (changeKind) {
                        case ADD: {
                            this.added(delta);
                            break block6;
                        }
                        case REMOVE: {
                            this.removed(delta);
                            break block6;
                        }
                        case CHANGE: {
                            this.changed(delta);
                            break block6;
                        }
                        default: {
                            throw Default.illegalChangeKind(changeKind);
                        }
                    }
                }
                this.stopRecursion();
            }
        }

        protected void added(IDBFieldDelta delta) {
            this.visitDefault(delta);
        }

        protected void removed(IDBFieldDelta delta) {
            this.visitDefault(delta);
        }

        protected void changed(IDBFieldDelta delta) {
            this.visitDefault(delta);
        }

        @Override
        public void visit(IDBIndexDelta delta) {
            block6: {
                block5: {
                    if (!this.handle(delta)) break block5;
                    IDBDelta.ChangeKind changeKind = delta.getChangeKind();
                    switch (changeKind) {
                        case ADD: {
                            this.added(delta);
                            break block6;
                        }
                        case REMOVE: {
                            this.removed(delta);
                            break block6;
                        }
                        case CHANGE: {
                            this.changed(delta);
                            break block6;
                        }
                        default: {
                            throw Default.illegalChangeKind(changeKind);
                        }
                    }
                }
                this.stopRecursion();
            }
        }

        protected void added(IDBIndexDelta delta) {
            this.visitDefault(delta);
        }

        protected void removed(IDBIndexDelta delta) {
            this.visitDefault(delta);
        }

        protected void changed(IDBIndexDelta delta) {
            this.visitDefault(delta);
        }

        @Override
        public void visit(IDBIndexFieldDelta delta) {
            block6: {
                block5: {
                    if (!this.handle(delta)) break block5;
                    IDBDelta.ChangeKind changeKind = delta.getChangeKind();
                    switch (changeKind) {
                        case ADD: {
                            this.added(delta);
                            break block6;
                        }
                        case REMOVE: {
                            this.removed(delta);
                            break block6;
                        }
                        case CHANGE: {
                            this.changed(delta);
                            break block6;
                        }
                        default: {
                            throw Default.illegalChangeKind(changeKind);
                        }
                    }
                }
                this.stopRecursion();
            }
        }

        protected void added(IDBIndexFieldDelta delta) {
            this.visitDefault(delta);
        }

        protected void removed(IDBIndexFieldDelta delta) {
            this.visitDefault(delta);
        }

        protected void changed(IDBIndexFieldDelta delta) {
            this.visitDefault(delta);
        }

        @Override
        public void visit(IDBPropertyDelta<?> delta) {
            block6: {
                block5: {
                    if (!this.handle(delta)) break block5;
                    IDBDelta.ChangeKind changeKind = delta.getChangeKind();
                    switch (changeKind) {
                        case ADD: {
                            this.added(delta);
                            break block6;
                        }
                        case REMOVE: {
                            this.removed(delta);
                            break block6;
                        }
                        case CHANGE: {
                            this.changed(delta);
                            break block6;
                        }
                        default: {
                            throw Default.illegalChangeKind(changeKind);
                        }
                    }
                }
                this.stopRecursion();
            }
        }

        protected void added(IDBPropertyDelta<?> delta) {
            this.visitDefault(delta);
        }

        protected void removed(IDBPropertyDelta<?> delta) {
            this.visitDefault(delta);
        }

        protected void changed(IDBPropertyDelta<?> delta) {
            this.visitDefault(delta);
        }

        protected void visitDefault(IDBDelta delta) {
        }

        protected boolean handle(IDBDelta delta) {
            return true;
        }

        protected final void stopRecursion() {
            throw new StopRecursion();
        }

        public static RuntimeException illegalChangeKind(IDBDelta.ChangeKind changeKind) {
            return new IllegalStateException("Illegal change kind: " + (Object)((Object)changeKind));
        }
    }

    public static class Filter
    extends Default {
        public static final Policy DEFAULT_POLICY = new Policy().allowAll().freeze();
        private Policy policy;

        public Filter() {
            this(null);
        }

        public Filter(Policy policy) {
            this.policy = policy == null ? DEFAULT_POLICY : policy;
        }

        public final Policy getPolicy() {
            return this.policy;
        }

        @Override
        protected void added(IDBSchemaDelta delta) {
            this.doVisit(delta);
        }

        @Override
        protected void added(IDBTableDelta delta) {
            this.doVisit(delta);
        }

        @Override
        protected void added(IDBFieldDelta delta) {
            this.doVisit(delta);
        }

        @Override
        protected void added(IDBIndexDelta delta) {
            this.doVisit(delta);
        }

        @Override
        protected void added(IDBIndexFieldDelta delta) {
            this.doVisit(delta);
        }

        @Override
        protected void added(IDBPropertyDelta<?> delta) {
            this.doVisit(delta);
        }

        @Override
        protected void removed(IDBSchemaDelta delta) {
            this.doVisit(delta);
        }

        @Override
        protected void removed(IDBTableDelta delta) {
            this.doVisit(delta);
        }

        @Override
        protected void removed(IDBFieldDelta delta) {
            this.doVisit(delta);
        }

        @Override
        protected void removed(IDBIndexDelta delta) {
            this.doVisit(delta);
        }

        @Override
        protected void removed(IDBIndexFieldDelta delta) {
            this.doVisit(delta);
        }

        @Override
        protected void removed(IDBPropertyDelta<?> delta) {
            this.doVisit(delta);
        }

        @Override
        protected void changed(IDBSchemaDelta delta) {
            this.doVisit(delta);
        }

        @Override
        protected void changed(IDBTableDelta delta) {
            this.doVisit(delta);
        }

        @Override
        protected void changed(IDBFieldDelta delta) {
            this.doVisit(delta);
        }

        @Override
        protected void changed(IDBIndexDelta delta) {
            this.doVisit(delta);
        }

        @Override
        protected void changed(IDBIndexFieldDelta delta) {
            this.doVisit(delta);
        }

        @Override
        protected void changed(IDBPropertyDelta<?> delta) {
            this.doVisit(delta);
        }

        protected void doVisit(IDBSchemaDelta delta) {
            this.visitDefault(delta);
        }

        protected void doVisit(IDBTableDelta delta) {
            this.visitDefault(delta);
        }

        protected void doVisit(IDBFieldDelta delta) {
            this.visitDefault(delta);
        }

        protected void doVisit(IDBIndexDelta delta) {
            this.visitDefault(delta);
        }

        protected void doVisit(IDBIndexFieldDelta delta) {
            this.visitDefault(delta);
        }

        protected void doVisit(IDBPropertyDelta<?> delta) {
            this.visitDefault(delta);
        }

        @Override
        protected final boolean handle(IDBDelta delta) {
            if (this.policy.isForbidden(delta)) {
                throw new ForbiddenChangeException(delta);
            }
            return this.policy.isAllowed(delta);
        }

        public static final class ForbiddenChangeException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            private final IDBDelta delta;

            public ForbiddenChangeException(IDBDelta delta) {
                super("Forbidden change: " + delta);
                this.delta = delta;
            }

            public IDBDelta getDelta() {
                return this.delta;
            }
        }

        public static final class Policy
        implements Serializable {
            public static final Object ALLOWED = "ALLOWED";
            public static final Object FORBIDDEN = "FORBIDDEN";
            public static final Object IGNORED = "IGNORED";
            private static final long serialVersionUID = 1L;
            private Map<Object, Object> clauses = new HashMap<Object, Object>();
            private transient boolean frozen;

            public boolean isAllowed(IDBDelta.DeltaType deltaType) {
                Object value = this.clauses.get((Object)deltaType);
                return value == ALLOWED;
            }

            public boolean isAllowed(IDBDelta.ChangeKind changeKind) {
                Object value = this.clauses.get((Object)changeKind);
                return value == ALLOWED;
            }

            public boolean isAllowed(IDBDelta.DeltaType deltaType, IDBDelta.ChangeKind changeKind) {
                Object value = this.clauses.get(Pair.create((Object)((Object)deltaType), (Object)((Object)changeKind)));
                if (value == null && (value = this.clauses.get((Object)deltaType)) == null) {
                    value = this.clauses.get((Object)changeKind);
                }
                return value == ALLOWED;
            }

            public boolean isAllowed(IDBDelta delta) {
                return this.isAllowed(delta.getDeltaType(), delta.getChangeKind());
            }

            public boolean isForbidden(IDBDelta.DeltaType deltaType) {
                Object value = this.clauses.get((Object)deltaType);
                return value == FORBIDDEN;
            }

            public boolean isForbidden(IDBDelta.ChangeKind changeKind) {
                Object value = this.clauses.get((Object)changeKind);
                return value == FORBIDDEN;
            }

            public boolean isForbidden(IDBDelta.DeltaType deltaType, IDBDelta.ChangeKind changeKind) {
                Object value = this.clauses.get(Pair.create((Object)((Object)deltaType), (Object)((Object)changeKind)));
                if (value == null && (value = this.clauses.get((Object)deltaType)) == null) {
                    value = this.clauses.get((Object)changeKind);
                }
                return value == FORBIDDEN;
            }

            public boolean isForbidden(IDBDelta delta) {
                return this.isForbidden(delta.getDeltaType(), delta.getChangeKind());
            }

            public boolean isIgnored(IDBDelta.DeltaType deltaType) {
                Object value = this.clauses.get((Object)deltaType);
                return value == null || value == IGNORED;
            }

            public boolean isIgnored(IDBDelta.ChangeKind changeKind) {
                Object value = this.clauses.get((Object)changeKind);
                return value == null || value == IGNORED;
            }

            public boolean isIgnored(IDBDelta.DeltaType deltaType, IDBDelta.ChangeKind changeKind) {
                Object value = this.clauses.get(Pair.create((Object)((Object)deltaType), (Object)((Object)changeKind)));
                if (value == null && (value = this.clauses.get((Object)deltaType)) == null) {
                    value = this.clauses.get((Object)changeKind);
                }
                return value == null || value == IGNORED;
            }

            public boolean isIgnored(IDBDelta delta) {
                return this.isIgnored(delta.getDeltaType(), delta.getChangeKind());
            }

            public Policy allow(IDBDelta.DeltaType deltaType) {
                return this.addClause((Object)deltaType, ALLOWED);
            }

            public Policy allow(IDBDelta.ChangeKind changeKind) {
                return this.addClause((Object)changeKind, ALLOWED);
            }

            public Policy allow(IDBDelta.DeltaType deltaType, IDBDelta.ChangeKind changeKind) {
                return this.addClause(Pair.create((Object)((Object)deltaType), (Object)((Object)changeKind)), ALLOWED);
            }

            public Policy allowAll() {
                return this.ignoreAll().allow(IDBDelta.ChangeKind.ADD).allow(IDBDelta.ChangeKind.REMOVE).allow(IDBDelta.ChangeKind.CHANGE);
            }

            public Policy forbid(IDBDelta.DeltaType deltaType) {
                return this.addClause((Object)deltaType, FORBIDDEN);
            }

            public Policy forbid(IDBDelta.ChangeKind changeKind) {
                return this.addClause((Object)changeKind, FORBIDDEN);
            }

            public Policy forbid(IDBDelta.DeltaType deltaType, IDBDelta.ChangeKind changeKind) {
                return this.addClause(Pair.create((Object)((Object)deltaType), (Object)((Object)changeKind)), FORBIDDEN);
            }

            public Policy forbidAll() {
                return this.ignoreAll().forbid(IDBDelta.ChangeKind.ADD).forbid(IDBDelta.ChangeKind.REMOVE).forbid(IDBDelta.ChangeKind.CHANGE);
            }

            public Policy ignore(IDBDelta.DeltaType deltaType) {
                return this.removeClause((Object)deltaType);
            }

            public Policy ignore(IDBDelta.ChangeKind changeKind) {
                return this.removeClause((Object)changeKind);
            }

            public Policy ignore(IDBDelta.DeltaType deltaType, IDBDelta.ChangeKind changeKind) {
                return this.removeClause(Pair.create((Object)((Object)deltaType), (Object)((Object)changeKind)));
            }

            public Policy ignoreAll() {
                this.checkFrozen();
                this.clauses.clear();
                return this;
            }

            public String toString() {
                return "Policy" + this.clauses;
            }

            public Policy freeze() {
                this.frozen = true;
                return this;
            }

            private void checkFrozen() {
                if (this.frozen) {
                    throw new IllegalStateException("Policy is frozen: " + this);
                }
            }

            private Policy addClause(Object key, Object value) {
                this.checkFrozen();
                this.clauses.put(key, value);
                return this;
            }

            private Policy removeClause(Object key) {
                this.checkFrozen();
                this.clauses.remove(key);
                return this;
            }
        }
    }

    public static final class StopRecursion
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

