/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.migrator;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.internal.tasks.ui.migrator.ConnectorMigrator;
import org.eclipse.mylyn.internal.tasks.ui.migrator.Messages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;

public class ConnectorMigrationWizard
extends Wizard {
    private Object[] selectedConnectors = new Object[0];
    private final ConnectorMigrator migrator;

    public ConnectorMigrationWizard(ConnectorMigrator migrator) {
        this.migrator = migrator;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.setWindowTitle(Messages.ConnectorMigrationWizard_Connector_Migration);
        this.addPage((IWizardPage)new WizardPage(Messages.ConnectorMigrationWizard_End_of_Connector_Support){

            public void createControl(Composite parent) {
                this.setTitle(Messages.ConnectorMigrationWizard_End_of_Connector_Support);
                this.setMessage(Messages.ConnectorMigrationWizard_Message, 1);
                Composite c = new Composite(parent, 0);
                GridLayoutFactory.fillDefaults().applyTo(c);
                Link text = new Link(c, 74);
                text.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        BrowserUtil.openUrl((String)e.text, (int)128);
                    }
                });
                text.setText(NLS.bind((String)Messages.ConnectorMigrationWizard_Body, (Object)ConnectorMigrationWizard.this.migrator.getExplanatoryText()));
                GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(600, -1).applyTo((Control)text);
                this.setControl((Control)c);
            }
        });
        this.addPage((IWizardPage)new WizardPage(Messages.ConnectorMigrationWizard_Select_Connectors){

            public void createControl(Composite parent) {
                this.setTitle(Messages.ConnectorMigrationWizard_Select_Connectors);
                this.setDescription(Messages.ConnectorMigrationWizard_Select_the_connectors_to_migrate);
                Composite c = new Composite(parent, 0);
                GridLayoutFactory.fillDefaults().applyTo(c);
                List<String> kinds = ConnectorMigrationWizard.this.getRelevantConnectorKinds(ConnectorMigrationWizard.this.migrator.getConnectorKinds().keySet());
                final CheckboxTreeViewer viewer = ConnectorMigrationWizard.this.createConnectorList(c, kinds);
                ConnectorMigrationWizard.this.selectedConnectors = kinds.toArray();
                viewer.setCheckedElements(ConnectorMigrationWizard.this.selectedConnectors);
                viewer.addCheckStateListener(new ICheckStateListener(){

                    public void checkStateChanged(CheckStateChangedEvent event) {
                        (this).ConnectorMigrationWizard.this.selectedConnectors = viewer.getCheckedElements();
                        this.setPageComplete((this).ConnectorMigrationWizard.this.selectedConnectors.length > 0);
                    }
                });
                GridDataFactory.fillDefaults().grab(true, true).applyTo(viewer.getControl());
                this.setControl((Control)c);
            }

            public boolean isPageComplete() {
                return super.isPageComplete() && this.isCurrentPage();
            }
        });
    }

    protected CheckboxTreeViewer createConnectorList(Composite parent, List<String> kinds) {
        CheckboxTreeViewer viewer = new CheckboxTreeViewer(parent);
        viewer.setContentProvider((IContentProvider)new CollectionContentProvider());
        viewer.setInput(kinds);
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    String kind = (String)element;
                    IRepositoryManager manager = ConnectorMigrationWizard.this.migrator.getRepositoryManager();
                    AbstractRepositoryConnector connector = manager.getRepositoryConnector(kind);
                    if (connector != null) {
                        return String.valueOf(connector.getLabel()) + NLS.bind((String)Messages.ConnectorMigrationWizard_used_by_X_repositories, (Object)manager.getRepositories(kind).size());
                    }
                }
                return super.getText(element);
            }
        });
        return viewer;
    }

    private List<String> getRelevantConnectorKinds(Set<String> connectorKinds) {
        IRepositoryManager manager = this.migrator.getRepositoryManager();
        LinkedList<String> relevantConnectorKinds = new LinkedList<String>();
        for (String connectorKind : connectorKinds) {
            if (manager.getRepositories(connectorKind).isEmpty()) continue;
            relevantConnectorKinds.add(connectorKind);
        }
        return relevantConnectorKinds;
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ImmutableList connectors = FluentIterable.from((Iterable)ImmutableList.copyOf((Object[])ConnectorMigrationWizard.this.selectedConnectors)).filter(String.class).toList();
                    try {
                        ConnectorMigrationWizard.this.migrator.setConnectorsToMigrate((List<String>)connectors);
                        ConnectorMigrationWizard.this.migrator.migrateConnectors(monitor);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", e.getMessage(), (Throwable)e));
            IWizardPage page = this.getContainer().getCurrentPage();
            if (page instanceof WizardPage && e.getCause() != null) {
                ((WizardPage)page).setErrorMessage(e.getCause().getMessage());
            }
            return false;
        }
        return true;
    }

    private static class CollectionContentProvider
    implements ITreeContentProvider {
        private CollectionContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

