/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.inspections.ReferenceQuery;
import org.eclipse.mat.inspections.util.ObjectTreeFactory;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.snapshot.inspections.MultiplePath2GCRootsQuery;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.snapshot.IMultiplePathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.IPathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.MultiplePathsFromGCRootsClassRecord;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleMonitor;

@CommandName(value="reference_leak")
@Icon(value="/META-INF/icons/reference.gif")
@Subject(value="java.lang.ref.Reference")
public class ReferenceLeakQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument
    public IQueryContext context;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    static final String DEFAULT_REFERENT = "referent";
    @Argument(isMandatory=false)
    public String referent_attribute = "referent";
    @Argument(isMandatory=false)
    public int maxresults = 5;
    @Argument(isMandatory=false)
    public int maxpaths = 100;
    @Argument(isMandatory=false)
    public int maxobjs = 0;
    @Argument(isMandatory=false)
    public double factor = 0.8;

    public IResult execute(IProgressListener listener) throws Exception {
        IMultiplePathsFromGCRootsComputer computer;
        CompositeResult results = new CompositeResult(new IResult[0]);
        Set<String> fields = Collections.singleton(this.referent_attribute);
        HashMap<IClass, Set<String>> allExcludeMap = new HashMap<IClass, Set<String>>();
        ArrayInt ai = new ArrayInt();
        int[] commonpath = null;
        MultiplePathsFromGCRootsClassRecord dummy = new MultiplePathsFromGCRootsClassRecord(null, -1, true, this.snapshot);
        int nobjs = 0;
        for (int[] objs : this.objects) {
            nobjs += objs.length;
        }
        SimpleMonitor sm = new SimpleMonitor(Messages.ReferenceLeakQuery_ComputingReferentLeaks, listener, new int[]{400, 100});
        listener = sm.nextMonitor();
        listener.beginTask(Messages.ReferenceLeakQuery_ExaminingReferenceObjects, this.maxobjs > 0 ? this.maxobjs : nobjs);
        int iobjs = 0;
        int eobjs = 0;
        int errs = 0;
        for (int[] objs : this.objects) {
            int ii = 0;
            while (ii < objs.length) {
                block28: {
                    if (this.maxobjs <= 0 || !(Math.random() * (double)(nobjs - iobjs) >= (double)(this.maxobjs - eobjs))) {
                        IInstance obj;
                        ObjectReference ref;
                        ++eobjs;
                        IObject o = this.snapshot.getObject(objs[ii]);
                        if (o instanceof IInstance && (ref = ReferenceQuery.getReferent(obj = (IInstance)o, this.referent_attribute)) != null) {
                            int suspect;
                            try {
                                suspect = ref.getObjectId();
                            }
                            catch (SnapshotException e) {
                                if (++errs <= 20) {
                                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.ReferenceLeakQuery_ErrorReadingReference, (Object[])new Object[]{obj, this.referent_attribute, ref}), (Throwable)e);
                                }
                                --eobjs;
                                break block28;
                            }
                            HashMap<IClass, Set<String>> excludeMap = new HashMap<IClass, Set<String>>();
                            excludeMap.put(obj.getClazz(), fields);
                            allExcludeMap.put(obj.getClazz(), fields);
                            IPathsFromGCRootsComputer path = this.snapshot.getPathsFromGCRoots(suspect, excludeMap);
                            int count = 0;
                            int[] p1 = path.getNextShortestPath();
                            block5: while (p1 != null && count < this.maxpaths) {
                                int ip = 0;
                                while (ip < p1.length) {
                                    int p = p1[ip];
                                    if (listener.isCanceled()) {
                                        throw new IProgressListener.OperationCanceledException();
                                    }
                                    if (p == obj.getObjectId()) {
                                        int i;
                                        ai.add(suspect);
                                        ObjectTreeFactory.TreePathBuilder builder = new ObjectTreeFactory.TreePathBuilder();
                                        builder.setIsOutgoing();
                                        builder.addBranch(p1[p1.length - 1]);
                                        int j = p1.length - 2;
                                        while (j >= 0) {
                                            if (j + 1 == ip) {
                                                builder.addSibling(suspect, true);
                                            }
                                            builder.addChild(p1[j], j == ip || j == 0);
                                            --j;
                                        }
                                        if (commonpath == null) {
                                            commonpath = new int[p1.length];
                                            i = 0;
                                            while (i < p1.length) {
                                                commonpath[i] = p1[p1.length - 1 - i];
                                                ++i;
                                            }
                                        } else {
                                            i = 0;
                                            while (i < commonpath.length) {
                                                if (p1.length - 1 - i < 0 || commonpath[i] != p1[p1.length - 1 - i]) {
                                                    commonpath = Arrays.copyOf(commonpath, i);
                                                }
                                                ++i;
                                            }
                                        }
                                        dummy.addPath(p1);
                                        if (ai.size() > this.maxresults) break block5;
                                        IResultTree t1 = builder.build(this.snapshot);
                                        String title = MessageUtil.format((String)Messages.ReferenceLeakQuery_TwoPaths, (Object[])new Object[]{ref.getObject().getDisplayName(), o.getDisplayName()});
                                        results.addResult(title, (IResult)t1);
                                        break block5;
                                    }
                                    ++ip;
                                }
                                p1 = path.getNextShortestPath();
                                ++count;
                            }
                        }
                        listener.worked(1);
                        if (listener.isCanceled()) {
                            throw new IProgressListener.OperationCanceledException();
                        }
                    }
                }
                ++ii;
                ++iobjs;
            }
        }
        listener.done();
        listener = sm.nextMonitor();
        if (ai.size() == 0) {
            TextResult child = new TextResult(MessageUtil.format((String)Messages.ReferenceLeakQuery_NoStrongPaths, (Object[])new Object[]{eobjs}));
            results.addResult((IResult)child);
        }
        if (ai.size() == 1) {
            computer = this.snapshot.getMultiplePathsFromGCRoots(ai.toArray(), allExcludeMap);
            Object[] allpaths = computer.getAllPaths(listener);
            if (allpaths.length >= 1 && allpaths[0] instanceof int[]) {
                int[] path1 = (int[])allpaths[0];
                int[] path2 = new int[path1.length];
                int i = 0;
                while (i < path1.length) {
                    path2[i] = path1[path1.length - 1 - i];
                    ++i;
                }
                commonpath = path2;
            }
            MultiplePath2GCRootsQuery.Tree rt = MultiplePath2GCRootsQuery.create(this.snapshot, computer, commonpath, listener);
            results.addResult(Messages.ReferenceLeakQuery_PathToReferent, (IResult)rt);
        }
        if (ai.size() > 1) {
            Object[] allPaths;
            computer = this.snapshot.getMultiplePathsFromGCRoots(ai.toArray(), allExcludeMap);
            dummy = new MultiplePathsFromGCRootsClassRecord(null, -1, true, this.snapshot);
            Object[] objectArray = allPaths = computer.getAllPaths(listener);
            int i = allPaths.length;
            int path2 = 0;
            while (path2 < i) {
                Object path = objectArray[path2];
                dummy.addPath((int[])path);
                ++path2;
            }
            int numPaths = dummy.getCount();
            MultiplePathsFromGCRootsClassRecord[] classRecords = dummy.nextLevel();
            double threshold = (double)numPaths * this.factor;
            ArrayList<IClass> referencePattern = new ArrayList<IClass>();
            Arrays.sort(classRecords, MultiplePathsFromGCRootsClassRecord.getComparatorByNumberOfReferencedObjects());
            MultiplePathsFromGCRootsClassRecord r = classRecords[0];
            while ((double)r.getCount() > threshold) {
                threshold = (double)r.getCount() * this.factor;
                referencePattern.add(r.getClazz());
                classRecords = r.nextLevel();
                if (classRecords == null || classRecords.length == 0) break;
                Arrays.sort(classRecords, MultiplePathsFromGCRootsClassRecord.getComparatorByNumberOfReferencedObjects());
                r = classRecords[0];
            }
            int[] expandedClasses = new int[referencePattern.size()];
            int i2 = 0;
            while (i2 < referencePattern.size()) {
                expandedClasses[i2] = ((IClass)referencePattern.get(i2)).getObjectId();
                ++i2;
            }
            MultiplePath2GCRootsQuery.Tree rt = MultiplePath2GCRootsQuery.create(this.snapshot, computer, expandedClasses, true, listener);
            String message = eobjs < nobjs ? MessageUtil.format((String)Messages.ReferenceLeakQuery_CommonPathsLimit, (Object[])new Object[]{eobjs}) : Messages.ReferenceLeakQuery_CommonPaths;
            results.addResult(message, (IResult)rt);
        }
        listener.done();
        return results;
    }
}

