/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.views.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.internal.builder.BuildDebugHook;
import org.eclipse.m2e.core.internal.builder.MavenBuilder;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.views.build.CollectionNode;
import org.eclipse.m2e.core.ui.internal.views.build.ContainerNode;
import org.eclipse.m2e.core.ui.internal.views.build.MojoExecutionNode;
import org.eclipse.m2e.core.ui.internal.views.build.Node;
import org.eclipse.m2e.core.ui.internal.views.build.ProjectNode;
import org.eclipse.m2e.core.ui.internal.views.build.ResourceNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class BuildDebugView
extends ViewPart
implements BuildDebugHook {
    static final Comparator<Node> NODE_COMPARATOR = Comparator.comparingInt(Node::getBuildCount).reversed().thenComparing(Node::getName);
    TreeViewer viewer;
    final Object projectsLock = new Object(){};
    final Map<String, ProjectNode> projects = new ConcurrentHashMap<String, ProjectNode>();
    final Job refreshJob = new Job(""){

        protected IStatus run(IProgressMonitor monitor) {
            BuildDebugView.this.getSite().getShell().getDisplay().asyncExec(() -> BuildDebugView.this.viewer.refresh());
            return Status.OK_STATUS;
        }
    };
    volatile boolean suspended = true;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.viewer, 0);
        TreeColumn trclmnName = treeViewerColumn.getColumn();
        trclmnName.setWidth(400);
        trclmnName.setText(Messages.BuildDebugView_columnName);
        TreeViewerColumn treeViewerColumn_1 = new TreeViewerColumn(this.viewer, 0);
        TreeColumn trclmnBuildCount = treeViewerColumn_1.getColumn();
        trclmnBuildCount.setWidth(100);
        trclmnBuildCount.setText(Messages.BuildDebugView_columnBuildNumber);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof Node var3_4) {
                    return this.getColumnText((Node)node, columnIndex);
                }
                if (columnIndex == 0) {
                    return element.toString();
                }
                return null;
            }

            private String getColumnText(Node element, int columnIndex) {
                return switch (columnIndex) {
                    case 0 -> element.getName();
                    case 1 -> Integer.toString(element.getBuildCount());
                    default -> null;
                };
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                if (element instanceof ContainerNode var2_3) {
                    return !containerNode.getResources().isEmpty();
                }
                if (element instanceof CollectionNode var5_5) {
                    return !collectionNode.getMembers().isEmpty();
                }
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object[] getElements(Object inputElement) {
                if (inputElement == BuildDebugView.this.projects) {
                    ArrayList<ProjectNode> sorted;
                    Object object = BuildDebugView.this.projectsLock;
                    synchronized (object) {
                        sorted = new ArrayList<ProjectNode>(BuildDebugView.this.projects.values());
                    }
                    Collections.sort(sorted, NODE_COMPARATOR);
                    return sorted.toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof ProjectNode var2_3) {
                    ArrayList<CollectionNode<Node>> result = new ArrayList<CollectionNode<Node>>();
                    ArrayList<ResourceNode> resources = new ArrayList<ResourceNode>(projectNode.getResources());
                    if (!resources.isEmpty()) {
                        Collections.sort(resources, NODE_COMPARATOR);
                        result.add(new CollectionNode<ResourceNode>(Messages.BuildDebugView_nodeDelta, resources));
                    }
                    if (!(executions = new ArrayList<MojoExecutionNode>(projectNode.getMojoExecutions())).isEmpty()) {
                        Collections.sort(executions, NODE_COMPARATOR);
                        result.add(new CollectionNode<MojoExecutionNode>(Messages.BuildDebugView_nodeExecutions, executions));
                    }
                    return result.toArray();
                }
                if (parentElement instanceof CollectionNode result) {
                    return collectionNode.getMembers().toArray();
                }
                if (parentElement instanceof ContainerNode var8_10) {
                    return containerNode.getResources().toArray();
                }
                return null;
            }
        });
        this.viewer.setInput(this.projects);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        Action suspendAction = new Action(Messages.BuildDebugView_actionSuspend, 2){

            public void run() {
                BuildDebugView.this.suspended = this.isChecked();
            }
        };
        suspendAction.setImageDescriptor(MavenImages.SUSPEND);
        suspendAction.setChecked(this.suspended);
        Action clearAction = new Action(Messages.BuildDebugView_actionClear, MavenImages.CLEAR){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = BuildDebugView.this.projectsLock;
                synchronized (object) {
                    BuildDebugView.this.projects.clear();
                }
                BuildDebugView.this.refreshJob.schedule();
            }
        };
        Action collapseAll = new Action(Messages.BuildDebugView_actionCollapseAll, MavenImages.COLLAPSEALL){

            public void run() {
                BuildDebugView.this.viewer.collapseAll();
            }
        };
        toolBar.add((IAction)collapseAll);
        toolBar.add((IAction)clearAction);
        toolBar.add((IAction)suspendAction);
        actionBars.updateActionBars();
    }

    public void setFocus() {
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        MavenBuilder.addDebugHook((BuildDebugHook)this);
    }

    public void dispose() {
        MavenBuilder.removeDebugHook((BuildDebugHook)this);
        super.dispose();
    }

    public void buildStart(IMavenProjectFacade projectFacade, int kind, Map<String, String> args, Map<MojoExecutionKey, List<AbstractBuildParticipant>> participants, IResourceDelta delta, IProgressMonitor monitor) {
        if (this.suspended) {
            return;
        }
        ProjectNode projectNode = this.getProjectNode(projectFacade);
        int buildCount = projectNode.incrementBuildCount();
        try {
            if (delta != null) {
                delta.accept(delta1 -> {
                    IResource resource;
                    if (delta1.getAffectedChildren().length == 0 && ((resource = delta1.getResource()) instanceof IFile || resource instanceof IFolder)) {
                        projectNode.addResource(resource.getProjectRelativePath()).setBuildCount(buildCount);
                    }
                    return true;
                });
            }
            this.refreshJob.schedule(1000L);
        }
        catch (CoreException ex) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.BuildDebugView_errorTitle, (String)Messages.BuildDebugView_errorDescription, (IStatus)ex.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectNode getProjectNode(IMavenProjectFacade projectFacade) {
        Object object = this.projectsLock;
        synchronized (object) {
            IProject project = projectFacade.getProject();
            ProjectNode projectNode = this.projects.get(project.getName());
            if (projectNode == null) {
                projectNode = new ProjectNode(project.getName());
                this.projects.put(project.getName(), projectNode);
            }
            return projectNode;
        }
    }

    public void buildParticipant(IMavenProjectFacade projectFacade, MojoExecutionKey mojoExecutionKey, AbstractBuildParticipant participant, Set<File> files, IProgressMonitor monitor) {
        if (this.suspended || files == null || files.isEmpty()) {
            return;
        }
        ProjectNode projectNode = this.getProjectNode(projectFacade);
        int buildCount = projectNode.getBuildCount();
        MojoExecutionNode executionNode = projectNode.getMojoExecutionNode(mojoExecutionKey);
        executionNode.setBuildCount(buildCount);
        for (File file : files) {
            executionNode.addResource(projectFacade.getProjectRelativePath(file.getAbsolutePath())).setBuildCount(buildCount);
        }
    }
}

