/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDESessionSettings;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.handlers.Messages;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.ExceptionErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class AddStapProbeHandler
extends AbstractHandler {
    /*
     * WARNING - void declaration
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object chars;
        ITextEditor editor;
        try {
            editor = (ITextEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        }
        catch (ClassCastException e) {
            ExceptionErrorDialog.openError((String)Messages.AddStapProbe_unableToInsertProbe, (String)Messages.AddStapProbe_editorError, (Exception)e);
            throw new ExecutionException(Messages.AddStapProbe_editorError, (Throwable)e);
        }
        IVerticalRulerInfo rulerInfo = (IVerticalRulerInfo)editor.getAdapter(IVerticalRulerInfo.class);
        Shell shell = editor.getSite().getShell();
        shell.setCursor(shell.getDisplay().getSystemCursor(1));
        int lineno = rulerInfo.getLineOfLastMouseButtonActivity();
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        String s = document.get();
        String[] lines = s.split("\n");
        String line = lines[lineno].trim();
        boolean die = false;
        if (line.isEmpty()) {
            die = true;
        }
        if (line.startsWith("#")) {
            die = true;
        }
        if (line.startsWith("//")) {
            die = true;
        }
        if (line.startsWith("/*") && !line.contains("*/") && !line.endsWith("*/")) {
            die = true;
        }
        try {
            ArrayList<Integer> commentChunks = new ArrayList<Integer>();
            chars = s.toCharArray();
            int needle = 1;
            int offset = document.getLineOffset(lineno);
            while (needle < ((char[])chars).length) {
                if (chars[needle - 1] == '/' && chars[needle] == '*') {
                    commentChunks.add(needle);
                    while (needle < ((char[])chars).length) {
                        if (chars[needle - 1] == '*' && chars[needle] == '/') {
                            commentChunks.add(needle);
                            ++needle;
                            break;
                        }
                        ++needle;
                    }
                }
                ++needle;
            }
            int i = 0;
            while (i < commentChunks.size()) {
                if ((Integer)commentChunks.get(i) >= offset) {
                    int pair = i - i % 2;
                    int start = (Integer)commentChunks.get(pair);
                    int end = (Integer)commentChunks.get(pair + 1);
                    if (offset >= start && offset <= end) {
                        die = true;
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException excp) {
            ExceptionErrorDialog.openError((String)Messages.AddStapProbe_unableToInsertProbe, (Exception)((Object)excp));
            return null;
        }
        if (die) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.CEditor_probeInsertFailed, (String)Messages.CEditor_canNotProbeLine);
        } else {
            IEditorInput in = editor.getEditorInput();
            IEditorInput iEditorInput = in;
            if (iEditorInput instanceof FileStoreEditorInput) {
                void input;
                chars = (FileStoreEditorInput)iEditorInput;
                FileStoreEditorInput cfr_ignored_0 = (FileStoreEditorInput)iEditorInput;
                IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
                String kernroot = p.getString("KernelSourcePreference");
                String filepath = input.getURI().getPath();
                String kernrelative = filepath.substring(kernroot.length() + 1, filepath.length());
                StringBuilder sb = new StringBuilder();
                sb.append("probe kernel.statement(\"*@" + kernrelative + ":" + (lineno + 1) + "\")");
                sb.append("\n{\n\t\n}\n");
                STPEditor activeSTPEditor = IDESessionSettings.getOrAskForActiveSTPEditor(false);
                if (activeSTPEditor != null) {
                    activeSTPEditor.insertText(sb.toString());
                }
            }
        }
        shell.setCursor(null);
        return null;
    }
}

